<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextWeb.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * JavaScript出力フレームワーク情報管理クラス
 */
require_once 'SyL_ContextJs.php';

/**
 * WEBアプリケーションフレームワーク情報管理クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_ContextWeb.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_ContextWeb extends SyL_ContextJs
{
    /**
     * ビュータイプ
     * 
     * @access protected
     * @var string
     */
    var $view_type = 'default';

    /**
     * ダウンロードファイルをセット
     *
     * ※ダウンロードファイル名を指定しない場合は、Content-Disposition: inline になる
     * 
     * @access public
     * @param string ダウンロードファイルパス
     * @param string ダウンロードファイル名
     * @param string コンテンツタイプ
     */
    function setDownloadFile($file, $filename='', $type='application/octet-stream')
    {
        $data = file_get_contents($file);
        if ($data === false) {
            trigger_error("[SyL error] Unable to get Download file ($file)", E_USER_ERROR);
        }
        $this->setDownloadData($data, $filename, $type);
    }

    /**
     * ダウンロードデータをセット
     * 
     * ※ダウンロードファイル名を指定しない場合は、Content-Disposition: inline になる
     *
     * @access public
     * @param string ダウンロードファイルパス
     * @param string ダウンロードファイル名
     * @param string コンテンツタイプ
     */
    function setDownloadData($data, $filename='', $type='application/octet-stream')
    {
        $this->router->setViewType('download');
        $this->setParameter('_download_name', $filename);
        $this->setParameter('_download_type', $type);
        $this->setParameter('_download_data', $data);
    }

    /**
     * 出力画像ファイルをセット
     *
     * @access public
     * @param string 画像ファイルパス
     * @param string コンテンツタイプ
     */
    function setDisplayImageFile($file, $type='')
    {
        if (!$type) {
            $size = getimagesize($file);
            if (!$size || !isset($size['mime'])) {
                trigger_error("[SyL error] Image mime unable to get from getimagesize function ({$file})", E_USER_ERROR);
            }
            $type = $size['mime'];
        }
        $data = @file_get_contents($file);
        if ($data === false) {
            trigger_error("[SyL error] Unable to get Image file ($file)", E_USER_ERROR);
        }
        $this->setDisplayImageData($data, $type);
    }

    /**
     * 出力画像データをセット
     *
     * @access public
     * @param string 画像バイナリデータ
     * @param string コンテンツタイプ
     */
    function setDisplayImageData($data, $type='')
    {
        $this->router->setViewType('image');
        $this->setParameter('_image_type',  $type);
        $this->setParameter('_image_data',  $data);
    }

    /**
     * XMLオブジェクト（SyL_XmlWriter）をセット
     *
     * @access public
     * @param object XMLオブジェクト
     * @param string コンテンツタイプ
     */
    function setDisplayXml($rss_object, $type='text/xml')
    {
        $this->router->setViewType('xml');
        $this->setParameter('_xml_type',    $type);
        $this->setParameter('_xml_object',  $rss_object);
    }

    /**
     * RSSオブジェクト（SyL_XmlRssWriter）をセット
     *
     * @access public
     * @param object RSSオブジェクト
     * @param string コンテンツタイプ
     */
    function setDisplayRss($rss_object, $type='text/xml')
    {
        $this->router->setViewType('rss');
        $this->setParameter('_rss_type',    $type);
        $this->setParameter('_rss_object',  $rss_object);
    }

    /**
     * リダイレクトURLをセット
     *
     * @access public
     * @param string リダイレクトURL
     */
    function setRedirectUrl($url)
    {
        $this->router->setViewType('redirect');
        $this->setParameter('_redirect_url', $url);
    }
}
