<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Logger.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ログ出力クラス
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Logger.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Logger
{
    /**
     * 即時出力フラグ
     * 
     * @access protected
     * @var bool
     */
    var $immediate = true;
    /**
     * 即時出力ではない場合に格納するバッファ
     * 
     * @access protected
     * @var array
     */
    var $buffer = array();
    /**
     * ロギング日付フォーマット
     * ※dateフォーマット
     * 
     * @access protected
     * @var string
     */
    var $datetime_format = 'Y-m-d H:i:s';
    /**
     * 改行コード
     * 
     * @access protected
     * @var string
     */
    var $eol = "\r\n";

    /**
     * コンストラクタ
     *
     * @access public
     * @param boolean ログ即時出力フラグ true: 即時出力、false: リクエスト終了後に出力
     */
    function SyL_Logger($immediate=true)
    {
        $this->immediate = $immediate;
    }

    /**
     * ログオブジェクトの取得
     *
     * @access public
     * @param string ログカテゴリ名
     * @param boolean ログ即時出力フラグ true: 即時出力、false: リクエスト終了後に出力
     * @return object ログオブジェクト
     */
    function &getLogger($type='', $immediate=true)
    {
        $logger_object = null;
        if ($type) {
            $classname = 'SyL_Logger' . ucfirst($type);
            include_once SYL_FRAMEWORK_DIR . "/core/Logger/{$classname}.php";
        } else {
            $classname = 'SyL_Logger';
        }
        $logger_object =& new $classname($immediate);
        return $logger_object;
    }

    /**
     * オープン
     *
     * @access public
     */
    function open()
    {
    }

    /**
     * ログの出力
     *
     * @access public
     * @param string ログレベル名
     * @param string メッセージ
     */
    function log($level, $message)
    {
    }

    /**
     * ログの全出力
     *
     * @access public
     */
    function logAll()
    {
        if (!$this->immediate) {
            while (true) {
                $buffer = array_shift($this->buffer);
                if (!$buffer) {
                    break;
                }
                $this->log('', $buffer);
            }
        }
    }

    /**
     * 閉じる
     *
     * @access public
     */
    function close()
    {
        $this->logAll();
    }

    /**
     * ロギングしているクラス／メソッドを取得
     *
     * @access protected
     * @return string ロギングしているクラス／メソッド
     */
    function getLoggingClass()
    {
        $funcname = '';
        $match    = false;
        foreach (debug_backtrace() as $debug) {
            if (isset($debug['class']) && isset($debug['function'])) {
                if (preg_match('/^SyL_(Logger|Error)/i', $debug['class']) ||
                    preg_match('/^(raiseEvent|errorStream)$/i', $debug['function'])) {
                    $match = true;
                } else {
                    $type = isset($debug['type']) ? $debug['type'] : '.';
                    $funcname = $debug['class'] . $type . $debug['function'] . '()';
                    if ($match) {
                        break;
                    }
                }
            }
        }
        return $funcname;
    }
}
