<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileReader.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ファイル読み込みクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FileReader.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_FileReader extends SyL_File
{
    /**
     * ファイルオープンモード
     * 
     * @access protected
     * @var string
     */
    var $mode = 'rb';
    /**
     * CSVコンバート用一時ディレクトリ
     * 
     * @access private
     * @var string
     */
    var $tmp_dir = '/tmp';
    /**
     * CSVコンバート用一次ファイル名
     * 
     * @access private
     * @var string
     */
    var $tmp_name = '';

    /**
     * 一時ディレクトリをセットする
     *
     * @access public
     * @param string 一時ディレクトリ
     */
    function setTmpDir($tmp_dir)
    {
        $this->tmp_dir = $tmp_dir;
    }

    /**
     * ファイルを開く
     *
     * @access public
     * @param string オープンモード
     */
    function open()
    {
        if ($this->csv && $this->encode_file) {
            $encode_script = $this->encode_script ? $this->encode_script : mb_internal_encoding();
            if (strtolower($this->encode_file) != strtolower($encode_script)) {
                $data = file_get_contents($this->resource_name);
                $data = mb_convert_encoding($data, $encode_script, $this->encode_file);

                $this->tmp_name = tempnam($this->tmp_dir, '__syl_file_');
                $writer =& SyL_File::factory('w', $this->tmp_name);
                $writer->process($data);

                $this->resource_name = $this->tmp_name;
                $this->encode_file   = $encode_script;
            }
        }
        parent::open();
    }

    /**
     * ファイルから読み込む
     *
     * @access public
     * @return string 入力データ or bool(false) 読み込み終了
     */
    function read()
    {
        if ($this->csv) {
            if ($this->csv_enclosure) {
                $data = fgetcsv($this->fp, 8192, $this->csv_delimiter, $this->csv_enclosure);
            } else {
                $data = fgetcsv($this->fp, 8192, $this->csv_delimiter);
            }
            return is_array($data) ? array_map(array(&$this, 'convertEncode'), $data) : $data;
        } else {
            $data = fgets($this->fp);
            return is_string($data) ? $this->convertEncode($data) : $data;
        }
    }

    /**
     * ファイルを閉じる
     *
     * @access public
     */
    function close()
    {
        parent::close();

        // CSV用一時ファイル削除
        if (file_exists($this->tmp_name)) {
            unlink($this->tmp_name);
        }
    }

    /**
     * 入力エンコーディングを変換する
     *
     * @access private
     * @param string エンコーディング変換前のファイルのデータ
     * @return string エンコーディング変換後のファイルのデータ
     */
    function convertEncode($data)
    {
        if ($this->encode_script) {
            return ($this->encode_file)
                 ? mb_convert_encoding($data, $this->encode_script, $this->encode_file)
                 : mb_convert_encoding($data, $this->encode_script);
        } else {
            return $data;
        }
    }
}
