<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementRadio.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ラジオボタンフォーム要素クラス
 *
 * 名前 : 要素部品名 : 要素名(name) : 値(value)
 *   1  :      n     :    1         :  n
 *
 * ○インスタンス作成方法
 * // 基底クラスからスタティックメソッドで取得
 * $SyL_FormElementText = SyL_FormElement::createElement( 'radio', 'gender', array( '1'=> '男', '2' => '女' ) );
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_FormElementRadio.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_FormElementRadio extends SyL_FormElement
{
    /**
     * ラベル用ID名
     *
     * @access private
     * @var string
     */
    var $label = '_radio';
    /**
     * 要素間の区切り文字
     *
     * @access private
     * @var string
     */
    var $separator = "&nbsp;\r\n";

    /**
     * 要素間の区切り文字をセット
     *
     * @access public
     * @param string 要素間の区切り文字
     */
    function setSeparator($separetor)
    {
        $this->separator = $separetor;
    }

    /**
     * フォーム要素HTML出力
     *
     * @access public
     * @return string フォーム要素のHTML
     */
    function getHtmlTag()
    {
        $this->setAttribute($this->name, 'name');
        $this->setAttribute($this->type, 'type');

        $i = 0;
        $options = array();
        foreach ($this->options as $key => $value) {
            $id = $this->label . '_' . $this->name . '_' . $i;
            $this->setAttribute($id, 'id');
            $this->setAttribute($key, 'value');
            $checked = ((string)$key === $this->value) ? 'checked' : '';

            $options[] = '<input ' . $this->getAttributes() . ' ' . $checked . ' /><label for="' . $id . '">' . $this->encode($value) . '</label>';
            $i++;
        }

        return implode($this->separator, $options);
    }

    /**
     * フォーム要素HTML出力
     *
     * @access public
     * @return string フォーム要素のHTML
     */
    function getHtmlView()
    {
        $label = '';
        foreach ($this->options as $key => $value) {
            if ((string)$key === $this->value) {
                $label = $value;
                break;
            }
        }
        return $this->encode($label) . $this->getHtmlHidden();
    }
}
