<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Validation.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 検証個別クラス
 */
require_once dirname(__FILE__) . '/Validation/SyL_ValidationValidator.php';
/**
 * 検証個別グループクラス
 */
require_once dirname(__FILE__) . '/Validation/SyL_ValidationValidators.php';

/**
 * 検証クラス
 * 
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_Validation.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_Validation
{
    /**
     * エラーメッセージ
     *
     * @access protected
     * @var string
     */
    var $error_message = '';

    /**
     * エラーメッセージを取得する
     *
     * @access public
     * @param string 要素名
     * @return string エラーメッセージ
     */
    function getErrorMessage()
    {
        return $this->error_message;
    }

    /**
     * エラーメッセージを取得する
     *
     * @access public
     * @param string 要素名
     */
    function replaceErrorMessage($name)
    {
        if ($name) {
            $this->error_message = str_replace(array('{name}', '%name%'), $name, $this->error_message);
        }
    }

    /**
     * 検証処理を実行する
     *
     * @access public
     * @param string 検証対象値
     * @param string 検証対象名
     * @return bool true: エラー無し, false: エラーあり
     */
    function execute($value, $name='')
    {
    }

    /**
     * 必須チェック存在判定
     *
     * @access public
     * @return bool true: 必須チェックあり、false: 必須チェック無し
     */
    function isRequire()
    {
        return preg_match('/^SyL_ValidationValidatorRequire(.*)$/i', get_class($this));
    }

    /**
     * JavaScript処理ロジックを取得する
     *
     * @access public
     * @param string フォーム要素表示名
     * @param array フォーム要素の部品配列（radio, select, checkboxの場合のみ）
     * @return string JavaScript処理ロジック
     */
    function getJs($display_name)
    {
        return '';
    }
}
