<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilEnv.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * 実行環境クラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2007 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_UtilEnv.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_UtilEnv
{
    /**
     * Windowsで動作しているか判定する
     *
     * @static
     * @access public
     * @return string アクセス中のスクリプトファイルのオーナー名
     */
    function isWindowsOs()
    {
        return (strtoupper(substr(PHP_OS, 0, 3)) == 'WIN');
    }

    /**
     * アクセス中のスクリプトファイルのオーナー名を取得する
     *
     * @static
     * @access public
     * @return string アクセス中のスクリプトファイルのオーナー名
     */
    function getScriptOwner()
    {
        return get_current_user();
    }

    /**
     * OSのユーザー名をユーザーIDから取得する
     *
     * @static
     * @access public
     * @param int ユーザーID
     * @return string ユーザー名
     */
    function getOsUser($user_id)
    {
        $user_name = '';
        if (!call_user_func(array(__CLASS__, 'isWindowsOs')) &&
            function_exists('posix_getpwuid')) {
            $user_info = posix_getpwuid($user_id);
            $user_name = $user_info['name'];
        }
        return $user_name;
    }

    /**
     * カレントプロセスのユーザー名を取得する
     *
     * @static
     * @access public
     * @return string ユーザー名
     */
    function getProcessUser()
    {
        $user_name = '';
        if (!call_user_func(array(__CLASS__, 'isWindowsOs')) &&
            function_exists('posix_getuid')) {
            $user_info = posix_getpwuid(posix_getuid());
            $user_name = $user_info['name'];
        }
        return $user_name;
    }
}
