<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketCatalogSearchRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天カタログ検索API用）
 */
require_once 'SyL_WebServiceMarketCatalogSearchResponse.php';

/**
 * WEBサービスクラス（楽天 - 楽天カタログ検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天カタログ検索API 
 *   http://webservice.rakuten.co.jp/api/catalogsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketCatalogSearchRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMarketCatalogSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMarketCatalogSearchResponse';

    /**
     * 検索キーワードをセットする
     *
     * @access public
     * @param string 検索キーワード
     */
    function setKeyword($keyword)
    {
        parent::set('keyword', $keyword);
    }

    /**
     * バージョンをセットする
     *
     * @access public
     * @param string バージョン
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * ジャンルIDをセットする
     *
     * @access public
     * @param int ジャンルID
     */
    function setGenreId($genreId)
    {
        if (preg_match('/^\d+$/', $genreId)) {
            parent::set('genreId', $genreId);
        } else {
            trigger_error("[SyL error] Invalid `genreId' property ({$genreId}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 1ページあたりの取得件数をセットする
     *
     * @access public
     * @param int 1ページあたりの取得件数
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits) && (($hits >= 1) && ($hits <= 30))) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 取得ページをセットする
     *
     * @access public
     * @param int 取得ページ
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page) && (($page >= 1) && ($page <= 100))) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ソートをセットする
     *
     * @access public
     * @param string ソート
     */
    function setSort($sort)
    {
        switch ($sort) {
        case '+registerDate':
        case '-registerDate':
        case '+releaseDate':
        case '-releaseDate':
        case '+reviewNum':
        case '-reviewNum':
        case 'random':
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索フィールドをセットする
     *
     * @access public
     * @param int 検索フィールド
     */
    function setField($field)
    {
        switch ((string)$field) {
        case '0':
        case '1':
            parent::set('field', $field);
            break;
        default:
            trigger_error("[SyL error] Invalid `field' property ({$field}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 商品画像有無フラグをセットする
     *
     * @access public
     * @param int 商品画像有無フラグ
     */
    function setImageFlag($imageFlag)
    {
        switch ((string)$imageFlag) {
        case '0':
        case '1':
            parent::set('imageFlag', $imageFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `imageFlag' property ({$imageFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 発売時期をセットする
     *
     * @access public
     * @param int 発売時期
     */
    function setReleaseRange($releaseRange)
    {
       if (preg_match('/^\d+$/', $releaseRange) && (($releaseRange >= 0) && ($releaseRange <= 12))) {
            parent::set('releaseRange', $releaseRange);
        } else {
            trigger_error("[SyL error] Invalid `releaseRange' property ({$releaseRange}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * OR検索フラグをセットする
     *
     * @access public
     * @param int OR検索フラグ
     */
    function setOrFlag($orFlag)
    {
        switch ((string)$orFlag) {
        case '0':
        case '1':
            parent::set('orFlag', $orFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `orFlag' property ({$orFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 除外キーワードをセットする
     *
     * @access public
     * @param string 除外キーワード
     */
    function setNGKeyword($NGKeyword)
    {
        parent::set('NGKeyword', $NGKeyword);
    }

    /**
     * ジャンルごとの商品数取得フラグをセットする
     *
     * @access public
     * @param int ジャンルごとの商品数取得フラグ
     */
    function setGenreInformationFlag($genreInformationFlag)
    {
        switch ((string)$genreInformationFlag) {
        case '0':
        case '1':
            parent::set('genreInformationFlag', $genreInformationFlag);
            break;
        default:
            trigger_error("[SyL error] Invalid `genreInformationFlag' property ({$genreInformationFlag}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
