<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketCatalogSearchResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天カタログ検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天カタログ検索API 
 *   http://webservice.rakuten.co.jp/api/catalogsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketCatalogSearchResponse.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMarketCatalogSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 検索数
     *
     * @access private
     * @var int
     */
    var $count = 0;
    /**
     * ページ番号
     *
     * @access private
     * @var int
     */
    var $page = 0;
    /**
     * ページ内商品始追番
     *
     * @access private
     * @var int
     */
    var $first = 0;
    /**
     * ページ内商品終追番
     *
     * @access private
     * @var int
     */
    var $last = 0;
    /**
     * ヒット件数
     *
     * @access private
     * @var int
     */
    var $hits = 0;
    /**
     * キャリア情報
     *
     * @access private
     * @var int
     */
    var $carrier = 0;
    /**
     * 総ページ数
     *
     * @access private
     * @var int
     */
    var $page_count = 0;
    /**
     * カタログ情報
     *
     * @access private
     * @var array
     */
    var $catalogs = array();
    /**
     * 自ジャンル
     *
     * @access private
     * @var array
     */
    var $current_genre = array();
    /**
     * 子ジャンル
     *
     * @access private
     * @var array
     */
    var $child_genres = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 検索数
        case '/Response/Body/catalogSearch:CatalogSearch/count': $this->count = $text; break;
        // ページ番号
        case '/Response/Body/catalogSearch:CatalogSearch/page': $this->page = $text; break;
        // ページ内商品始追番
        case '/Response/Body/catalogSearch:CatalogSearch/first': $this->first = $text; break;
        // ページ内商品終追番
        case '/Response/Body/catalogSearch:CatalogSearch/last': $this->last = $text; break;
        // ヒット件数
        case '/Response/Body/catalogSearch:CatalogSearch/hits': $this->hits = $text; break;
        // キャリア情報
        case '/Response/Body/catalogSearch:CatalogSearch/carrier': $this->carrier = $text; break;
        // 総ページ数
        case '/Response/Body/catalogSearch:CatalogSearch/pageCount': $this->page_count = $text; break;

        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog': $i++; break;
        // カタログ名称
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogName': $this->catalogs[$i]['catalogName'] = $text; break;
        // カタログコード
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogCode': $this->catalogs[$i]['catalogCode'] = $text; break;
        // 型番
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/modelNo': $this->catalogs[$i]['modelNo'] = $text; break;
        // メーカー名
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/makerName': $this->catalogs[$i]['makerName'] = $text; break;
        // シリーズ名
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/seriesName': $this->catalogs[$i]['seriesName'] = $text; break;
        // 発売日
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/onSaleDate': $this->catalogs[$i]['onSaleDate'] = $text; break;
        // 標準価格
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogPrice': $this->catalogs[$i]['catalogPrice'] = $text; break;
        // カタログ説明文
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogCaption': $this->catalogs[$i]['catalogCaption'] = $text; break;
        // カタログURL
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/catalogUrl': $this->catalogs[$i]['catalogUrl'] = $text; break;
        // カタログ画像有無フラグ
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/imageFlag': $this->catalogs[$i]['imageFlag'] = $text; break;
        // カタログ画像64x64URL
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/smallImageUrl': $this->catalogs[$i]['smallImageUrl'] = $text; break;
        // カタログ画像128x128URL
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/mediumImageUrl': $this->catalogs[$i]['mediumImageUrl'] = $text; break;
        // カタログレビュー件数
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/reviewCount': $this->catalogs[$i]['reviewCount'] = $text; break;
        // 発売日
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/onSaleDate': $this->catalogs[$i]['onSaleDate'] = $text; break;
        // カタログ所属ジャンルID
        case '/Response/Body/catalogSearch:CatalogSearch/Catalogs/Catalog/genreId': $this->catalogs[$i]['genreId'] = $text; break;

        // 自ジャンル: ジャンルID
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/current/genreId': $this->current_genre['genreId'] = $text; break;
        // 自ジャンル: ジャンル名
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/current/genreName': $this->current_genre['genreName'] = $text; break;
        // 自ジャンル: ジャンルに紐づく商品数
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/current/itemCount': $this->current_genre['itemCount'] = $text; break;
        // 自ジャンル: ジャンル階層
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/current/genreLevel': $this->current_genre['genreLevel'] = $text; break;

        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child': $j++; break;
        // 子ジャンル: ジャンルID
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child/genreId': $this->child_genres[$j]['genreId'] = $text; break;
        // 子ジャンル: ジャンル名
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child/genreName': $this->child_genres[$j]['genreName'] = $text; break;
        // 子ジャンル: ジャンルに紐づく商品数
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child/itemCount': $this->child_genres[$j]['itemCount'] = $text; break;
        // 子ジャンル: ジャンル階層
        case '/Response/Body/catalogSearch:CatalogSearch/GenreInformation/child/genreLevel': $this->child_genres[$j]['genreLevel'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 検索数を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getCount()
    {
        return $this->count;
    }

    /**
     * ページ番号を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getPage()
    {
        return $this->page;
    }

    /**
     * ページ内商品始追番を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getFirst()
    {
        return $this->first;
    }

    /**
     * ページ内商品終追番を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getLast()
    {
        return $this->last;
    }

    /**
     * キャリア情報を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getCarrier()
    {
        return $this->carrier;
    }

    /**
     * 総ページ数を取得する
     *
     * @access public
     * @return int 検索数
     */
    function getPageCount()
    {
        return $this->page_count;
    }

    /**
     * カタログ情報を取得する
     *
     * @access public
     * @return array カタログ情報
     */
    function getCatalogs()
    {
        return $this->catalogs;
    }

    /**
     * 自ジャンルを取得する
     *
     * @access public
     * @param string キー名
     * @return mixed 自ジャンル
     */
    function getCurrentGenre($name=null)
    {
        if ($name !== null) {
            return isset($this->current_genre[$name]) ? $this->current_genre[$name] : null;
        } else {
            return $this->current_genre;
        }
    }

    /**
     * 子ジャンルを取得する
     *
     * @access public
     * @return array 子ジャンル
     */
    function getChildGenres()
    {
        return $this->child_genres;
    }
}
