<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketGenreSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天ジャンル検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天ジャンル検索API 
 *   http://webservice.rakuten.co.jp/api/genresearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMarketGenreSearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMarketGenreSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 親ジャンル
     *
     * @access private
     * @var array
     */
    var $parent = array();
    /**
     * 自ジャンル
     *
     * @access private
     * @var array
     */
    var $current = array();
    /**
     * 子ジャンル
     *
     * @access private
     * @var array
     */
    var $childs = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 親ジャンル: ジャンルID
        case '/Response/Body/genreSearch:GenreSearch/parent/genreId': $this->parent['genreId'] = $text; break;
        // 親ジャンル: ジャンル名
        case '/Response/Body/genreSearch:GenreSearch/parent/genreName': $this->parent['genreName'] = $text; break;
        // 親ジャンル: ジャンル階層
        case '/Response/Body/genreSearch:GenreSearch/parent/genreLevel': $this->parent['genreLevel'] = $text; break;

        // 自ジャンル: ジャンルID
        case '/Response/Body/genreSearch:GenreSearch/current/genreId': $this->current['genreId'] = $text; break;
        // 自ジャンル: ジャンル名
        case '/Response/Body/genreSearch:GenreSearch/current/genreName': $this->current['genreName'] = $text; break;
        // 自ジャンル: ジャンル階層
        case '/Response/Body/genreSearch:GenreSearch/current/genreLevel': $this->current['genreLevel'] = $text; break;

        case '/Response/Body/genreSearch:GenreSearch/child': $i++; break;
        // 子ジャンル: ジャンルID
        case '/Response/Body/genreSearch:GenreSearch/child/genreId': $this->childs[$i]['genreId'] = $text; break;
        // 子ジャンル: ジャンル名
        case '/Response/Body/genreSearch:GenreSearch/child/genreName': $this->childs[$i]['genreName'] = $text; break;
        // 子ジャンル: ジャンル階層
        case '/Response/Body/genreSearch:GenreSearch/child/genreLevel': $this->childs[$i]['genreLevel'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 親ジャンルを取得する
     *
     * @access public
     * @param string キー名
     * @return mixed 親ジャンル
     */
    function getParent($name=null)
    {
        if ($name !== null) {
            return isset($this->parent[$name]) ? $this->parent[$name] : null;
        } else {
            return $this->parent;
        }
    }

    /**
     * 自ジャンルを取得する
     *
     * @access public
     * @param string キー名
     * @return mixed 自ジャンル
     */
    function getCurrent($name=null)
    {
        if ($name !== null) {
            return isset($this->current[$name]) ? $this->current[$name] : null;
        } else {
            return $this->current;
        }
    }

    /**
     * 子ジャンルを取得する
     *
     * @access public
     * @return array 子ジャンル
     */
    function getChilds()
    {
        return $this->childs;
    }
}
