<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelGetAreaClassResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天トラベル地区コードAPI用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天トラベル地区コードAPI  
 *   http://webservice.rakuten.co.jp/api/getareaclass/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelGetAreaClassResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceTravelGetAreaClassResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 区分情報
     *
     * @access private
     * @var array
     */
    var $largeClasses = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;
        static $j = -1;
        static $k = -1;
        static $l = -1;
        
        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 大区分
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass':
            $i++;
            $j = -1;
            $k = -1;
            $l = -1;
            break;
        // 大区分コード
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/largeClassCode':
            $this->largeClasses[$i]['largeClassCode'] = $text;
            break;
        // 大区分名称
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/largeClassName':
            $this->largeClasses[$i]['largeClassName'] = $text;
            break;

        // 中区分
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass':
            $j++;
            $k = -1;
            $l = -1;
            //$this->largeClasses[$i]['middleClass'] = array();
            break;
        // 中区分コード
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass/middleClassCode':
            $this->largeClasses[$i]['middleClass'][$j]['middleClassCode'] = $text;
            break;
        // 中区分名称
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass/middleClassName':
            $this->largeClasses[$i]['middleClass'][$j]['middleClassName'] = $text;
            break;

        // 小区分
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass/smallClass':
            $k++;
            $l = -1;
            //$this->largeClasses[$i]['middleClass'][$j]['smallClass'] = array();
            break;
        // 小区分コード
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass/smallClass/smallClassCode':
            $this->largeClasses[$i]['middleClass'][$j]['smallClass'][$k]['smallClassCode'] = $text;
            break;
        // 小区分名称
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass/smallClass/smallClassName':
            $this->largeClasses[$i]['middleClass'][$j]['smallClass'][$k]['smallClassName'] = $text;
            break;

        // 細区分
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass/smallClass/detailClass':
            $l++;
            //$this->largeClasses[$i]['middleClass'][$j]['smallClass'][$k]['detailClass'] = array();
            break;
        // 細区分コード
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass/smallClass/detailClass/detailClassCode':
            $this->largeClasses[$i]['middleClass'][$j]['smallClass'][$k]['detailClass'][$l]['detailClassCode'] = $text;
            break;
        // 細区分名称
        case '/Response/Body/getAreaClass:GetAreaClass/largeClass/middleClass/smallClass/detailClass/detailClassName':
            $this->largeClasses[$i]['middleClass'][$j]['smallClass'][$k]['detailClass'][$l]['detailClassName'] = $text;
            break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 区分情報を取得する
     *
     * @access public
     * @return array 区分情報
     */
    function getLargeClasses()
    {
        return $this->largeClasses;
    }
}
