<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelSimpleHotelSearchRequest.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天トラベル施設検索API用）
 */
require_once 'SyL_WebServiceTravelSimpleHotelSearchResponse.php';

/**
 * WEBサービスクラス（楽天 - 楽天トラベル施設検索API用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天トラベル施設検索API 
 *   http://webservice.rakuten.co.jp/api/simplehotelsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelSimpleHotelSearchRequest.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceTravelSimpleHotelSearchRequest extends SyL_WebServiceRakuten_co_jpRequest
{
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/rws/1.11/rest';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceTravelSimpleHotelSearchResponse';

    /**
     * バージョンをセットする
     *
     * @access public
     * @param string バージョン
     */
    function setVersion($version)
    {
        parent::set('version', $version);
    }

    /**
     * 大区分コードをセットする
     *
     * @access public
     * @param string 大区分コード
     */
    function setLargeClassCode($largeClassCode)
    {
        parent::set('largeClassCode', $largeClassCode);
    }

    /**
     * 中区分コードをセットする
     *
     * @access public
     * @param string 中区分コード
     */
    function setMiddleClassCode($middleClassCode)
    {
        parent::set('middleClassCode', $middleClassCode);
    }

    /**
     * 小区分コードをセットする
     *
     * @access public
     * @param string 小区分コード
     */
    function setSmallClassCode($smallClassCode)
    {
        parent::set('smallClassCode', $smallClassCode);
    }

    /**
     * 細区分コードをセットする
     *
     * @access public
     * @param string 細区分コード
     */
    function setDetailClassCode($detailClassCode)
    {
        parent::set('detailClassCode', $detailClassCode);
    }

    /**
     * 施設番号をセットする
     *
     * @access public
     * @param int 施設番号
     */
    function setHotelNo($hotelNo)
    {
        foreach (explode(',', $hotelNo) as $tmp) {
            if (!preg_match('/^\d+$/', $tmp)) {
                trigger_error("[SyL error] Invalid `hotelNo' property ({$hotelNo}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('hotelNo', $hotelNo);
    }

    /**
     * 緯度をセットする
     *
     * @access public
     * @param int 緯度
     */
    function setLatitude($latitude)
    {
        if (preg_match('/^\d+(\.\d+)?$/', $latitude)) {
            parent::set('latitude', $latitude);
        } else {
            trigger_error("[SyL error] Invalid `latitude' property ({$latitude}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 経度をセットする
     *
     * @access public
     * @param int 経度
     */
    function setLongitude($longitude)
    {
        if (preg_match('/^\d+(\.\d+)?$/', $longitude)) {
            parent::set('longitude', $longitude);
        } else {
            trigger_error("[SyL error] Invalid `longitude' property ({$longitude}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索半径をセットする
     *
     * @access public
     * @param int 検索半径 (0.1以上、3.0以下)
     */
    function setSearchRadius($searchRadius)
    {
        if (preg_match('/^\d(\.\d)?$/', $searchRadius) && ((float)$searchRadius >= 0.1) && ((float)$searchRadius <= 3.0)) {
            parent::set('searchRadius', $searchRadius);
        } else {
            trigger_error("[SyL error] Invalid `searchRadius' property ({$searchRadius}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 絞込み条件をセットする
     *
     * @access public
     * @param string 絞込み条件
     */
    function setSqueezeCondition($squeezeCondition)
    {
        foreach (explode(',', $squeezeCondition) as $tmp) {
            switch ($tmp) {
            case 'kinen':
            case 'internet':
            case 'daiyoku':
            case 'onsen':
                break;
            default:
                trigger_error("[SyL error] Invalid `squeezeCondition' property ({$squeezeCondition}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        }
        parent::set('squeezeCondition', $squeezeCondition);
    }

    /**
     * キャリアをセットする
     *
     * @access public
     * @param int キャリア
     */
    function setCarrier($carrier)
    {
        switch ((string)$carrier) {
        case '0':
        case '1':
            parent::set('carrier', $carrier);
            break;
        default:
            trigger_error("[SyL error] Invalid `carrier' property ({$carrier}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 取得件数をセットする
     *
     * @access public
     * @param int 取得件数
     */
    function setHits($hits)
    {
        if (preg_match('/^\d+$/', $hits)) {
            parent::set('hits', $hits);
        } else {
            trigger_error("[SyL error] Invalid `hits' property ({$hits}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 緯度経度タイプをセットする
     *
     * @access public
     * @param int  緯度経度タイプ
     */
    function setDatumType($datumType)
    {
        switch ((string)$datumType) {
        case '1': // 世界測地系、単位は度
        case '2': // 日本測地系、単位は秒
            parent::set('datumType', $datumType);
            break;
        default:
            trigger_error("[SyL error] Invalid `datumType' property ({$datumType}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
