<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelSimpleHotelSearchResponse.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（楽天 - 楽天トラベル施設検索API 用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 * 楽天トラベル施設検索API  
 *   http://webservice.rakuten.co.jp/api/simplehotelsearch/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceTravelSimpleHotelSearchResponse.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceTravelSimpleHotelSearchResponse extends SyL_WebServiceRakuten_co_jpResponse
{
    /**
     * 施設情報
     *
     * @access private
     * @var array
     */
    var $hotels = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel': $i++; break;
        // 施設番号
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/hotelNo': $this->hotels[$i]['hotelNo'] = $text; break;
        // 施設名称
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/hotelName': $this->hotels[$i]['hotelName'] = $text; break;
        // 施設かな名称
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/hotelKanaName': $this->hotels[$i]['hotelKanaName'] = $text; break;
        // 施設特色
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/hotelSpecial': $this->hotels[$i]['hotelSpecial'] = $text; break;
        // チェックイン時刻
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/checkinTime': $this->hotels[$i]['checkinTime'] = $text; break;
        // チェックアウト時刻
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/checkoutTime': $this->hotels[$i]['checkoutTime'] = $text; break;
        // 緯度
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/latitude': $this->hotels[$i]['latitude'] = $text; break;
        // 経度
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/longitude': $this->hotels[$i]['longitude'] = $text; break;
        // 郵便番号
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/postalCode': $this->hotels[$i]['postalCode'] = $text; break;
        // 住所１
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/address1': $this->hotels[$i]['address1'] = $text; break;
        // 住所２
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/address2': $this->hotels[$i]['address2'] = $text; break;
        // 送料フラグ
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/postageFlag': $this->hotels[$i]['postageFlag'] = $text; break;
        // 施設電話番号
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/telephoneNo': $this->hotels[$i]['telephoneNo'] = $text; break;
        // ファックス番号
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/faxNo': $this->hotels[$i]['faxNo'] = $text; break;
        // 施設へのアクセス
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/access': $this->hotels[$i]['access'] = $text; break;
        // 最寄駅名称
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/nearestStationName': $this->hotels[$i]['nearestStationName'] = $text; break;
        // 駐車場情報
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/parkingInformation': $this->hotels[$i]['parkingInformation'] = $text; break;
        // ホテル種別コード
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/hotelClassCode': $this->hotels[$i]['hotelClassCode'] = $text; break;
        // 施設画像URL
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/hotelImageUrl': $this->hotels[$i]['hotelImageUrl'] = $text; break;
        // 施設情報ページURL
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/hotelInformationUrl': $this->hotels[$i]['hotelInformationUrl'] = $text; break;
        // 施設情報ページアフィリエイトURL
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/hotelAffiliateUrl': $this->hotels[$i]['hotelAffiliateUrl'] = $text; break;
        // 宿泊予約センター電話番号
        case '/Response/Body/simpleHotelSearch:SimpleHotelSearch/hotel/reserveTelephoneNo': $this->hotels[$i]['reserveTelephoneNo'] = $text; break;

        // 上記以外
        default: parent::getElement($current_path, $attribute, $text);
        }
    }

    /**
     * 施設情報を取得する
     *
     * @access public
     * @return array 施設情報
     */
    function getHotels()
    {
        return $this->hotels;
    }
}
