<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRakuten_co_jp.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスリクエストクラス（楽天）
 */
require_once dirname(__FILE__) . '/Rakuten_co_jp/SyL_WebServiceRakuten_co_jpRequest.php';
/**
 * WEBサービスレスポンスクラス（楽天）
 */
require_once dirname(__FILE__) . '/Rakuten_co_jp/SyL_WebServiceRakuten_co_jpResponse.php';

/**
 * WEBサービスクラス（楽天用）
 *
 * 詳細は、楽天ウェブサービスセンター参照
 *   http://webservice.rakuten.co.jp/
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceRakuten_co_jp.php,v 1.1 2009/01/11 05:34:30 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceRakuten_co_jp extends SyL_WebService
{
    // -----------------------------------------------------
    // 楽天市場系API
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天商品検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天商品検索API用）
     */
    function &createItemSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceMarketItemSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Market/ItemSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('ItemSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天ジャンル検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天ジャンル検索API用）
     */
    function &createGenreSearchRequest($version='2007-04-11')
    {
        $class_name = 'SyL_WebServiceMarketGenreSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Market/GenreSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('GenreSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天商品コード検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天商品コード検索API用）
     */
    function &createItemCodeSearchRequest($version='2007-04-11')
    {
        $class_name = 'SyL_WebServiceMarketItemCodeSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Market/ItemCodeSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('ItemCodeSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天カタログ検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天カタログ検索API用）
     */
    function &createCatalogSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceMarketCatalogSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Market/CatalogSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('CatalogSearch');
        $request->setVersion($version);
        return $request;
    }


    // -----------------------------------------------------
    // 楽天ブックス系API
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天書籍検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天書籍検索API用）
     */
    function &createBookSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceBooksBookSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Books/BookSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('BookSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天CD検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天CD検索API用）
     */
    function &createCDSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceBooksCDSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Books/CDSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('CDSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天DVD検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天DVD検索API用）
     */
    function &createDVDSearchRequest($version='2007-10-25')
    {
        $class_name = 'SyL_WebServiceBooksDVDSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Books/DVDSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('DVDSearch');
        $request->setVersion($version);
        return $request;
    }


    // -----------------------------------------------------
    // 楽天オークション系API
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天オークション商品検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天オークション商品検索API用）
     */
    function &createAuctionItemSearchRequest($version='2007-12-13')
    {
        $class_name = 'SyL_WebServiceAuctionAuctionItemSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Auction/AuctionItemSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('AuctionItemSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天オークション商品コード検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天オークション商品コード検索API用）
     */
    function &createAuctionItemCodeSearchRequest($version='2007-12-13')
    {
        $class_name = 'SyL_WebServiceAuctionAuctionItemCodeSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Auction/AuctionItemCodeSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('AuctionItemCodeSearch');
        $request->setVersion($version);
        return $request;
    }


    // -----------------------------------------------------
    // 楽天トラベル系API
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天トラベル施設検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天トラベル施設検索API用）
     */
    function &createSimpleHotelSearchRequest($version='2007-11-21')
    {
        $class_name = 'SyL_WebServiceTravelSimpleHotelSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/SimpleHotelSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('SimpleHotelSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天トラベル施設情報API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天トラベル施設情報API用）
     */
    function &createHotelDetailSearchRequest($version='2007-11-21')
    {
        $class_name = 'SyL_WebServiceTravelHotelDetailSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/HotelDetailSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('HotelDetailSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天トラベル空室検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天トラベル空室検索API用）
     */
    function &createVacantHotelSearchRequest($version='2008-02-14')
    {
        $class_name = 'SyL_WebServiceTravelVacantHotelSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/VacantHotelSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('VacantHotelSearch');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天トラベル地区コードAPI用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天トラベル地区コードAPI用）
     */
    function &createGetAreaClassRequest($version='2008-02-14')
    {
        $class_name = 'SyL_WebServiceTravelGetAreaClassRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/GetAreaClass/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('GetAreaClass');
        $request->setVersion($version);
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天トラベルキーワード検索API用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天トラベルキーワード検索API用）
     */
    function &createKeywordHotelSearchRequest($version='2007-09-19')
    {
        $class_name = 'SyL_WebServiceTravelKeywordHotelSearchRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Travel/KeywordHotelSearch/' . $class_name . '.php';
        $request =& new $class_name();
        $request->setOperation('KeywordHotelSearch');
        $request->setVersion($version);
        return $request;
    }


    // -----------------------------------------------------
    // その他のAPI
    // -----------------------------------------------------

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天ダイナミックアドAPI用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天ダイナミックアドAPI用）
     */
    function &createDynamicRequest()
    {
        $class_name = 'SyL_WebServiceAdDynamicRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Ad/Dynamic/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }

    /**
     * WEBサービスリクエストオブジェクトを作成する（楽天ダイナミックアドAPI　トラベル用）
     * 
     * @access public
     * @param string バージョン
     * @return object WEBサービスリクエストオブジェクト（楽天ダイナミックアドAPI　トラベル用）
     */
    function &createDynamicTravelRequest()
    {
        $class_name = 'SyL_WebServiceAdDynamicTravelRequest';
        include_once dirname(__FILE__) . '/Rakuten_co_jp/Ad/DynamicTravel/' . $class_name . '.php';
        $request =& new $class_name();
        return $request;
    }
}
