<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryLeafRequest.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - オークション - 商品リスト用）
 */
require_once 'SyL_WebServiceAuctionCategoryLeafResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - オークション - 商品リスト用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * オークション - 商品リスト
 *   http://developer.yahoo.co.jp/auctions/rest/categoryleaf/V1/categoryleaf.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryLeafRequest.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAuctionCategoryLeafRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'auctions.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/AuctionWebService/V1/CategoryLeaf';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceAuctionCategoryLeafResponse';

    /**
     * カテゴリIDをセットする
     *
     * @access public
     * @param int カテゴリID
     */
    function setCategory($categoy)
    {
        if (preg_match('/^\d+$/', $categoy)) {
            parent::set('category', $categoy);
        } else {
            trigger_error("[SyL error] Invalid `categoy' property ({$categoy}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 商品リストのページ番号をセットする
     *
     * @access public
     * @param int 商品リストのページ番号
     */
    function setPage($page)
    {
        if (preg_match('/^\d+$/', $page) && ($page > 0)) {
            parent::set('page', $page);
        } else {
            trigger_error("[SyL error] Invalid `page' property ({$page}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 商品の出品区分をセットする
     *
     * @access public
     * @param int 商品の出品区分
     */
    function setStore($store)
    {
        switch ((string)$store) {
        case '0': // すべての商品
        case '1': // オークションストアの出品
        case '2': // 一般の出品者の出品
            parent::set('store', $store);
            break;
        default:
            trigger_error("[SyL error] Invalid `store' property ($store) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 受け取り後決済サービスの利用可能な商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 受け取り後決済サービスの利用可能な商品の絞り込み指定
     */
    function setEscrow($escrow)
    {
        if (preg_match('/^\d+$/', $escrow)) {
            parent::set('escrow', $escrow);
        } else {
            trigger_error("[SyL error] Invalid `escrow' property ({$escrow}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * Yahoo!かんたん決済の利用が可能な商品の絞り込み指定をセットする
     *
     * @access public
     * @param int Yahoo!かんたん決済の利用が可能な商品の絞り込み指定
     */
    function setEasypayment($easypayment)
    {
        if (preg_match('/^\d+$/', $easypayment)) {
            parent::set('easypayment', $easypayment);
        } else {
            trigger_error("[SyL error] Invalid `easypayment' property ({$easypayment}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * newアイコンのついた商品の絞り込み指定をセットする
     *
     * @access public
     * @param int newアイコンのついた商品の絞り込み指定
     */
    function setNew($new)
    {
        if (preg_match('/^\d+$/', $new)) {
            parent::set('new', $new);
        } else {
            trigger_error("[SyL error] Invalid `new' property ({$new}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 特大画像付きの商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 特大画像付きの商品の絞り込み指定
     */
    function setLargeimg($largeimg)
    {
        if (preg_match('/^\d+$/', $largeimg)) {
            parent::set('largeimg', $largeimg);
        } else {
            trigger_error("[SyL error] Invalid `largeimg' property ({$largeimg}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 送料無料の商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 送料無料の商品の絞り込み指定
     */
    function setFreeshipping($freeshipping)
    {
        if (preg_match('/^\d+$/', $freeshipping)) {
            parent::set('freeshipping', $freeshipping);
        } else {
            trigger_error("[SyL error] Invalid `freeshipping' property ({$freeshipping}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 贈答品向き商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 贈答品向き商品の絞り込み指定
     */
    function setWrappingicon($wrappingicon)
    {
        if (preg_match('/^\d+$/', $wrappingicon)) {
            parent::set('wrappingicon', $wrappingicon);
        } else {
            trigger_error("[SyL error] Invalid `wrappingicon' property ({$wrappingicon}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 即買商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 即買商品の絞り込み指定
     */
    function setBuynow($buynow)
    {
        if (preg_match('/^\d+$/', $buynow)) {
            parent::set('buynow', $buynow);
        } else {
            trigger_error("[SyL error] Invalid `buynow' property ({$buynow}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 画像ありの商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 画像ありの商品の絞り込み指定
     */
    function setThumbnail($thumbnail)
    {
        if (preg_match('/^\d+$/', $thumbnail)) {
            parent::set('thumbnail', $thumbnail);
        } else {
            trigger_error("[SyL error] Invalid `thumbnail' property ({$thumbnail}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 注目のオークションの商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 注目のオークションの商品の絞り込み指定
     */
    function setAttn($attn)
    {
        if (preg_match('/^\d+$/', $attn)) {
            parent::set('attn', $attn);
        } else {
            trigger_error("[SyL error] Invalid `attn' property ({$attn}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 目立ちアイコンのついた商品の絞り込み指定をセットする
     *
     * @access public
     * @param int 目立ちアイコンのついた商品の絞り込み指定
     */
    function setGift_icon($gift_icon)
    {
        switch ((string)$gift_icon) {
        case '0': // 指定なし
        case '1': // 新品
        case '2': // 美品
        case '3': // 非売品
        case '4': // 限定品
        case '5': // 保証書付
        case '6': // 全巻セット
        case '7': // 正規店購入
        case '8': // 産地直送
            parent::set('gift_icon', $gift_icon);
            break;
        default:
            trigger_error("[SyL error] Invalid `gift_icon' property ({$gift_icon}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 商品リストのソート項目の指定をセットする
     *
     * @access public
     * @param string 商品リストのソート項目の指定
     */
    function setSort($sort)
    {
        switch ($sort) {
        case 'img': // 画像ありなし
        case 'item': // タイトル
        case 'cbids': // 現在価格
        case 'bids ': // 入札数
        case 'end': // 終了時間
            parent::set('sort', $sort);
            break;
        default:
            trigger_error("[SyL error] Invalid `sort' property ({$sort}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * ソートの順序の指定をセットする
     *
     * @access public
     * @param string ソートの順序の指定
     */
    function setOrder($order)
    {
        switch ($order) {
        case 'a': // 昇順
        case 'd': // 降順
            parent::set('order', $order);
            break;
        default:
            trigger_error("[SyL error] Invalid `order' property ({$order}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
