<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryTreeResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - オークション - カテゴリ情報用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * オークション - カテゴリ情報
 *   http://developer.yahoo.co.jp/auctions/rest/categorytree/V1/categorytree.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceAuctionCategoryTreeResponse.php,v 1.1 2009/01/11 05:34:34 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceAuctionCategoryTreeResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * カテゴリID
     *
     * @access private
     * @var int
     */
     var $category_id = null;
    /**
     * カテゴリ名
     *
     * @access private
     * @var string
     */
    var $category_name = null;
    /**
     * 最上位カテゴリからのパス
     *
     * @access private
     * @var string
     */
    var $category_path = null;
    /**
     * 親カテゴリのパス
     *
     * @access private
     * @var string
     */
    var $parent_category_path = null;
    /**
     * 末端カテゴリ判定
     *
     * @access private
     * @var bool
     */
    var $is_leaf = false;
    /**
     * 子カテゴリ数
     *
     * @access private
     * @var int
     */
    var $child_category_num = null;
    /**
     * 子カテゴリ情報
     *
     * @access private
     * @var array
     */
    var $child_category = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $category_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // カテゴリID
        case '/category/categoryId': $this->category_id = $text; break;
        // カテゴリの名前
        case '/category/categoryName': $this->category_name = $text; break;
        // 最上位カテゴリからのパス
        case '/category/categoryPath': $this->category_path = $text; break;
        // 親カテゴリからのパス
        case '/category/parentCategoryPath': $this->parent_category_path = $text; break;
        // 末端カテゴリ判定
        case '/category/isLeaf': $this->is_leaf = ($text == 'true'); break;
        // 子カテゴリの数
        case '/category/childCategoryNum': $this->child_category_num = $text; break;

        // 子カテゴリ情報
        case '/category/childCategory': $category_i++; break;
        // 子カテゴリのID
        case '/category/childCategory/categoryId': $this->child_category[$category_i]['categoryId'] = $text; break;
        // 子カテゴリの名前
        case '/category/childCategory/categoryName': $this->child_category[$category_i]['categoryName'] = $text; break;
        // 子カテゴリのオークション数（商品数）
        case '/category/childCategory/numOfAuctions': $this->child_category[$category_i]['numOfAuctions'] = $text; break;
        // 末端カテゴリ判定
        case '/category/childCategory/isLeaf': $this->child_category[$category_i]['isLeaf'] = ($text == 'true'); break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * カテゴリのIDを取得
     *
     * @access public
     * @return int カテゴリのID
     */
    function getCategoryId()
    {
        return $this->category_id;
    }

    /**
     * カテゴリの名前を取得
     *
     * @access public
     * @return string カテゴリの名前
     */
    function getCategoryName()
    {
        return $this->category_name;
    }

    /**
     * 最上位カテゴリからのパスを取得
     *
     * @access public
     * @return string 最上位カテゴリからのパス
     */
    function getCategoryPath()
    {
        return $this->category_path;
    }

    /**
     * 親カテゴリのパスを取得
     *
     * @access public
     * @return string 親カテゴリのパス
     */
    function getParentCategoryPath()
    {
        return $this->parent_category_path;
    }

    /**
     * 末端カテゴリ判定
     *
     * @access public
     * @return bool 末端カテゴリ判定
     */
    function isLeaf()
    {
        return $this->is_leaf;
    }

    /**
     * 子カテゴリ数を取得
     *
     * @access public
     * @return int 子カテゴリ数
     */
    function getChildCategoryNum()
    {
        return $this->child_category_num;
    }

    /**
     * 子カテゴリを取得
     *
     * @access public
     * @return array 子カテゴリ
     */
    function getChildCategory()
    {
        return $this->child_category;
    }
}
