<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMapLocalSearchRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 地図情報 - ローカルサーチAPI）
 */
require_once 'SyL_WebServiceMapLocalSearchResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - 地図情報 - ローカルサーチAPI）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 地図情報 - ローカルサーチAPI
 *   http://developer.yahoo.co.jp/map/localsearch/V1/localsearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMapLocalSearchRequest.php,v 1.1 2009/01/11 05:34:32 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMapLocalSearchRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'map.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/LocalSearchService/V1/LocalSearch';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceMapLocalSearchResponse';

    /**
     * 検索キーワードをセットする
     *
     * @access public
     * @param string 検索キーワード
     */
    function setP($p)
    {
        parent::set('p', $p);
    }

    /**
     * 緯度をセットする
     *
     * @access public
     * @param string 緯度
     */
    function setLat($lat)
    {
        parent::set('lat', $lat);
    }

    /**
     * 経度をセットする
     *
     * @access public
     * @param string 経度
     */
    function setLon($lon)
    {
        parent::set('lon', $lon);
    }

    /**
     * 距離（単位km）をセットする
     *
     * @access public
     * @param float 距離（単位km）
     */
    function setDist($dist)
    {
        if (is_numeric($dist)) {
            parent::set('dist', $dist);
        } else {
            trigger_error("[SyL error] Invalid `dist' property ({$dist}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索対象カテゴリをセットする
     *
     * @access public
     * @param string 検索対象カテゴリ
     */
    function setCategory($category)
    {
        switch ($category) {
        case 'address':  // 住所を対象に検索 
        case 'zipcode':  // 郵便番号を対象に検索 
        case 'landmark': // 施設（役所、学校、病院、郵便局など）を対象に検索 
        case 'station':  // 駅を対象に検索
        case 'courpon':  // Yahoo!クーポンを対象に検索
            parent::set('category', $category);
            break;
        default:
            trigger_error("[SyL error] Invalid `category' property ({$category}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 表示開始位置をセットする
     *
     * @access public
     * @param int 表示開始位置
     */
    function setB($b)
    {
        if (preg_match('/^\d+$/', $b)) {
            $results = isset($this->parameters['n']) ? $this->parameters['n'] : 10;
            if (($b + $results - 1) <= 100) {
                parent::set('b', $b);
            } else {
                trigger_error("[SyL error] Invalid `b' property ({$b}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        } else {
            trigger_error("[SyL error] Invalid `b' property ({$b}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 表示件数をセットする
     *
     * @access public
     * @param int 表示件数
     */
    function setN($n)
    {
        if (preg_match('/^\d+$/', $n) && (($n >= 0) && ($n <= 100))) {
            parent::set('n', $n);
        } else {
            trigger_error("[SyL error] Invalid `n' property ({$n}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 出力タイプをセットする
     *
     * @access public
     * @param string 出力タイプ
     */
    function setO($o)
    {
        switch ($o) {
        case 'xml':
        //case 'json': // ※本ライブラリでは未対応
            parent::set('o', $o);
            break;
        default:
            trigger_error("[SyL error] Invalid `o' property ({$o}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 緯度経度の測地系をセットする
     *
     * @access public
     * @param string 緯度経度の測地系
     */
    function setDatum($datum)
    {
        switch ($datum) {
        case 'tky':
        case 'wgs':
            parent::set('datum', $datum);
            break;
        default:
            trigger_error("[SyL error] Invalid `datum' property ({$datum}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 住所レベルの絞り込みをセットする
     *
     * @access public
     * @param int 住所レベルの絞り込み
     */
    function setAl($al)
    {
        switch ((string)$al) {
        case '1': // 市区町村レベル
        case '2': // 町、大字レベル
        case '3': // 丁目、字レベル
            parent::set('al', $al);
            break;
        default:
            trigger_error("[SyL error] Invalid `al' property ({$al}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }
}
