<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertExamResponse.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - みんなの検定 検定受験Webサービス）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * みんなの検定 検定受験Webサービス
 *   http://developer.yahoo.co.jp/minna_cert/certexam/V1/certexam.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceMinnaCertCertExamResponse.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceMinnaCertCertExamResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * 検定データ配列
     *
     * @access private
     * @var array
     */
    var $result = array();
    /**
     * 評価データ配列
     *
     * @access private
     * @var array
     */
    var $result_eval = array();
    /**
     * 評価詳細データ配列
     *
     * @access private
     * @var array
     */
    var $result_evals = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i   = -1;
        static $q_i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        // 検定のID
        case '/ResultSet/Result/CertId': $this->result['CertId'] = $text; break;
        // 検定名
        case '/ResultSet/Result/CertName': $this->result['CertName'] = $text; break;
        // 検定画像のURL
        case '/ResultSet/Result/CertImageUrl': $this->result['CertImageUrl'] = $text; break;
        // 検定概要
        case '/ResultSet/Result/CertOverview': $this->result['CertOverview'] = $text; break;
        // 検定区分
        case '/ResultSet/Result/CertDiv': $this->result['CertDiv'] = $text; break;
        // 検定作成者名
        case '/ResultSet/Result/UserName': $this->result['UserName'] = $text; break;
        // パソコン版の検定詳細ページのURL
        case '/ResultSet/Result/CertDetailPcUrl': $this->result['CertDetailPcUrl'] = $text; break;
        // モバイル版の検定詳細ページのURL
        case '/ResultSet/Result/CertDetailMbUrl': $this->result['CertDetailMbUrl'] = $text; break;

        //
        case '/ResultSet/Result/EvalResult/EvalAxis': $this->result_eval['EvalAxis'] = $text; break;
        // 評価タイトル
        case '/ResultSet/Result/EvalResult/EvalTitle': $this->result_eval['EvalTitle'] = $text; break;
        // 評価メッセージ
        case '/ResultSet/Result/EvalResult/EvalMessage': $this->result_eval['EvalMessage'] = $text; break;
        // 合否
        case '/ResultSet/Result/EvalResult/Passing': $this->result_eval['Passing'] = $text; break;
        // 取得したポイント
        case '/ResultSet/Result/EvalResult/Score': $this->result_eval['Score'] = $text; break;

        case '/ResultSet/Result/EvalDetailResult/EvalDetailData': $i++; break;
        // 問題ID
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionId': $this->result_evals[$i]['QuestionId'] = $text; break;
        // 出題番号
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/OrderNumber': $this->result_evals[$i]['OrderNumber'] = $text; break;
        // 問題文
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionText': $this->result_evals[$i]['QuestionText'] = $text; break;
        // 問題画像（Mサイズ）のURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionImageMUrl': $this->result_evals[$i]['QuestionImageMUrl'] = $text; break;
        // 問題画像（Sサイズ）のURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionImageSUrl': $this->result_evals[$i]['QuestionImageSUrl'] = $text; break;
        // 問題動画のURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionMoveUrl': $this->result_evals[$i]['QuestionMoveUrl'] = $text; break;

        // 正解した人の総数
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/CorrectCount': $this->result_evals[$i]['CorrectCount'] = $text; break;
        // 問題を未解答とした人の総数
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/NoAnswerCount': $this->result_evals[$i]['NoAnswerCount'] = $text; break;
        // 正解選択肢番号
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/CorrectAnswer': $this->result_evals[$i]['CorrectAnswer'] = $text; break;
        // 解説文
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/QuestionExplanation': $this->result_evals[$i]['QuestionExplanation'] = $text; break;
        // 解説画像（Mサイズ）のURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ExplanationImageMUrl': $this->result_evals[$i]['ExplanationImageMUrl'] = $text; break;
        // 解説画像（Sサイズ）のURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ExplanationImageSUrl': $this->result_evals[$i]['ExplanationImageSUrl'] = $text; break;
        // 解説動画のURL
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ExplanationMovieUrl': $this->result_evals[$i]['ExplanationMovieUrl'] = $text; break;
        // 受験者が選択した解答番号
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/Answer': $this->result_evals[$i]['Answer'] = $text; break;
        // 正解/不正解
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/Correct': $this->result_evals[$i]['Correct'] = $text; break;

        // 選択肢情報
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult':
            $this->result_evals[$i]['ChoicesResult'] = array();
            $q_i = -1;
            break;
        // 選択肢各情報
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData': $q_i++; break;
        // 選択肢番号
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData/OrderNumber': $this->result_evals[$i]['ChoicesResult'][$q_i]['OrderNumber'] = $text; break;
        // 選択肢
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData/ChoiceText': $this->result_evals[$i]['ChoicesResult'][$q_i]['ChoiceText'] = $text; break;
        // 選択肢に割り振られているポイント
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData/ChoicePoint': $this->result_evals[$i]['ChoicesResult'][$q_i]['ChoicePoint'] = $text; break;
        // 選択者数
        case '/ResultSet/Result/EvalDetailResult/EvalDetailData/ChoicesResult/ChoiceData/ChoiceCount': $this->result_evals[$i]['ChoicesResult'][$q_i]['ChoiceCount'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * データ内のマッチしたクエリー数を取得する
     *
     * @access public
     * @return int データ内のマッチしたクエリー数
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * 検定データを取得する
     *
     * @access public
     * @return array 検定データ配列
     */
    function getResult()
    {
        return $this->result;
    }

    /**
     * 評価データを取得する
     *
     * @access public
     * @return array 評価データ配列
     */
    function getEval()
    {
        return $this->result_eval;
    }

    /**
     * 評価詳細データを取得する
     *
     * @access public
     * @return array 評価詳細データ配列
     */
    function getEvals()
    {
        return $this->result_evals;
    }
}
