<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchWebRequest.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - ウェブ検索用）
 */
require_once 'SyL_WebServiceSearchWebResponse.php';

/**
 * WEBサービスリクエストクラス（Yahoo! Japan - ウェブ検索用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * ウェブ検索
 *   http://developer.yahoo.co.jp/search/web/V1/webSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceSearchWebRequest.php,v 1.1 2009/01/11 05:34:29 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceSearchWebRequest extends SyL_WebServiceYahoo_co_jpRequest
{
    /**
     * WEBサービスサーバーのホスト名
     *
     * @access protected
     * @var string
     */
    var $host = 'search.yahooapis.jp';
    /**
     * 実行URLパス
     *
     * @access protected
     * @var string
     */
    var $path = '/WebSearchService/V1/webSearch';
    /**
     * レスポンスクラス名
     *
     * @access protected
     * @var string
     */
    var $response_class = 'SyL_WebServiceSearchWebResponse';

    /**
     * 検索クエリーをセットする
     *
     * @access public
     * @param string 検索クエリー
     */
    function setQuery($query)
    {
        parent::set('query', $query);
    }

    /**
     * 指定検索の種類をセットする
     * (all, any, phrase)
     *
     * @access public
     * @param string 指定検索の種類
     */
    function setType($type)
    {
        switch ($type) {
        case 'all':
        case 'any':
        case 'phrase':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `type' property ({$type}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の数をセットする
     *
     * @access public
     * @param int 返却結果の数
     */
    function setResults($results)
    {
        if (preg_match('/^\d+$/', $results) && (($results >= 0) && ($results <= 50))) {
            parent::set('results', $results);
        } else {
            trigger_error("[SyL error] Invalid `results' property ({$results}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 返却結果の先頭位置をセットする
     *
     * @access public
     * @param int 返却結果の先頭位置
     */
    function setStart($start)
    {
        if (preg_match('/^\d+$/', $start)) {
            $results = isset($this->parameters['results']) ? $this->parameters['results'] : 10;
            if (($start + $results - 1) <= 1000) {
                parent::set('start', $start);
            } else {
                trigger_error("[SyL error] Invalid `start' property ({$start}) in `" . __CLASS__ . "' class", E_USER_ERROR);
            }
        } else {
            trigger_error("[SyL error] Invalid `start' property ({$start}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索するファイルの種類をセットする
     *
     * @access public
     * @param string 検索するファイルの種類
     */
    function setFormat($format)
    {
        switch ($format) {
        case 'any':
        case 'html':
        case 'msword':
        case 'pdf':
        case 'ppt':
        case 'rss':
        case 'txt':
        case 'xls':
            parent::set('type', $type);
            break;
        default:
            trigger_error("[SyL error] Invalid `format' property ({$format}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * アダルトコンテンツの検索結果を含めるかどうかをセットする
     *
     * @access public
     * @param int アダルトコンテンツの検索結果を含めるかどうか
     */
    function setAdult_ok($adult_ok)
    {
        $adult_ok = ($adult_ok) ? '1' : '';
        parent::set('adult_ok', $adult_ok);
    }

    /**
     * 同じコンテンツを別の検索結果とするかどうかをセットする
     *
     * @access public
     * @param int 同じコンテンツを別の検索結果とするかどうか
     */
    function setSimilar_ok($similar_ok)
    {
        $similar_ok = ($similar_ok) ? '1' : '';
        parent::set('similar_ok', $similar_ok);
    }

    /**
     * 言語をセットする
     *
     * @access public
     * @param string 言語
     */
    function setLanguage($language)
    {
        switch ($language) {
        case 'is':
        case 'ar':
        case 'it':
        case 'id':
        case 'en':
        case 'et':
        case 'nl':
        case 'ca':
        case 'ko':
        case 'el':
        case 'hr':
        case 'sv':
        case 'es':
        case 'sk':
        case 'sl':
        case 'sr':
        case 'th':
        case 'cs':
        case 'szh':
        case 'tzh':
        case 'da':
        case 'tr':
        case 'de':
        case 'ja':
        case 'no':
        case 'hu':
        case 'fi':
        case 'fr':
        case 'bg':
        case 'he':
        case 'fa':
        case 'pt':
        case 'pl':
        case 'lv':
        case 'lt':
        case 'ro':
        case 'ru':
            parent::set('language', $language);
            break;
        default:
            trigger_error("[SyL error] Invalid `language' property ({$language}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 国コードをセットする
     *
     * @access public
     * @param string 国コード
     */
    function setCountry($country)
    {
        switch ($country) {
        case 'us':
        case 'ar':
        case 'uk':
        case 'it':
        case 'nl':
        case 'au':
        case 'at':
        case 'ca':
        case 'kr':
        case 'ch':
        case 'se':
        case 'es':
        case 'tw':
        case 'cz':
        case 'cn':
        case 'dk':
        case 'de':
        case 'jp':
        case 'no':
        case 'fi':
        case 'fr':
        case 'br':
        case 'be':
        case 'pl':
        case 'ru':
            parent::set('country', $country);
            break;
        default:
            trigger_error("[SyL error] Invalid `country' property ({$country}) in `" . __CLASS__ . "' class", E_USER_ERROR);
        }
    }

    /**
     * 検索ドメインをセットする
     *
     * @access public
     * @param string or array 検索ドメイン
     */
    function setSite($site)
    {
        parent::set('site', $site);
    }
}
