<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingItemsearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * WEBサービスレスポンスクラス（Yahoo! Japan - 商品検索用）
 *
 * 詳細は、Yahoo!デベロッパーネットワーク参照
 *   http://developer.yahoo.co.jp/
 * 商品検索
 *   http://developer.yahoo.co.jp/shopping/itemsearch/V1/itemSearch.html
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_WebServiceShoppingItemsearchResponse.php,v 1.1 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_WebServiceShoppingItemsearchResponse extends SyL_WebServiceYahoo_co_jpResponse
{
    /**
     * データ内のマッチしたクエリー数
     *
     * @access private
     * @var int 
     */
     var $total_results_available = 0;
    /**
     * 返却され、かつマッチしたクエリーの数
     *
     * @access private
     * @var int 
     */
    var $total_results_returned = 0;
    /**
     * 全検索結果の最初のポジション
     *
     * @access private
     * @var int 
     */
    var $first_result_position = 0;
    /**
     * リクエスト情報
     *
     * @access private
     * @var array
     */
    var $request = array();
    /**
     * モジュール情報
     *
     * @access private
     * @var array
     */
    var $modules = array();
    /**
     * 検索結果データ配列
     *
     * @access private
     * @var array
     */
    var $hits = array();

    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        static $i = -1;

        switch ($current_path) {
        // =============================
        // 正常系
        // =============================
        case '/ResultSet':
            if (isset($attribute['totalResultsAvailable'])) {
                $this->total_results_available = $attribute['totalResultsAvailable'];
            }
            if (isset($attribute['totalResultsReturned'])) {
                $this->total_results_returned = $attribute['totalResultsReturned'];
            }
            if (isset($attribute['firstResultPosition'])) {
                $this->first_result_position = $attribute['firstResultPosition'];
            }
            break;

        // リクエスト情報
        case '/ResultSet/Result/Request/Query': $this->request['Query'] = $text; break;

        // モジュール情報
        case '/ResultSet/Result/Modules/PriceRanges': $this->modules['PriceRanges'] = array(); break;
        case '/ResultSet/Result/Modules/PriceRanges/Range': $this->modules['PriceRanges']['Range'] = array(); break;
        case '/ResultSet/Result/Modules/PriceRanges/Range/Low':  $this->modules['PriceRanges']['Range']['Low']  = $text; break;
        case '/ResultSet/Result/Modules/PriceRanges/Range/High': $this->modules['PriceRanges']['Range']['High'] = $text; break;
        case '/ResultSet/Result/Modules/PriceRanges/Range/Hits': $this->modules['PriceRanges']['Range']['Hits'] = $text; break;

        case '/ResultSet/Result/Modules/Subcategories': $this->modules['Subcategories'] = array(); break;
        case '/ResultSet/Result/Modules/Path': $this->modules['Subcategories']['Path'] = array(); break;
        case '/ResultSet/Result/Modules/Path/Category': $this->modules['Subcategories']['Path']['Category'] = array(); break;
        case '/ResultSet/Result/Modules/Path/Category/Id':   $this->modules['Subcategories']['Path']['Category']['Id']   = $text; break;
        case '/ResultSet/Result/Modules/Path/Category/Name': $this->modules['Subcategories']['Path']['Category']['Name'] = $text; break;

        case '/ResultSet/Result/Modules/Children': $this->modules['Subcategories']['Children'] = array(); break;
        case '/ResultSet/Result/Modules/Children/Child': $this->modules['Subcategories']['Children']['Child'] = array(); break;
        case '/ResultSet/Result/Modules/Children/Child/Id': $this->modules['Subcategories']['Children']['Child']['Id'] = $text; break;
        case '/ResultSet/Result/Modules/Children/Child/Name': $this->modules['Subcategories']['Children']['Child']['Name'] = $text; break;
        case '/ResultSet/Result/Modules/Children/Child/Hits': $this->modules['Subcategories']['Children']['Child']['Hits'] = $text; break;

        // 検索結果
        case '/ResultSet/Result/Hit': $i++; break;
        // 商品名
        case '/ResultSet/Result/Hit/Name': $this->hits[$i]['Name'] = $text; break;
        // 商品URL
        case '/ResultSet/Result/Hit/Url': $this->hits[$i]['Url'] = $text; break;
        // 商品説明
        case '/ResultSet/Result/Hit/Description': $this->hits[$i]['Description'] = $text; break;
        // キャッチコピー
        case '/ResultSet/Result/Hit/Headline': $this->hits[$i]['Headline'] = $text; break;
        // 購入できるか
        case '/ResultSet/Result/Hit/Availability': $this->hits[$i]['Availability'] = $text; break;
        // 商品コード
        case '/ResultSet/Result/Hit/Code': $this->hits[$i]['Code'] = $text; break;
        // 人物ID
        case '/ResultSet/Result/Hit/PersonId': $this->hits[$i]['PersonId'] = $text; break;
        // JANコード
        case '/ResultSet/Result/Hit/JanCode': $this->hits[$i]['JanCode'] = $text; break;
        // ISBN(書籍コード)
        case '/ResultSet/Result/Hit/IsbnCode': $this->hits[$i]['IsbnCode'] = $text; break;
        // 型番
        case '/ResultSet/Result/Hit/Model': $this->hits[$i]['Model'] = $text; break;

        // 画像
        case '/ResultSet/Result/Hit/Image': $this->hits[$i]['Image'] = array(); break;
        // 画像ID
        case '/ResultSet/Result/Hit/Image/Id': $this->hits[$i]['Image']['Id'] = $text; break;
        // 76×76サイズの画像URL
        case '/ResultSet/Result/Hit/Image/Small': $this->hits[$i]['Image']['Small'] = $text; break;
        // 146×146サイズの画像URL
        case '/ResultSet/Result/Hit/Image/Medium': $this->hits[$i]['Image']['Medium'] = $text; break;

        // 価格
        case '/ResultSet/Result/Hit/Price': $this->hits[$i]['Price'] = $text; break;

        // 表示価格
        case '/ResultSet/Result/Hit/PriceLabel': $this->hits[$i]['PriceLabel'] = array(); break;
        // 定価
        case '/ResultSet/Result/Hit/PriceLabel/FixedPrice': $this->hits[$i]['PriceLabel']['FixedPrice'] = $text; break;
        // セール価格
        case '/ResultSet/Result/Hit/PriceLabel/SalePrice': $this->hits[$i]['PriceLabel']['SalePrice'] = $text; break;

        // ポイント
        case '/ResultSet/Result/Hit/Point': $this->hits[$i]['Point'] = array(); break;
        // ポイント数
        case '/ResultSet/Result/Hit/Point/Amount': $this->hits[$i]['Point']['Amount'] = $text; break;
        // ポイント倍率
        case '/ResultSet/Result/Hit/Point/Times': $this->hits[$i]['Point']['Times'] = $text; break;

        // 配送情報
        case '/ResultSet/Result/Hit/Shipping': $this->hits[$i]['Shipping'] = array(); break;
        // 条件コード
        case '/ResultSet/Result/Hit/Shipping/Code': $this->hits[$i]['Shipping']['Code'] = $text; break;
        // 設定なし/送料無料/条件付送料無料
        case '/ResultSet/Result/Hit/Shipping/Name': $this->hits[$i]['Shipping']['Name'] = $text; break;

        // 
        case '/ResultSet/Result/Hit/CategoryIdPath': $this->hits[$i]['CategoryIdPath'] = array(); break;
        // 現在カテゴリIDまでのルートからのパス構造
        case '/ResultSet/Result/Hit/CategoryIdPath/Category/Id': $this->hits[$i]['CategoryIdPath']['Category']['Id'][] = $text; break;

        // 
        case '/ResultSet/Result/Hit/Brands': $this->hits[$i]['Brands'] = array(); break;
        // ブランド名
        case '/ResultSet/Result/Hit/Brands/Name': $this->hits[$i]['Brands']['Name'] = $text; break;
        // ブランド名
        case '/ResultSet/Result/Hit/Brands/Path/Brand/Id': $this->hits[$i]['Brands']['Path']['Brand']['Id'][] = $text; break;

        // ストア情報
        case '/ResultSet/Result/Hit/Store': $this->hits[$i]['Store'] = array(); break;
        // ストアID
        case '/ResultSet/Result/Hit/Store/Id': $this->hits[$i]['Store']['Id'] = $text; break;
        // ストアURL
        case '/ResultSet/Result/Hit/Store/Url': $this->hits[$i]['Store']['Url'] = $text; break;
        // ストア名
        case '/ResultSet/Result/Hit/Store/Name': $this->hits[$i]['Store']['Name'] = $text; break;
        // ベストストアかどうか
        case '/ResultSet/Result/Hit/Store/IsBestStore': $this->hits[$i]['Store']['IsBestStore'] = $text; break;

        // 評価
        case '/ResultSet/Result/Hit/Store/Ratings': $this->hits[$i]['Store']['Ratings'] = array(); break;
        // ストア評価
        case '/ResultSet/Result/Hit/Store/Ratings/Rate': $this->hits[$i]['Store']['Ratings']['Rate'] = $text; break;
        // 評価人数
        case '/ResultSet/Result/Hit/Store/Ratings/Count': $this->hits[$i]['Store']['Ratings']['Count'] = $text; break;

        // 支払い情報
        case '/ResultSet/Result/Hit/Store/Payment': $this->hits[$i]['Store']['Payment'] = array(); break;
        // 支払い情報
        case '/ResultSet/Result/Hit/Store/Payment/Method': $this->hits[$i]['Store']['Payment']['Method'] = array(); break;
        // 支払いコード
        case '/ResultSet/Result/Hit/Store/Payment/Method/Code': $this->hits[$i]['Store']['Payment']['Method']['Code'] = $text; break;
        // 支払い名
        case '/ResultSet/Result/Hit/Store/Payment/Method/Name': $this->hits[$i]['Store']['Payment']['Method']['Name'] = $text; break;

        // ストア画像
        case '/ResultSet/Result/Hit/Store/Image': $this->hits[$i]['Store']['Image'] = array(); break;
        // 画像ID
        case '/ResultSet/Result/Hit/Store/Image/Id': $this->hits[$i]['Store']['Image']['Id'] = $text; break;
        // 120×30サイズの画像URL
        case '/ResultSet/Result/Hit/Store/Image/Medium': $this->hits[$i]['Store']['Image']['Medium'] = $text; break;

        // その他
        default: parent::getElement($current_path, $attribute, $text); break;
        }
    }

    /**
     * データ内のマッチしたクエリー数を取得する
     *
     * @access public
     * @return int データ内のマッチしたクエリー数
     */
    function getTotalResultsAvailable()
    {
        return $this->total_results_available;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getTotalResultsReturned()
    {
        return $this->total_results_returned;
    }

    /**
     * 返却され、かつマッチしたクエリーの数を取得する
     *
     * @access public
     * @return int 返却され、かつマッチしたクエリーの数
     */
    function getFirstResultPosition()
    {
        return $this->first_result_position;
    }

    /**
     * 検索結果データを取得する
     *
     * @access public
     * @return array 検索結果データ配列
     */
    function getHits()
    {
        return $this->hits;
    }
}
