<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader1_0.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * RSS 1.0リーダクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: SyL_XmlRssReader1_0.php,v 1.1 2009/01/11 05:34:31 seasonstream Exp $
 * @link      http://syl.jp/
 */
class SyL_XmlRssReader1_0 extends SyL_XmlRssReader
{
    /**
     * XMLデータ内容取得ハンドラメソッド
     *
     * @access protected
     * @param string 現在XML解析中のパス
     * @param string XMLのタグの属性値
     * @param string XMLのタグの値
     */
    function getElement($current_path, $attribute, $text)
    {
        // XML解析結果を取得
        switch ($current_path) {
        // -------------------------------------------------
        // ヘッダ
        // -------------------------------------------------
        case '/rdf:RDF/channel/dc:rights':
            $this->channel['dc:rights'] = $text;
            $this->channel['copyright'] = $text;
            break;
        case '/rdf:RDF/channel/description': $this->channel['description'] = $text;  break;
        case '/rdf:RDF/channel/dc:language':
            $this->channel['dc:language'] = $text;
            $this->channel['language']    = $text;
            break;
        case '/rdf:RDF/channel/link': $this->channel['link'] = $text; break;
        case '/rdf:RDF/channel/dc:date':
            $this->channel['dc:date'] = $text;
            $this->channel['date']    = $this->convertDateTime($text);
            break;
        case '/rdf:RDF/channel/title': $this->channel['title'] = $text; break;
        case '/rdf:RDF/channel/dc:contributor':
            $this->channel['dc:contributor'] = $text;
            $this->channel['contributor']    = $text;
            break;
        case '/rdf:RDF/channel/dc:subject':
            $this->channel['dc:subject'] = $text;
            $this->channel['category']   = $text;
            break;
        case '/rdf:RDF/channel/dc:creator':
            $this->channel['dc:creator'] = $text;
            $this->channel['author']     = $text;
            break;
        case '/rdf:RDF/channel/dc:identifier':
            $this->channel['dc:identifier'] = $text;
            $this->channel['id']            = $text;
            break;

        // 画像
        case '/rdf:RDF/image':
            $this->channel['image'] = array();
            if (isset($attribute['rdf:about'])) {
                $this->channel['image']['url'] = $attribute['rdf:about'];
            }
            break;
        case '/rdf:RDF/image/link':  $this->channel['image']['link']  = $text; break;
        case '/rdf:RDF/image/title': $this->channel['image']['title'] = $text; break;
        case '/rdf:RDF/image/url':   $this->channel['image']['url']   = $text; break;
        // 入力要素
        case '/rdf:RDF/textinput':
            $this->channel['textinput'] = array();
            if (isset($attribute['rdf:about'])) $this->channel['textinput']['url'] = $attribute['rdf:about'];
            break;
        case '/rdf:RDF/textinput/title':       $this->channel['textinput']['title']       = $text; break;
        case '/rdf:RDF/textinput/name':        $this->channel['textinput']['name']        = $text; break;
        case '/rdf:RDF/textinput/description': $this->channel['textinput']['description'] = $text; break;
        case '/rdf:RDF/textinput/link':        $this->channel['textinput']['link']        = $text; break;

        // -------------------------------------------------
        // データ
        // -------------------------------------------------
        // RSS情報
        case '/rdf:RDF/item':
            $this->items[]    = array();
            $this->item_count = count($this->items);
            break;
        case '/rdf:RDF/item/description': $this->items[$this->item_count-1]['description'] = $text; break;
        case '/rdf:RDF/item/link':        $this->items[$this->item_count-1]['link']        = $text; break;
        case '/rdf:RDF/item/title':       $this->items[$this->item_count-1]['title']       = $text; break;
        case '/rdf:RDF/item/dc:creator':
            $this->items[$this->item_count-1]['dc:creator'] = $text;
            $this->items[$this->item_count-1]['author']     = $text;
            break;
        case '/rdf:RDF/item/dc:subject':
            $this->items[$this->item_count-1]['dc:subject'] = $text;
            $this->items[$this->item_count-1]['category']   = $text;
            break;
        case '/rdf:RDF/item/dc:identifier':
            $this->items[$this->item_count-1]['dc:identifier'] = $text;
            $this->items[$this->item_count-1]['id']            = $text;
            break;
        case '/rdf:RDF/item/dc:date':
            $this->items[$this->item_count-1]['dc:date'] = $text;
            $this->items[$this->item_count-1]['date']    = $this->convertDateTime($text);
            break;
        case '/rdf:RDF/item/dc:source':
            $this->items[$this->item_count-1]['dc:source'] = $text;
            $this->items[$this->item_count-1]['source']    = $text;
            break;
        case '/rdf:RDF/item/dc:rights':
            $this->items[$this->item_count-1]['dc:rights'] = $text;
            $this->items[$this->item_count-1]['copyright'] = $text;
            break;
        case '/rdf:RDF/item/dc:contributor':
            $this->items[$this->item_count-1]['dc:contributor'] = $text;
            $this->items[$this->item_count-1]['contributor']    = $text;
            break;
        }
    }
}
