<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Base.php,v 1.1 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * ファイル処理クラス
 */
SyL_Loader::lib('File');

/**
 * ADM用アクションフォームとDAO用テーブルクラスを作成するクラス
 *
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Base.php,v 1.1 2009/02/14 04:32:56 seasonstream Exp $
 * @link      http://syl.jp/
 */
class Base extends AppAction
{
    /**
     * テーブルオブジェクト作成ディレクトリ
     *
     * @access private
     * @var string
     */
    var $table_dir = 'Adm.Tables.';
    /**
     * フォームオブジェクト作成ディレクトリ
     *
     * @access private
     * @var string
     */
    var $form_dir = 'Adm.Forms.';

    /**
     * メイン処理
     *
     * @access public
     * @param object データオブジェクト
     * @param object コンテキストオブジェクト
     */
    function execute(&$data, &$context)
    {
        $cmd =& $context->getConsole();

        $project_dir    = $data->geta('d', 0);
        $app_name       = $data->geta('w', 0);
        $controller_dir = dirname($data->geta('c', 0));
        $controller_url = $data->geta('u', 0);

        $cmd->stdout("  parameters checking...");

        // -------------------------------------------------
        // プロジェクトディレクトリチェック
        // -------------------------------------------------
        if (!is_dir($project_dir)) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // アプリケーション名チェック
        // -------------------------------------------------
        $app_dir = '';
        if (!$app_name) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        }
        $app_dir = "{$project_dir}/apps/{$app_name}"; 
        if (!is_dir($app_dir)) {
            trigger_error("[SyL error] Application directory not found ({$app_dir})", E_USER_ERROR);
            exit;
        }

        $action_dir   = "{$app_dir}/actions";
        $template_dir = "{$app_dir}/templates";

        // -------------------------------------------------
        // コントローラチェック
        // -------------------------------------------------
        if (!$controller_dir) {
            trigger_error("[SyL error] Controller file (-c) not found", E_USER_ERROR);
            exit;
        }

        if (!$controller_url) {
            trigger_error("[SyL error] Controller url (-u) not found", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // プロジェクトディレクトリチェック
        // -------------------------------------------------
        $cmd->stdout("  project application directory checking...");

        $action_file   = "{$app_dir}/actions/Index.php";
        $template_file = "{$app_dir}/templates/Index.html";
        $config_file   = "{$app_dir}/config/adms.xml";

        if (file_exists($action_file)) {
            if ($cmd->getInput('', "Already action file exist. overwrite file ? ({$action_file}) [Y/n]:") != 'Y') {
                return;
            }
        }

        if (file_exists($template_file)) {
            if ($cmd->getInput('', "Already template file exist. overwrite file ? ({$template_file}) [Y/n]:") != 'Y') {
                return;
            }
        }

        if (file_exists($config_file)) {
            if ($cmd->getInput('', "Already config file exist. overwrite file ? ({$config_file}) [Y/n]:") != 'Y') {
                return;
            }
        }

        $mkdirs = array();

        // -------------------------------------------------
        // コンテンツ（コントローラ）ディレクトリチェック
        // -------------------------------------------------
        $image_dir = '';
        $css_dir   = '';
        $js_dir    = '';
        $cmd->stdout("  images or css directory checking...");

        $image_dir = "{$controller_dir}/images";
        if (file_exists($image_dir)) {
            if (!is_dir($image_dir)) {
                trigger_error("[SyL error] Unable create `images' directory. Already file exist ({$image_dir})", E_USER_ERROR);
            }
            if ($cmd->getInput('', "Already `images' directory exist. overwrite directory ? ({$image_dir}) [Y/n]:") != 'Y') {
                return;
            }
            if (!is_writable($image_dir)) {
                trigger_error("[SyL error] Invalid `images' directory check. create permission denied ? ({$image_dir})", E_USER_ERROR);
            }
        } else {
            if (!is_writable(dirname($image_dir))) {
                trigger_error("[SyL error] Invalid `images' directory check. create permission denied ? ({$image_dir})", E_USER_ERROR);
            }
            $mkdirs[] = $image_dir;
        }

        $css_dir = "{$controller_dir}/css";
        if (file_exists($css_dir)) {
            if (!is_dir($css_dir)) {
                trigger_error("[SyL error] Unable create `css' directory. Already file exist ({$css_dir})", E_USER_ERROR);
            }
            if ($cmd->getInput('', "Already `css' directory exist. overwrite directory ? ({$css_dir}) [Y/n]:") != 'Y') {
                return;
            }
            if (!is_writable($css_dir)) {
                trigger_error("[SyL error] Invalid `css' directory check. create permission denied ? ({$css_dir})", E_USER_ERROR);
            }
        } else {
            if (!is_writable(dirname($css_dir))) {
                trigger_error("[SyL error] Invalid `css' directory check. create permission denied ? ({$css_dir})", E_USER_ERROR);
            }
            $mkdirs[] = $css_dir;
        }

        $js_dir = "{$controller_dir}/js";
        if (file_exists($js_dir)) {
            if (!is_dir($js_dir)) {
                trigger_error("[SyL error] Unable create `js' directory. Already file exist ({$js_dir})", E_USER_ERROR);
            }
            if ($cmd->getInput('', "Already `js' directory exist. overwrite directory ? ({$js_dir}) [Y/n]:") != 'Y') {
                return;
            }
            if (!is_writable($js_dir)) {
                trigger_error("[SyL error] Invalid `js' directory check. create permission denied ? ({$js_dir})", E_USER_ERROR);
            }
        } else {
            if (!is_writable(dirname($js_dir))) {
                trigger_error("[SyL error] Invalid `js' directory check. create permission denied ? ({$js_dir})", E_USER_ERROR);
            }
            $mkdirs[] = $js_dir;
        }

        // -------------------------------------------------
        // ディレクトリ作成
        // -------------------------------------------------
        $cmd->stdout("  create directories...");

        foreach ($mkdirs as $dir) {
            if (!file_exists($dir)) {
                $cmd->stdout("  create directory {$dir}");
                mkdir($dir);
            }
        }

        // -------------------------------------------------
        // ファイル作成
        // -------------------------------------------------
        $cmd->stdout("  create files...");

        // テンプレートファイル
        $template_action_file   = SYL_PROJECT_DIR . '/var/templates/Index.php';
        $template_template_file = SYL_PROJECT_DIR . '/var/templates/Index.html';
        $template_config_file   = SYL_PROJECT_DIR . '/var/templates/config/adms.xml';

        // フォーム操作クラス用変換配列初期化
        $form_opp_search  = array();
        $form_opp_replace = array();
        // プロジェクト名
        $form_opp_search[]  = '{PROJECT_NAME}';
        $form_opp_replace[] = basename($project_dir);
        // コントローラURL
        $form_opp_search[]  = '{CONTROLLER_URL}';
        $form_opp_replace[] = $controller_url;


        // アクションファイル作成
        $cmd->stdout("  action template file {$template_action_file}");
        $cmd->stdout("    -> generating action file {$action_file}");

        SyL_File::writeContents($action_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_action_file)));

        // テンプレートファイル作成
        $cmd->stdout("  template template file {$template_template_file}");
        $cmd->stdout("    -> generating template file {$template_file}");

        SyL_File::writeContents($template_file, file_get_contents($template_template_file));

        // 設定ファイル作成
        $cmd->stdout("  template config file {$template_config_file}");
        $cmd->stdout("    -> generating config file {$config_file}");

        SyL_File::writeContents($config_file, str_replace($form_opp_search, $form_opp_replace, file_get_contents($template_config_file)));

        // 画像ファイルコピー
        if ($image_dir) {
            $dir = SYL_PROJECT_DIR . '/var/templates/images';
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    if (($file != '.') && ($file != '..')) {
                        $cmd->stdout("  copying file {$dir}/{$file}");
                        $cmd->stdout("    -> {$image_dir}/{$file}");
                        copy("{$dir}/{$file}", "{$image_dir}/{$file}");
                    }
                }
                closedir($dh);
            }
        }

        // CSSファイルコピー
        if ($css_dir) {
            $dir = SYL_PROJECT_DIR . '/var/templates/css';
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    if (($file != '.') && ($file != '..')) {
                        $cmd->stdout("  copying file {$dir}/{$file}");
                        $cmd->stdout("    -> {$css_dir}/{$file}");
                        copy("{$dir}/{$file}", "{$css_dir}/{$file}");
                    }
                }
                closedir($dh);
            }
        }

        // JSファイルコピー
        if ($js_dir) {
            $dir = SYL_PROJECT_DIR . '/var/templates/js';
            if ($dh = opendir($dir)) {
                while (($file = readdir($dh)) !== false) {
                    if (($file != '.') && ($file != '..')) {
                        $cmd->stdout("  copying file {$dir}/{$file}");
                        $cmd->stdout("    -> {$js_dir}/{$file}");
                        copy("{$dir}/{$file}", "{$js_dir}/{$file}");
                    }
                }
                closedir($dh);
            }
        }


        // -------------------------------------------------
        // 結果表示
        // -------------------------------------------------

        $cmd->stdout("");
        $cmd->stdout("--- Result ---");
        $cmd->stdout("  [project directory] {$project_dir}");
        $cmd->stdout("  [application directory] {$app_dir}");
        $cmd->stdout("  [config file] {$config_file}");
        $cmd->stdout("  [images directory] {$image_dir}");
        $cmd->stdout("  [css directory] {$css_dir}");
        $cmd->stdout("  [js directory] {$js_dir}");
        $cmd->stdout("");
        $cmd->stdout("  start application -> access contoroller file.");

    }
}
