<?php
/**
 * アプリケーション共通アクションクラス
 *
 * @access    public
 * @package   {APP_NAME}
 * @author    {author}
 * @copyright {copyright}
 * @version   $Id: AppAction.php,v 1.3 2009/02/14 04:32:56 seasonstream Exp $
 */
class AppAction extends SyL_Action
{
    /**
     * メンテナンステーブル別名
     *
     * @var string
     */
    var $maintenance_table = 'a';

    /**
     * DB接続文字列の取得
     *
     * @access private
     * @param string プロジェクト設定ファイル
     * @param string アプリケーション設定ファイル
     * @return string DB接続文字列
     */
    function getConnectionString($project_config_file, $app_config_file=null)
    {
        $config =& SyL_Config::factory('defines');
        if ($app_config_file) {
            $config->setConfigFiles(array($app_config_file, $project_config_file));
        } else {
            $config->setConfigFiles(array($project_config_file));
        }
        $config->parseXml(false);
        $values = $config->getConfig();

        if (!isset($values['SYL_DB_DSN']) || !$values['SYL_DB_DSN']) {
            trigger_error("[SyL error] `SYL_DB_DSN' constant not defined in config file({$project_config_file} or {$app_config_file})", E_USER_ERROR);
        }

        return $values['SYL_DB_DSN'];
    }

    /**
     * テーブルスキーマ情報を取得
     *
     * @access private
     * @param string DB接続文字列
     * @param string テーブル名
     * @return array テーブルスキーマ情報
     */
    function getTableSchema($connection_string, $tablename)
    {
        // テーブルスキーマ取得
        $conn =& SyL_DB::getConnection($connection_string);
        $schema =& $conn->getSchema();
        $table_columns  = $schema->getColumns($tablename);
        $table_primary  = $schema->getPrimary($tablename);
        $table_uniques  = $schema->getUniques($tablename);
        $table_foreigns = $schema->getForeigns($tablename);
        $conn->closeConnection();

        return array($table_columns, $table_primary, $table_uniques, $table_foreigns);
    }

    function getTableClassSource($project_dir, $template_table_file, $table_name, $table_class, $table_columns, $table_primary=array(), $table_uniques=array(), $table_foreigns=array())
    {
        $columns  = array();
        foreach ($table_columns as $name => $column) {
            // 大文字統一
            $name = strtoupper($name);
            // テーブル定義用
            $columns[$name] = array(
              'type'     => $column['type'],
              'validate' => $this->getValidateDefinition($column)
            );
        }

        // テーブルクラス用変換配列初期化
        $table_search  = array();
        $table_replace = array();
        // プロジェクト名
        $table_search[]  = '{PROJECT_NAME}';
        $table_replace[] = basename($project_dir);
        // クラス名
        $table_search[]  = '{TABLE_CLASS_NAME}';
        $table_replace[] = SyL_Loader::convertClass($table_class);
        // テーブル名
        $table_search[]  = '{TABLE_NAME}';
        $table_replace[] = $table_name;
        // 主キー
        $table_search[]  = '{TABLE_PRIMARY}';
        $table_replace[] = var_export($table_primary, true);
        // 一意キー
        $table_search[]  = '{TABLE_UNIQUES}';
        $table_replace[] = var_export($table_uniques, true);
        // 外部キー
        $table_search[]  = '{TABLE_FOREIGNS}';
        $table_replace[] = var_export($table_foreigns, true);
        // カラム
        $table_search[]  = '{TABLE_COLUMNS}';
        $table_replace[] = var_export($columns, true);

        return str_replace($table_search, $table_replace, file_get_contents($template_table_file));
    }

    function getFormClassSource($project_dir, $template_form_file, $form_class, $table_name, $table_class, $table_columns, $table_primary=array())
    {
        $tables   = array();
        $elements = array();

        $tables[$this->maintenance_table] = $table_class;

        $i = 1;
        foreach ($table_columns as $name => $column) {
            // 大文字統一
            $name = strtoupper($name);
            // フォーム定義用
            $elements[$name] = array(
              'alias'       => $this->maintenance_table,
              'type'        => 'text',
              'name'        => $name,
              'attributes'  => array('size' => '30'),
              'validate'    => array(),
              'sort_list'   => $i,
              'sort_detail' => $i
            );
            $i++;
        }

        // ソートキー取得
        $sorts = array();
        foreach ($table_primary as $name) {
            $sorts[] = "{$this->maintenance_table}.{$name}.ASC";
        }

        // フォームクラス用変換配列初期化
        $form_search  = array();
        $form_replace = array();
        // プロジェクト名
        $form_search[]  = '{PROJECT_NAME}';
        $form_replace[] = basename($project_dir);
        // クラス名
        $form_search[]  = '{FORM_CLASS_NAME}';
        $form_replace[] = SyL_Loader::convertClass($form_class);
        // テーブルクラス名
        $form_search[]  = '{FORM_TABLES}';
        $form_replace[] = var_export($tables, true);
        // メインメンテナンステーブル
        $form_search[]  = '{FORM_MAINTENANCE_TABLE}';
        $form_replace[] = $this->maintenance_table;
        // デフォルトソート
        $form_search[]  = '{FORM_SORTS}';
        $form_replace[] = var_export($sorts, true);
        // フォーム要素
        $form_search[]  = '{FORM_ELEMENTS}';
        $form_replace[] = var_export($elements, true);
        // テーブル名
        $form_search[]  = '{FORM_TITLE}';
        $form_replace[] = $table_name . '管理';

        return  str_replace($form_search, $form_replace, file_get_contents($template_form_file));
    }

    /**
     * カラム型からバリデーションを取得する
     *
     * @access private
     * @param array 属性配列
     * @param array バリデーション
     */
    function getValidateDefinition($column)
    {
        $validate = array();
        // 必須チェック
        if ($column['not_null']) {
            $validate['require'] = array('message' => '{name}は必須です');
        }
        switch ($column['type']) {
        // 整数型
        case 'I':
            $validate['numeric'] = array(
              'message'    => '{name}は数値で入力してください',
              'parameters' => array(
                'dot' => false,
                'min' => $column['min'],
                'max' => $column['max'],
                'min_error_message' =>  '{name}は{min}以上で入力してください',
                'max_error_message' =>  '{name}は{max}以下で入力してください'
              )
            );
            break;

        // 浮動小数点型
        case 'F':
            $validate['numeric'] = array(
              'message'    => '{name}は数値で入力してください',
              'parameters' => array(
                'dot' => true
              )
            );
            break;

        // 桁数固定数値型
        case 'N':
            $validate['numeric'] = array(
              'message'    => '{name}は数値で入力してください',
              'parameters' => array(
                'dot' => true,
                'min' => $column['min'],
                'max' => $column['max'],
                'min_error_message' =>  '{name}は{min}以上で入力してください',
                'max_error_message' =>  '{name}は{max}以下で入力してください'
              )
            );
            break;

        // 日付型
        case 'D':
        case 'DT':
            $validate['date'] = array(
              'message' => '{name}は日付で入力してください'
            );
            break;

        // 時間型
        case 'T':
            $validate['regex'] = array(
              'message' => '{name}が正しくありません',
              'parameters' => array(
                'format' => '/^([0-1][0-9]|2[0-3]):?([0-5][0-9]):?([0-5][0-9])$/'
              )
            );
            break;

        // 文字列型
        case 'S':
            $validate['length'] = array(
              'message'    => '{name}は{max}文字（バイト）以内で入力してください',
              'parameters' => array(
                'max' => $column['max']
              )
            );
            break;
        }
        return $validate;
    }

    /**
     * ヘルプを表示
     *
     * @access private
     * @param object コマンドオブジェクト
     * @param string 実行ファイル名
     */
    function displayHelp(&$cmd, $file)
    {
        $help = <<<EOF
Usage:
  php {$file} adm -d <dir> -w <name> -a <dir> [-c <file>] -t <table>
  php {$file} base -d <dir> -w <name> -c <file> -u <url>
  php {$file} table -d <dir> [-w <name>] [-n <name>] [-p <name>] -t <table>
  php {$file} form -d <dir> [-w <name>] -f <name> [-n <name>] [-p <name>] -t <table>
  php {$file} [option]

Options:
  -d <dir>   project directory
  -w <name>  application name
  -a <dir>   action directory from root action directory
  -c <file>  controller file (default: null)
  -t <table> database table name
  -u <url>   controller url
  -f <name>  form class name. require SyL_Loader naming rule.
  -n <name>  table class name. require SyL_Loader naming rule. (default: table name)
  -p <name>  class prefix name. SyL_Loader naming rule. (default: null)
  -h         show this help, then exit
  -v         output version information, then exit
EOF;
        $cmd->stdout($help);
    }

    /**
     * バージョン情報を表示
     *
     * @access private
     * @param object コマンドオブジェクト
     * @param string 実行ファイル名
     */
    function displayVersion(&$cmd, $file)
    {
        $syl_version = SYL_VERSION;
        $php_version = PHP_VERSION;
        $php_sapi    = PHP_SAPI;
        $php_os      = PHP_OS;
       // $php_version = PHP_SAPI;
        $version = <<<EOF
{$file} - SyL {$syl_version} (PHP {$php_version} {$php_sapi} - {$php_os})
Copyright (C) 2006-2008 k.watanabe
EOF;
        $cmd->stdout($version);
    }

    /**
     * デフォルト表示
     *
     * @access private
     * @param object コマンドオブジェクト
     * @param string 実行ファイル名
     */
    function displayDefault(&$cmd, $file)
    {
        $default = <<<EOF
{$file}: too few arguments
Try `php {$file} --help' for more information.
EOF;
        $cmd->stdout($default);
    }
}
