<?php
/**
 * -----------------------------------------------------------------------------
 *
 * SyL - Web Application Framework for PHP
 *
 * PHP version 4 (>= 4.3.x) or 5
 *
 * Copyright (C) 2006-2009 k.watanabe
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * -----------------------------------------------------------------------------
 * @package   SyL
 * @author    Koki Watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Action.php,v 1.4 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 * -----------------------------------------------------------------------------
 */

/**
 * アクションファイル作成クラス
 *
 * @package   SyL
 * @author    k.watanabe <k.watanabe@syl.jp>
 * @copyright 2006-2009 k.watanabe
 * @license   http://www.opensource.org/licenses/lgpl-license.php
 * @version   CVS: $Id: Action.php,v 1.4 2009/01/11 05:34:33 seasonstream Exp $
 * @link      http://syl.jp/
 */
class Action extends AppAction
{
    var $c_action; // インジェクション

    /**
     * アクション作成処理
     *
     * @access public
     * @param object データオブジェクト
     * @param object コンテキストオブジェクト
     */
    function execute(&$data, &$context)
    {
        $project_dir  = $data->geta('d', 0);
        $app_name     = $data->geta('w', 0);
        $action_files = $data->geta('a');

        $cmd =& $context->getConsole();

        // -------------------------------------------------
        // プロジェクトディレクトリチェック
        // -------------------------------------------------
        if (!$project_dir) {
            trigger_error("[SyL error] Project directory (-d) not found", E_USER_ERROR);
            exit;
        }
        if (!preg_match('/(\\\\|\/)$/', $project_dir)) {
            $project_dir .= '/';
        }
        if (!file_exists($project_dir)) {
            trigger_error("[SyL error] Project directory not found ({$project_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // アプリケーション名チェック
        // -------------------------------------------------
        if (!$app_name) {
            trigger_error("[SyL error] Application name (-w) not found", E_USER_ERROR);
            exit;
        } else if (!preg_match('/^[\w\-]+$/', $app_name)) {
            trigger_error("[SyL error] Application name format invalid. ([a-z][A-Z][0-9]-_ only)", E_USER_ERROR);
            exit;
        }

        $app_dir = "{$project_dir}apps/{$app_name}/";
        if (!file_exists($app_dir)) {
            trigger_error("[SyL error] Application directory not found ({$app_dir})", E_USER_ERROR);
            exit;
        }

        // -------------------------------------------------
        // アクションファイルチェック
        // -------------------------------------------------
        if (!is_array($action_files)) {
            trigger_error("[SyL error] Action file (-a) not found", E_USER_ERROR);
            exit;
        }

        $action_dir = "{$app_dir}actions/";
        foreach ($action_files as $action_file) {
            if (preg_match('/^(\\\\|\/)/', $action_file)) {
                $action_file = substr($action_file, 1);
            }
            if (!preg_match('/\.php$/', $action_file)) {
                $action_file .= '.php';
            }
            if (file_exists($action_dir . $action_file)) {
                trigger_error("[SyL error] Already action file exists ({$action_dir}{$action_file})", E_USER_ERROR);
                exit;
            }
        }


        // -------------------------------------------------
        // アクションファイル作成
        // -------------------------------------------------
        $this->c_action->trigger($cmd, $project_dir, $app_name, $action_files);
    }

}
