#-*- mode:perl; coding:euc-jp -*-
#$Id: servermode.pm,v 1.2 2007/07/04 09:22:08 kohju Exp $
#
#

package servermode;
use strict;
use def;
use config;
use Exporter;
use func qw(hasDirTrav);
our  @ISA       = qw(Exporter);
our  @EXPORT    = qw(allPathCheck getRealTemplatePath getRealDataPath getRealLogPath getUserDomain);

our $SERVERMODE='Standard Single Server Edition';


#-----------------------------------------
# ٤ƤPATHФå롣
# PATHå̿򤹤٤Ƽ¹ԤPATH˥̥륹ȥ󥰤ä硢
# 顼ϤơFALSE֤
# in  : Хѥ
# out : Хѥ
#-----------------------------------------
sub allPathCheck
{
    my ($sc)=@_;
    my $templatepath=&getRealTemplatePath("");
    my $datapath=&getRealDataPath("");
    my $logpath=&getRealLogPath("");

    if($sc){ 			# SELF CHECK⡼
	my $msg;
	my $t_msg;
	$msg.="<h2>å</h2>\n";
	$msg.="<p>η̤򻲹ͤˤʤ顢_lib/config.pm񤭴Ƥ</p>";

	$msg.="<h3>¹ԥѥ(PREFIX)</h3>".`pwd`."<br />";

	$msg.="<h3>TEMPLATEǥ쥯ȥ</h3><p><strong>".$templatepath."</strong></p>";
	$t_msg.=" ǥ쥯ȥ꤬ޤ<br />" unless( -d $templatepath );
	$t_msg.=" ǥ쥯ȥ꤬ɤޤ<br />" unless( -r $templatepath );
	$t_msg.=" 顼Ϥޤ" unless($t_msg);
	$msg.="<p>".$t_msg."</p>";

	$msg.="<h3>DATAǥ쥯ȥ</h3><p><strong>".$datapath."</strong></p>";
	$t_msg.=" ǥ쥯ȥ꤬ޤ<br />" unless( -d $datapath );
	$t_msg.=" ǥ쥯ȥ꤬ɤޤ<br />" unless( -r $datapath );
	$t_msg.=" ǥ쥯ȥ˽񤱤ޤ<br />" unless( -w $datapath );
	$t_msg.=" 顼Ϥޤ" unless($t_msg);
	$msg.="<p>".$t_msg."</p>";
	
	$msg.="<h3>LOGǥ쥯ȥ</h3><p><strong>".$logpath."</strong></p>";
	$t_msg.=" ǥ쥯ȥ꤬ޤ<br />" unless( -d $logpath );
	$t_msg.=" ǥ쥯ȥ꤬ɤޤ<br />" unless( -r $logpath );
	$t_msg.=" ǥ쥯ȥ˽񤱤ޤ<br />" unless( -w $logpath );
	$t_msg.=" 顼Ϥޤ" unless($t_msg);
	$msg.="<p>".$t_msg."</p>";

	$msg.="<h3>٥ץإå\$MAILFROMϲǤǤ</h3>";
	if($MAILFROM){
	    $msg.="<p><strong>".$MAILFROM."</strong></p>";
	} else {
	    $msg.="<p>̤Ǥ</p>";
	}

	$msg.="<h3>rpnμ¹ԥƥ</h3>";
	$msg.="<p>ޥ̾<strong>".$RPNCMD."</strong></p>";

        my $rpn_result=`echo test | $RPNCMD`;
        if($rpn_result){
	    $msg.="<p>ưޤ</p>";
	    $msg.="¹Է̡".$rpn_result."<br />";
	} else {
	    $msg.="<p>ư˼ԤޤǧƤ</p>";
	}
	&log::Error("Self Check Mode η",$msg);
    }

    unless($templatepath && -d $templatepath )
    {
	&log::Error("TEMPLATE DIRꤵƤޤ",$templatepath);
	return $FALSE;
    }

    unless($datapath)
    {
	&log::Error("DATA DIRꤵƤޤ",$datapath);
	return $FALSE;
    }

    unless($logpath)
    {
	&log::Error("LOG DIRꤵƤޤ",$logpath);
	return $FALSE;
    }

    return $TRUE;
}

#------------------------------------
# ƥץ졼ХѥХѥ롣
# Хѥ˥ǥ쥯ȥȥС뤬äǥ쥯ȥץեåΤߤ֤
# in  : Хѥ
# out : Хѥ
#------------------------------------
sub getRealTemplatePath
{
    my($relationpath) = @_;
    unless(hasDirTrav($relationpath)){
	return $TEMPLATEDIR;
    }else{
	return $TEMPLATEDIR."/".hasDirTrav($relationpath);
    }

}
#multi       return "$PREFIX/$SERVER/template";

#------------------------------------
# ǡХѥХѥ롣
# Хѥ˥ǥ쥯ȥȥС뤬äǥ쥯ȥץեåΤߤ֤
# in  : Хѥ
# out : Хѥ
#------------------------------------
sub getRealDataPath
{
    my($relationpath) = @_;
    unless(hasDirTrav($relationpath)){
	return $DATADIR;
    }else{
	return $DATADIR."/".hasDirTrav($relationpath);
    }
}
#multi $PREFIX/$SERVER/data;

#------------------------------------
# ХѥХѥ롣
# Хѥ˥ǥ쥯ȥȥС뤬äǥ쥯ȥץեåΤߤ֤
# in  : Хѥ
# out : Хѥ
#------------------------------------
sub getRealLogPath
{
    my($relationpath) = @_;
    unless(hasDirTrav($relationpath)){
	return $LOGDIR;
    }else{
	return $LOGDIR."/".hasDirTrav($relationpath);
    }
}

#multi $PREFIX/$SERVER/log;


#------------------------------------
# 桼ɥᥤμ
# in  : 
# out : multi : $key{'_SERVER'}; single:ĶѿȤ롣
#------------------------------------
sub getUserDomain
{
    return $ENV{'SERVER_NAME'};
}

1;
