%x STRING
%{

/* $Id: rpn.l,v 1.1.1.1 2007/04/18 16:16:05 kohju Exp $ */

#include <math.h>
#include <string.h>
#include "rpn.h"
#include "rpn.tab.h"

%}


%%
%{
  /* Initialize */

%}


<INITIAL>\"	BEGIN(STRING);	/* ʸ򳫻Ϥ롣 */

<STRING>\\.	yymore();
<STRING>[^\\"]* yymore();
<STRING>\"	{		/* ֥륯 */
    char *p=NULL;
    char *s=NULL;

    BEGIN(INITIAL);
    p=strdup(yytext);		/* ϥåꥹȤԤ */
    p[strlen(yytext)-1]=0;
    s=dupChar(p,']');		/* ]]] */
    free(p);p=NULL;

    strc++;
    tblstr=realloc(tblstr,(strc+1)*sizeof(char*)); /* ʸꥹȤѤ */
    tblstr[strc]=s;
    yylval.uival=strc;
    return(STRINGS);
}

<INITIAL>\'[^']*\'	{	/*󥰥륯*/
    char *p=NULL;
    char *s=NULL;

    p=strdup(&yytext[1]);
    p[strlen(yytext)-2]=0;
    s=dupChar(p,']');		/* ]]] */
    free(p);p=NULL;

    strc++;
    tblstr=realloc(tblstr,(strc+1)*sizeof(char*));
    tblstr[strc]=s;
    yylval.uival=strc;
    /*    fprintf(stderr,"yytext=[%s]\n",yytext);
    fprintf(stderr,"p=[%s]\n",p);
    fprintf(stderr,"tblstr[%d]=[%s]\n",strc,tblstr[strc]); */
    return(QSTRINGS);
}

<INITIAL>","	return(COMMA);
<INITIAL>"&&"	return(AND);
<INITIAL>"||"	return(OR);
<INITIAL>"!"	return(NOT);
<INITIAL>"=="	return(EQ);
<INITIAL>"<>"	return(NEQ);
<INITIAL>"!="	return(NEQ);
<INITIAL>">"	return(GT);
<INITIAL>">="	return(GTE);
<INITIAL>"<"	return(LT);
<INITIAL>"<="	return(LTE);
<INITIAL>"="	return(SUBSTITUTE);
<INITIAL>"+"	return(ADDOP);
<INITIAL>"-"	return(SUBOP);
<INITIAL>"*"	return(MULOP);
<INITIAL>"/"	return(DIVOP);
<INITIAL>")"	return(RP);
<INITIAL>"("	return(LP);
<INITIAL>"\."   return(DOT);

<INITIAL>([0-9]+|([0-9]*\.[0-9]+)([eE][-+]?[0-9]+)?) {
  /*printf ("ϿǤ%f\n",yytext);*/
  yylval.dval = atof(yytext);
  return(NUMBER);
}

<INITIAL>[ \t]	;	/* ignore white space */

<INITIAL>[_A-Za-z][_A-Za-z0-9]* {
  LPSYMTBL sp;
  if((sp=SearchSymtbl(yytext))==NULL){
    sp=AddSymtbl();
    yylval.symbol=SetSymtbl(sp,yytext);
    return SYMBOL;
  } else {
    yylval.symbol=sp;
    return SYMBOL;
  }
  return SYMBOL;		/* 褳ޤǤʤϤʤΤ */
}    

<INITIAL>#.*?\n	{lineno++;}	/* #ʹߤϥȤȤư */
<INITIAL>\\\n	{lineno++;} /* ХååǽλԤϡιԤϢ뤹롣 */

<INITIAL>\n	{
  lineno++;
  return(TERM);
}

<INITIAL>. ;

%%

void yyerror(char *s)
{
	fprintf(stderr,"RPN: %d: %s at %s\n",
	   lineno,s,yytext);
	printf("ERROR[%d: %s]",lineno,s);
}
