/*******************************************************
 *
 * Author: Shinsaku Hiura, Hirokazu Kato
 *
 *         shinsaku@sys.es.osaka-u.ac.jp
 *         kato@sys.im.hiroshima-cu.ac.jp
 *
 * Revision: 2.1
 * Date: 99/07/16
 *
*******************************************************/

#include <stdio.h>
#include <math.h>
#include <AR/matrix.h>

ARVAL arVecHousehold( ARVec *x )
{
    ARVAL s, t;
    int    i;

    s = SqrtARVAL( arVecInnerproduct(x,x) );

    if( s != 0 ) {
        if(x->vl[0] < 0) s = -s;
        x->vl[0] += s;
        t = InvSqrtARVAL( MulARVAL( x->vl[0], s ) );
        for( i = 0; i < x->clm; i++ ) {
            x->vl[i] = MulARVAL( x->vl[i], t );
        }
    }

    return(-s);
}
