package com.shizentai.app.arcam;

import java.io.File;
import java.io.FileOutputStream;
import java.io.InputStream;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.DialogInterface;
import android.graphics.PixelFormat;
import android.os.Bundle;
import android.os.Environment;
import android.os.Handler;
import android.view.KeyEvent;
import android.view.View;
import android.view.Window;
import android.widget.Button;
import android.widget.RelativeLayout;
import android.hardware.Camera;

/**
 * 
 * @author Shizentai Factory Co.
 *
 */
public class arcam extends Activity implements View.OnClickListener
{
	public static String dbgtag = "arcam";
	final int ress[] = { R.raw.r2_mqo };
	final String pathes[] = { "r2_mqo.mqo" }; 

	RelativeLayout relLayout;
	arcamView view;
	Camera cam;
	public String modelpath[];
	
	public void terminateDialog( final int resId )
	{
    Handler hdl = new Handler();
    hdl.post(  
    	new Runnable()
    	{
    		@Override
    		public void run()
    		{
    			new AlertDialog.Builder( arcam.this )
  				.setIcon( android.R.drawable.ic_dialog_alert )
  				.setTitle( getClass().getSimpleName() )
  				.setMessage( getString( resId ) )
  				.setNegativeButton(	R.string.btn_cancel, new DialogInterface.OnClickListener()
	  					{
		  			    @Override
		  			    public void onClick(DialogInterface dialog, int which)
		  			    {
		  			    	arcam.this.finish();
		  			    }
	  					} 
  					)
  				.create()
  				.show();
    		}
    	} 
   	);
	}

	Button createButton( String strCaption, int id, int width, int height, int[] rule, int[] anchor )
	{
		Button btn = new Button( this );
		btn.setId( id );
		btn.setText( strCaption );
		btn.setOnClickListener( this );
		RelativeLayout.LayoutParams p = new RelativeLayout.LayoutParams( width, height );
		if ( rule != null )
		{
			for ( int i=0; i<rule.length; i++ )
			{
				int anc = (anchor != null)? anchor[ i ] : 0;
				if ( anc > 0 )
					p.addRule( rule[ i ], anc );
				else
					p.addRule( rule[ i ] );
			}
		}
		btn.setLayoutParams( p ); 
		relLayout.addView( btn );
		return btn;
	}
	
  // SDカードのディレクトリが無ければ初期化
	void initSD()
	{
    if ( !Environment.getExternalStorageState().contains( "mounted" ) )
    {
    	terminateDialog( R.string.msg_fail_sdcard_mount );
    	return;
    }
		String prefix = Environment.getExternalStorageDirectory().getAbsolutePath() + "/arcam";
		File dir = new File( prefix );
		if ( !dir.exists() )
			dir.mkdir();

		// デフォルトのモデルデータファイルをリソースから生成
		modelpath = new String [ ress.length ];
		byte[] buf = new byte [ 1024 ];
		
		for ( int i=0; i<ress.length; i++ )
		{
			String path = new String( prefix + "/" + pathes[ i ] );
			modelpath[ i ] = path;
			InputStream is = getResources().openRawResource( ress[ i ] );
			File of = new File( path );
			try
			{
				if ( !of.createNewFile() )
				{
					continue;
				}
				FileOutputStream os = new FileOutputStream( of );
				for ( int n=0; (n=is.read( buf )) > 0; )
					os.write( buf, 0, n );
				os.close();
				of.deleteOnExit();
			}
			catch ( Exception e )
			{
	    	terminateDialog( R.string.msg_fail_sdcard_access );
	    	return;
			}
		}
	}
	
	
	@Override
  public void onCreate( Bundle savedInstanceState ) 
  {
    super.onCreate( savedInstanceState );
    requestWindowFeature( Window.FEATURE_NO_TITLE );
    getWindow().setFormat( PixelFormat.RGB_565 );
    relLayout = new RelativeLayout( this );
    setContentView( relLayout );
        
    initSD();
    try
    {
    	view = new arcamView( this );
    }
    catch ( Exception e )
    {
    	terminateDialog( R.string.msg_fail_view );
    	return;
    }
    
    relLayout.addView( view );
    //setContentView( view );
  }

  @Override
  public void onDestroy()
  {
  	view = null;
  	super.onDestroy();
  }
	
  @Override
  protected void onResume() 
  {
  	cam = Camera.open();
  	view.setCamera( cam );
    super.onResume();
  }
  
  @Override
  protected void onPause() 
  {
    try
    {
    	view.setCamera( null );
    }
    catch ( Exception e )
    {
    }
    cam.release();
    super.onPause();
    
    // backキーで即時終了
		setResult( RESULT_OK );
		finish();
		System.exit( 0 );
  }

  
	@Override
	public boolean onKeyDown( int keyCode, KeyEvent keyEvent )
	{
		switch ( keyCode )
		{
		case KeyEvent.KEYCODE_FOCUS:
			view.startAutoFocus();
			break; 
		case KeyEvent.KEYCODE_CAMERA:
			break;
		}
		
		return false;
	}
  
	@Override
	public boolean onKeyUp( int keyCode, KeyEvent keyEvent )
	{
		switch ( keyCode )
		{
		case KeyEvent.KEYCODE_FOCUS:
			view.cancelAutoFocus();
			break;
		case KeyEvent.KEYCODE_CAMERA:
			break;
		}
		
		return false;
	}
	
  
  // キーイベント発生時、呼び出されます
  @Override
  public boolean dispatchKeyEvent(KeyEvent event) 
  {
//  	Log.d( dbgtag, "key: "+event.getKeyCode() );
    return super.dispatchKeyEvent(event);
  }

	@Override
	public void onClick( View arg0 )
	{
		// TODO Auto-generated method stub
		
	}  
}