/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.dnd;

import org.eclipse.swt.SWT;
import org.eclipse.swt.dnd.DND;
import org.eclipse.swt.dnd.TransferData;
import org.eclipse.swt.internal.wpf.OS;

public abstract class Transfer {
    private static String[] registeredTypes = new String[0];

    static int createDotNetString(String string) {
        if (string == null) {
            return 0;
        }
        int length = string.length();
        char[] buffer = new char[length + 1];
        string.getChars(0, length, buffer, 0);
        int result = OS.gcnew_String(buffer);
        if (result == 0) {
            SWT.error(2);
        }
        return result;
    }

    static String createJavaString(int ptr) {
        int charArray = OS.String_ToCharArray(ptr);
        char[] chars = new char[OS.String_Length(ptr)];
        OS.memcpy(chars, charArray, chars.length * 2);
        OS.GCHandle_Free(charArray);
        return new String(chars);
    }

    public abstract TransferData[] getSupportedTypes();

    public abstract boolean isSupportedType(TransferData var1);

    protected abstract String[] getTypeNames();

    protected abstract int[] getTypeIds();

    protected abstract void javaToNative(Object var1, TransferData var2);

    protected abstract Object nativeToJava(TransferData var1);

    public static int registerType(String formatName) {
        int length = registeredTypes.length;
        int i = 0;
        while (i < length) {
            if (registeredTypes[i].equals(formatName)) {
                return i + 1;
            }
            ++i;
        }
        String[] newTypes = new String[length + 1];
        System.arraycopy(registeredTypes, 0, newTypes, 0, length);
        newTypes[length] = formatName;
        registeredTypes = newTypes;
        return length + 1;
    }

    static String getTypeName(int registeredType) {
        if (--registeredType < 0 || registeredType >= registeredTypes.length) {
            DND.error(2003);
        }
        return registeredTypes[registeredType];
    }

    static int getWPFFormat(int registeredType) {
        if (--registeredType < 0 || registeredType >= registeredTypes.length) {
            DND.error(2003);
        }
        return Transfer.createDotNetString(registeredTypes[registeredType]);
    }
}

