/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.wpf.ICONINFO;
import org.eclipse.swt.internal.wpf.OS;

public final class Cursor
extends Resource {
    public int handle;

    Cursor() {
    }

    public Cursor(Device device, int style) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        switch (style) {
            case 21: {
                this.handle = OS.Cursors_Hand();
                break;
            }
            case 0: {
                this.handle = OS.Cursors_Arrow();
                break;
            }
            case 1: {
                this.handle = OS.Cursors_Wait();
                break;
            }
            case 2: {
                this.handle = OS.Cursors_Cross();
                break;
            }
            case 3: {
                this.handle = OS.Cursors_AppStarting();
                break;
            }
            case 4: {
                this.handle = OS.Cursors_Help();
                break;
            }
            case 5: {
                this.handle = OS.Cursors_SizeAll();
                break;
            }
            case 6: {
                this.handle = OS.Cursors_SizeNESW();
                break;
            }
            case 7: {
                this.handle = OS.Cursors_SizeNS();
                break;
            }
            case 8: {
                this.handle = OS.Cursors_SizeNWSE();
                break;
            }
            case 9: {
                this.handle = OS.Cursors_SizeWE();
                break;
            }
            case 10: {
                this.handle = OS.Cursors_ScrollN();
                break;
            }
            case 11: {
                this.handle = OS.Cursors_ScrollS();
                break;
            }
            case 12: {
                this.handle = OS.Cursors_ScrollE();
                break;
            }
            case 13: {
                this.handle = OS.Cursors_ScrollW();
                break;
            }
            case 14: {
                this.handle = OS.Cursors_ScrollNE();
                break;
            }
            case 15: {
                this.handle = OS.Cursors_ScrollSE();
                break;
            }
            case 16: {
                this.handle = OS.Cursors_ScrollSW();
                break;
            }
            case 17: {
                this.handle = OS.Cursors_ScrollNW();
                break;
            }
            case 18: {
                this.handle = OS.Cursors_UpArrow();
                break;
            }
            case 19: {
                this.handle = OS.Cursors_IBeam();
                break;
            }
            case 20: {
                this.handle = OS.Cursors_No();
                break;
            }
            default: {
                SWT.error(5);
            }
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData source, ImageData mask, int hotspotX, int hotspotY) {
        int safeHandle;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            if (source.getTransparencyType() != 2) {
                SWT.error(4);
            }
            mask = source.getTransparencyMask();
        }
        if (mask.width != source.width || mask.height != source.height) {
            SWT.error(5);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        source = ImageData.convertMask(source);
        byte[] sourceData = ImageData.convertPad(source.data, source.width, source.height, source.depth, source.scanlinePad, 2);
        byte[] maskData = ImageData.convertPad(mask.data, mask.width, mask.height, mask.depth, mask.scanlinePad, 2);
        int hInst = OS.GetModuleHandleW(null);
        int cursor = OS.CreateCursor(hInst, hotspotX, hotspotY, source.width, source.height, sourceData, maskData);
        if (cursor == 0) {
            SWT.error(2);
        }
        if ((safeHandle = OS.gcnew_SWTSafeHandle(cursor, false)) == 0) {
            SWT.error(2);
        }
        this.handle = OS.CursorInteropHelper_Create(safeHandle);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.GCHandle_Free(safeHandle);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Cursor(Device device, ImageData source, int hotspotX, int hotspotY) {
        int safeHandle;
        int hIcon;
        int bitmap;
        boolean transparent;
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (source == null) {
            SWT.error(4);
        }
        if (hotspotX >= source.width || hotspotX < 0 || hotspotY >= source.height || hotspotY < 0) {
            SWT.error(5);
        }
        PaletteData palette = source.palette;
        if ((source.depth != 1 && source.depth != 2 && source.depth != 4 && source.depth != 8 || palette.isDirect) && source.depth != 8 && (source.depth != 16 && source.depth != 24 && source.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        this.device = device;
        int width = source.width;
        int height = source.height;
        int redMask = palette.redMask;
        int greenMask = palette.greenMask;
        int blueMask = palette.blueMask;
        ImageData newData = null;
        int pixelFormat = 0;
        boolean bl = transparent = source.maskData != null || source.transparentPixel != -1 || source.alpha != -1 || source.alphaData != null;
        if (transparent) {
            pixelFormat = 2498570;
            if (!palette.isDirect || source.depth != 32 || redMask != 65280 || greenMask != 0xFF0000 || blueMask != -16777216) {
                newData = new ImageData(width, height, 32, new PaletteData(65280, 0xFF0000, -16777216));
            }
        } else {
            switch (source.depth) {
                case 1: 
                case 2: 
                case 4: 
                case 8: {
                    pixelFormat = 137224;
                    newData = new ImageData(source.width, source.height, 24, new PaletteData(255, 65280, 0xFF0000));
                    break;
                }
                case 16: {
                    if (redMask == 31744 && greenMask == 992 && blueMask == 31) {
                        pixelFormat = 135173;
                        break;
                    }
                    if (redMask == 63488 && greenMask == 2016 && blueMask == 31) {
                        pixelFormat = 135174;
                        break;
                    }
                    pixelFormat = 135173;
                    newData = new ImageData(source.width, source.height, 16, new PaletteData(31744, 992, 31));
                    break;
                }
                case 24: {
                    if (redMask == 255 && greenMask == 65280 && blueMask == 0xFF0000) {
                        pixelFormat = 137224;
                        break;
                    }
                    pixelFormat = 137224;
                    newData = new ImageData(source.width, source.height, 24, new PaletteData(255, 65280, 0xFF0000));
                    break;
                }
                case 32: {
                    if (redMask == 65280 && greenMask == 0xFF0000 && blueMask == -16777216) {
                        pixelFormat = 139273;
                        break;
                    }
                    pixelFormat = 139273;
                    newData = new ImageData(source.width, source.height, 32, new PaletteData(65280, 0xFF0000, -16777216));
                }
            }
        }
        if (newData != null) {
            PaletteData newPalette = newData.palette;
            if (palette.isDirect) {
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, width, height, redMask, greenMask, blueMask, 255, null, 0, 0, 0, newData.data, newData.depth, newData.bytesPerLine, newData.getByteOrder(), 0, 0, width, height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
            } else {
                RGB[] rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(1, source.data, source.depth, source.bytesPerLine, source.getByteOrder(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, newData.data, newData.depth, newData.bytesPerLine, newData.getByteOrder(), 0, 0, width, height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
            }
            if (source.transparentPixel != -1) {
                newData.transparentPixel = newPalette.getPixel(palette.getRGB(source.transparentPixel));
            }
            newData.maskPad = source.maskPad;
            newData.maskData = source.maskData;
            newData.alpha = source.alpha;
            newData.alphaData = source.alphaData;
            source = newData;
            palette = source.palette;
        }
        if (transparent) {
            if (source.maskData != null || source.transparentPixel != -1) {
                ImageData maskImage = source.getTransparencyMask();
                byte[] maskData = maskImage.data;
                int maskBpl = maskImage.bytesPerLine;
                int offset = 3;
                int maskOffset = 0;
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        source.data[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                        offset += 4;
                        ++x;
                    }
                    maskOffset += maskBpl;
                    ++y;
                }
            } else if (source.alpha != -1) {
                byte alpha = (byte)source.alpha;
                int i = 3;
                int j = 0;
                while (i < source.data.length) {
                    source.data[i] = alpha;
                    i += 4;
                    ++j;
                }
            } else {
                int i = 3;
                int j = 0;
                while (i < source.data.length) {
                    source.data[i] = source.alphaData[j];
                    i += 4;
                    ++j;
                }
            }
        }
        if ((bitmap = OS.gcnew_Bitmap(source.width, source.height, source.bytesPerLine, pixelFormat, source.data)) == 0) {
            SWT.error(2);
        }
        if ((hIcon = OS.Bitmap_GetHicon(bitmap)) == 0) {
            SWT.error(2);
        }
        ICONINFO info = new ICONINFO();
        OS.GetIconInfo(hIcon, info);
        info.fIcon = false;
        info.xHotspot = hotspotX;
        info.yHotspot = hotspotY;
        OS.DestroyIcon(hIcon);
        hIcon = OS.CreateIconIndirect(info);
        if (info.hbmColor != 0) {
            OS.DeleteObject(info.hbmColor);
        }
        if (info.hbmMask != 0) {
            OS.DeleteObject(info.hbmMask);
        }
        if (hIcon == 0) {
            SWT.error(2);
        }
        if ((safeHandle = OS.gcnew_SWTSafeHandle(hIcon, true)) == 0) {
            SWT.error(2);
        }
        this.handle = OS.CursorInteropHelper_Create(safeHandle);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.GCHandle_Free(safeHandle);
        OS.GCHandle_Free(bitmap);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.GCHandle_Free(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Cursor)) {
            return false;
        }
        Cursor cursor = (Cursor)object;
        return this.device == cursor.device && this.handle == cursor.handle;
    }

    public int hashCode() {
        return this.handle;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Cursor {*DISPOSED*}";
        }
        return "Cursor {" + this.handle + "}";
    }

    public static Cursor wpf_new(Device device, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Cursor cursor = new Cursor();
        cursor.handle = handle;
        cursor.device = device;
        return cursor;
    }
}

