/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.wpf.OS;

public class Pattern
extends Resource {
    public int handle;

    public Pattern(Device device, Image image) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (image == null) {
            SWT.error(4);
        }
        if (image.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        this.handle = OS.gcnew_ImageBrush(image.handle);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.TileBrush_TileMode(this.handle, 4);
        OS.TileBrush_Stretch(this.handle, 1);
        OS.TileBrush_ViewportUnits(this.handle, 0);
        int rect = OS.gcnew_Rect(0.0, 0.0, OS.BitmapSource_PixelWidth(image.handle), OS.BitmapSource_PixelHeight(image.handle));
        OS.TileBrush_Viewport(this.handle, rect);
        OS.GCHandle_Free(rect);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, Color color2) {
        this(device, x1, y1, x2, y2, color1, 255, color2, 255);
    }

    public Pattern(Device device, float x1, float y1, float x2, float y2, Color color1, int alpha1, Color color2, int alpha2) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (color1 == null) {
            SWT.error(4);
        }
        if (color1.isDisposed()) {
            SWT.error(5);
        }
        if (color2 == null) {
            SWT.error(4);
        }
        if (color2.isDisposed()) {
            SWT.error(5);
        }
        this.device = device;
        int startColor = OS.Color_FromArgb((byte)(alpha1 & 0xFF), OS.Color_R(color1.handle), OS.Color_G(color1.handle), OS.Color_B(color1.handle));
        if (x1 == x2 && y1 == y2) {
            this.handle = OS.gcnew_SolidColorBrush(startColor);
            if (this.handle == 0) {
                SWT.error(2);
            }
        } else {
            int startPoint = OS.gcnew_Point(x1, y1);
            int endColor = OS.Color_FromArgb((byte)(alpha2 & 0xFF), OS.Color_R(color2.handle), OS.Color_G(color2.handle), OS.Color_B(color2.handle));
            int endPoint = OS.gcnew_Point(x2, y2);
            this.handle = OS.gcnew_LinearGradientBrush(startColor, endColor, startPoint, endPoint);
            if (this.handle == 0) {
                SWT.error(2);
            }
            OS.GradientBrush_MappingMode(this.handle, 0);
            OS.GradientBrush_SpreadMethod(this.handle, 2);
            OS.GCHandle_Free(endColor);
            OS.GCHandle_Free(endPoint);
            OS.GCHandle_Free(startPoint);
        }
        OS.GCHandle_Free(startColor);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.GCHandle_Free(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Pattern {*DISPOSED*}";
        }
        return "Pattern {" + this.handle + "}";
    }
}

