/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.wpf.OS;

public class Transform
extends Resource {
    public int handle;

    public Transform(Device device) {
        this(device, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, 0.0f);
    }

    public Transform(Device device, float[] elements) {
        this(device, Transform.checkTransform(elements)[0], elements[1], elements[2], elements[3], elements[4], elements[5]);
    }

    public Transform(Device device, float m11, float m12, float m21, float m22, float dx, float dy) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        this.handle = OS.gcnew_Matrix(m11, m12, m21, m22, dx, dy);
        if (this.handle == 0) {
            SWT.error(2);
        }
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    static float[] checkTransform(float[] elements) {
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        return elements;
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        OS.GCHandle_Free(this.handle);
        this.handle = 0;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public void getElements(float[] elements) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (elements == null) {
            SWT.error(4);
        }
        if (elements.length < 6) {
            SWT.error(5);
        }
        elements[0] = (float)OS.Matrix_M11(this.handle);
        elements[1] = (float)OS.Matrix_M12(this.handle);
        elements[2] = (float)OS.Matrix_M21(this.handle);
        elements[3] = (float)OS.Matrix_M22(this.handle);
        elements[4] = (float)OS.Matrix_OffsetX(this.handle);
        elements[5] = (float)OS.Matrix_OffsetY(this.handle);
    }

    public void invert() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.Matrix_Invert(this.handle);
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public boolean isIdentity() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        return OS.Matrix_IsIdentity(this.handle);
    }

    public void multiply(Transform matrix) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (matrix == null) {
            SWT.error(4);
        }
        if (matrix.isDisposed()) {
            SWT.error(5);
        }
        int result = OS.Matrix_Multiply(this.handle, matrix.handle);
        OS.Matrix_M11(this.handle, OS.Matrix_M11(result));
        OS.Matrix_M12(this.handle, OS.Matrix_M12(result));
        OS.Matrix_M21(this.handle, OS.Matrix_M21(result));
        OS.Matrix_M22(this.handle, OS.Matrix_M22(result));
        OS.Matrix_OffsetX(this.handle, OS.Matrix_OffsetX(result));
        OS.Matrix_OffsetY(this.handle, OS.Matrix_OffsetY(result));
        OS.GCHandle_Free(result);
    }

    public void rotate(float angle) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.Matrix_RotatePrepend(this.handle, angle);
    }

    public void scale(float scaleX, float scaleY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.Matrix_ScalePrepend(this.handle, scaleX, scaleY);
    }

    public void setElements(float m11, float m12, float m21, float m22, float dx, float dy) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.Matrix_M11(this.handle, m11);
        OS.Matrix_M12(this.handle, m12);
        OS.Matrix_M21(this.handle, m21);
        OS.Matrix_M22(this.handle, m22);
        OS.Matrix_OffsetX(this.handle, dx);
        OS.Matrix_OffsetY(this.handle, dy);
    }

    public void transform(float[] pointArray) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (pointArray == null) {
            SWT.error(4);
        }
        int i = 0;
        while (i < pointArray.length) {
            int point = OS.gcnew_Point(pointArray[i], pointArray[i + 1]);
            int result = OS.Matrix_Transform(this.handle, point);
            pointArray[i] = (float)OS.Point_X(result);
            pointArray[i + 1] = (float)OS.Point_Y(result);
            OS.GCHandle_Free(point);
            OS.GCHandle_Free(result);
            i += 2;
        }
    }

    public void translate(float offsetX, float offsetY) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        OS.Matrix_TranslatePrepend(this.handle, offsetX, offsetY);
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Transform {*DISPOSED*}";
        }
        float[] elements = new float[6];
        this.getElements(elements);
        return "Transform {" + elements[0] + "," + elements[1] + "," + elements[2] + "," + elements[3] + "," + elements[4] + "," + elements[5] + "}";
    }
}

