/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Canvas;
import org.eclipse.swt.widgets.Widget;

public class Caret
extends Widget {
    Canvas parent;
    int x;
    int y;
    int width;
    int height;
    int imageHandle;
    boolean isVisible;
    Image image;
    Font font;

    public Caret(Canvas parent, int style) {
        super(parent, style);
        this.parent = parent;
        this.createWidget();
    }

    void createWidget() {
        this.createHandle();
        if (this.parent.getCaret() == null) {
            this.parent.setCaret(this);
        }
    }

    void createHandle() {
        int duration;
        int timespan;
        int animation;
        this.handle = OS.gcnew_StackPanel();
        if (this.handle == 0) {
            this.error(2);
        }
        if ((animation = OS.gcnew_DoubleAnimationUsingKeyFrames()) == 0) {
            this.error(2);
        }
        if ((timespan = OS.gcnew_TimeSpan(6000000L)) == 0) {
            this.error(2);
        }
        if ((duration = OS.gcnew_Duration(timespan)) == 0) {
            this.error(2);
        }
        int repeatBehavior = OS.RepeatBehavior_Forever();
        OS.Timeline_AutoReverse(animation, true);
        OS.Timeline_Duration(animation, duration);
        OS.Timeline_RepeatBehavior(animation, repeatBehavior);
        int keyFrames = OS.DoubleAnimationUsingKeyFrames_KeyFrames(animation);
        int keyTime = OS.KeyTime_Uniform();
        int keyFrame0 = OS.gcnew_DiscreteDoubleKeyFrame(0.0, keyTime);
        int keyFrame1 = OS.gcnew_DiscreteDoubleKeyFrame(0.0, keyTime);
        OS.DoubleKeyFrameCollection_Add(keyFrames, keyFrame0);
        OS.DoubleKeyFrameCollection_Add(keyFrames, keyFrame1);
        int opacityProperty = OS.UIElement_OpacityProperty();
        OS.UIElement_BeginAnimation(this.handle, opacityProperty, animation);
        int brush = OS.SystemColors_ControlTextBrush();
        OS.Panel_Background(this.handle, brush);
        this.imageHandle = OS.gcnew_Image();
        if (this.imageHandle == 0) {
            this.error(2);
        }
        OS.Image_Stretch(this.imageHandle, 0);
        OS.UIElement_Visibility(this.imageHandle, (byte)2);
        int children = OS.Panel_Children(this.handle);
        OS.UIElementCollection_Add(children, this.imageHandle);
        OS.GCHandle_Free(children);
        this.hide();
        OS.GCHandle_Free(brush);
        OS.GCHandle_Free(opacityProperty);
        OS.GCHandle_Free(keyFrames);
        OS.GCHandle_Free(keyTime);
        OS.GCHandle_Free(keyFrame0);
        OS.GCHandle_Free(keyFrame1);
        OS.GCHandle_Free(animation);
        OS.GCHandle_Free(duration);
        OS.GCHandle_Free(timespan);
        OS.GCHandle_Free(repeatBehavior);
    }

    public Rectangle getBounds() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            return new Rectangle(this.x, this.y, rect.width, rect.height);
        }
        return new Rectangle(this.x, this.y, this.width, this.height);
    }

    public Font getFont() {
        this.checkWidget();
        if (this.font == null) {
            return this.parent.display.systemFont;
        }
        return this.font;
    }

    public Image getImage() {
        this.checkWidget();
        return this.image;
    }

    public Point getLocation() {
        this.checkWidget();
        return new Point(this.x, this.y);
    }

    public Canvas getParent() {
        this.checkWidget();
        return this.parent;
    }

    public Point getSize() {
        this.checkWidget();
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            return new Point(rect.width, rect.height);
        }
        return new Point(this.width, this.height);
    }

    public boolean getVisible() {
        this.checkWidget();
        return this.isVisible;
    }

    boolean hasFocus() {
        return OS.UIElement_IsKeyboardFocused(this.parent.handle);
    }

    boolean isFocusCaret() {
        return this.parent.caret == this && this.hasFocus();
    }

    public boolean isVisible() {
        this.checkWidget();
        return OS.UIElement_IsVisible(this.handle) && this.parent.isVisible() && this.hasFocus();
    }

    void hide() {
        OS.UIElement_Visibility(this.handle, (byte)2);
    }

    void move(int x, int y) {
        OS.Canvas_SetLeft(this.handle, x);
        OS.Canvas_SetTop(this.handle, y);
    }

    void releaseHandle() {
        if (this.handle != 0) {
            OS.GCHandle_Free(this.handle);
        }
        this.handle = 0;
        if (this.imageHandle != 0) {
            OS.GCHandle_Free(this.imageHandle);
        }
        this.imageHandle = 0;
        super.releaseHandle();
    }

    void releaseParent() {
        super.releaseParent();
        if (this == this.parent.getCaret()) {
            this.parent.setCaret(null);
        }
    }

    void releaseWidget() {
        super.releaseWidget();
        this.parent = null;
        this.image = null;
        this.font = null;
    }

    void resize(int width, int height) {
        if (this.image != null) {
            Rectangle rect = this.image.getBounds();
            width = rect.width;
            height = rect.height;
        }
        if (width == 0) {
            width = 1;
        }
        OS.FrameworkElement_Width(this.handle, width);
        OS.FrameworkElement_Height(this.handle, height);
    }

    public void setBounds(int x, int y, int width, int height) {
        boolean sameExtent;
        this.checkWidget();
        boolean samePosition = this.x == x && this.y == y;
        boolean bl = sameExtent = this.width == width && this.height == height;
        if (samePosition && sameExtent) {
            return;
        }
        this.x = x;
        this.y = y;
        this.width = width;
        this.height = height;
        if (!sameExtent) {
            this.resize(width, height);
        }
        if (!samePosition) {
            this.move(x, y);
        }
    }

    public void setBounds(Rectangle rect) {
        if (rect == null) {
            this.error(4);
        }
        this.setBounds(rect.x, rect.y, rect.width, rect.height);
    }

    void show() {
        OS.UIElement_Visibility(this.handle, (byte)0);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (font != null && font.isDisposed()) {
            this.error(5);
        }
        this.font = font;
    }

    public void setImage(Image image) {
        this.checkWidget();
        if (image != null && image.isDisposed()) {
            this.error(5);
        }
        this.image = image;
        if (image != null) {
            OS.Image_Source(this.imageHandle, image.handle);
            OS.UIElement_Visibility(this.imageHandle, (byte)0);
        } else {
            OS.Image_Source(this.imageHandle, 0);
            OS.UIElement_Visibility(this.imageHandle, (byte)2);
        }
        this.resize(this.width, this.height);
    }

    public void setLocation(int x, int y) {
        this.checkWidget();
        if (this.x == x && this.y == y) {
            return;
        }
        this.x = x;
        this.y = y;
        this.move(x, y);
    }

    public void setLocation(Point location) {
        this.checkWidget();
        if (location == null) {
            this.error(4);
        }
        this.setLocation(location.x, location.y);
    }

    public void setSize(int width, int height) {
        this.checkWidget();
        if (this.width == width && this.height == height) {
            return;
        }
        this.width = width;
        this.height = height;
        this.resize(width, height);
    }

    public void setSize(Point size) {
        this.checkWidget();
        if (size == null) {
            this.error(4);
        }
        this.setSize(size.x, size.y);
    }

    public void setVisible(boolean visible) {
        this.checkWidget();
        if (visible == this.isVisible) {
            return;
        }
        this.isVisible = visible;
        if (!this.hasFocus()) {
            return;
        }
        OS.UIElement_Visibility(this.handle, visible ? (byte)0 : 1);
    }
}

