/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.menus;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.core.runtime.ISafeRunnable;
import org.eclipse.core.runtime.SafeRunner;
import org.eclipse.jface.action.ContributionItem;
import org.eclipse.jface.action.ContributionManager;
import org.eclipse.jface.action.IContributionItem;
import org.eclipse.jface.action.IContributionManager;
import org.eclipse.jface.action.ICoolBarManager;
import org.eclipse.jface.action.IMenuListener;
import org.eclipse.jface.action.IMenuManager;
import org.eclipse.jface.action.IToolBarManager;
import org.eclipse.jface.action.MenuManager;
import org.eclipse.jface.action.ToolBarContributionItem;
import org.eclipse.jface.action.ToolBarManager;
import org.eclipse.jface.internal.provisional.action.IToolBarContributionItem;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.ToolBar;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.IWorkbench;
import org.eclipse.ui.IWorkbenchWindow;
import org.eclipse.ui.PlatformUI;
import org.eclipse.ui.activities.ActivityManagerEvent;
import org.eclipse.ui.activities.IActivityManagerListener;
import org.eclipse.ui.activities.IIdentifier;
import org.eclipse.ui.activities.IIdentifierListener;
import org.eclipse.ui.activities.IdentifierEvent;
import org.eclipse.ui.internal.WorkbenchPlugin;
import org.eclipse.ui.internal.WorkbenchWindow;
import org.eclipse.ui.internal.expressions.AlwaysEnabledExpression;
import org.eclipse.ui.internal.layout.LayoutUtil;
import org.eclipse.ui.internal.menus.ContributionRoot;
import org.eclipse.ui.internal.menus.InternalMenuService;
import org.eclipse.ui.internal.menus.MenuLocationURI;
import org.eclipse.ui.internal.menus.MenuPersistence;
import org.eclipse.ui.internal.services.IEvaluationReference;
import org.eclipse.ui.internal.services.IEvaluationService;
import org.eclipse.ui.internal.util.Util;
import org.eclipse.ui.menus.AbstractContributionFactory;
import org.eclipse.ui.services.IServiceLocator;

public final class WorkbenchMenuService
extends InternalMenuService {
    private static final String PROP_VISIBLE = "visible";
    private final MenuPersistence menuPersistence;
    private IEvaluationService evaluationService;
    private IPropertyChangeListener serviceListener;
    private IServiceLocator serviceLocator;
    private IActivityManagerListener activityManagerListener;
    private Map uriToManager = new HashMap();
    private Map contributionManagerTracker = new HashMap();
    private IMenuListener menuTrackerListener;
    private Map evaluationsByItem = new HashMap();
    private Map activityListenersByItem = new HashMap();
    private Set managersAwaitingUpdates = new HashSet();
    static /* synthetic */ Class class$0;
    static /* synthetic */ Class class$1;

    public WorkbenchMenuService(IServiceLocator serviceLocator) {
        this.menuPersistence = new MenuPersistence(this);
        this.serviceLocator = serviceLocator;
        Class<?> clazz = class$0;
        if (clazz == null) {
            try {
                clazz = class$0 = Class.forName("org.eclipse.ui.internal.services.IEvaluationService");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        this.evaluationService = (IEvaluationService)serviceLocator.getService(clazz);
        this.evaluationService.addServiceListener(this.getServiceListener());
        Class<?> clazz2 = class$1;
        if (clazz2 == null) {
            try {
                clazz2 = class$1 = Class.forName("org.eclipse.ui.IWorkbench");
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new NoClassDefFoundError(classNotFoundException.getMessage());
            }
        }
        ((IWorkbench)serviceLocator.getService(clazz2)).getActivitySupport().getActivityManager().addActivityManagerListener(this.getActivityManagerListener());
    }

    private IActivityManagerListener getActivityManagerListener() {
        if (this.activityManagerListener == null) {
            this.activityManagerListener = new IActivityManagerListener(){

                public void activityManagerChanged(ActivityManagerEvent activityManagerEvent) {
                    if (activityManagerEvent.haveEnabledActivityIdsChanged()) {
                        WorkbenchMenuService.this.updateManagers();
                    }
                }
            };
        }
        return this.activityManagerListener;
    }

    private IPropertyChangeListener getServiceListener() {
        if (this.serviceListener == null) {
            this.serviceListener = new IPropertyChangeListener(){

                public void propertyChange(PropertyChangeEvent event) {
                    if (event.getProperty().equals("org.eclipse.ui.services.notifying") && !((Boolean)event.getNewValue()).booleanValue()) {
                        WorkbenchMenuService.this.updateManagers();
                    }
                }
            };
        }
        return this.serviceListener;
    }

    private void updateManagers() {
        Object[] managers = this.managersAwaitingUpdates.toArray();
        this.managersAwaitingUpdates.clear();
        int i = 0;
        while (i < managers.length) {
            IContributionManager parent;
            IContributionManager mgr = (IContributionManager)managers[i];
            mgr.update(true);
            if (mgr instanceof ToolBarManager) {
                if (!this.updateCoolBar((ToolBarManager)mgr)) {
                    this.updateTrim((ToolBarManager)mgr);
                }
            } else if (mgr instanceof MenuManager && (parent = ((MenuManager)mgr).getParent()) != null) {
                parent.update(true);
            }
            ++i;
        }
    }

    private void updateTrim(ToolBarManager mgr) {
        ToolBar control = mgr.getControl();
        if (control == null || control.isDisposed()) {
            return;
        }
        LayoutUtil.resize((Control)control);
    }

    private boolean updateCoolBar(ToolBarManager mgr) {
        IWorkbenchWindow[] windows = PlatformUI.getWorkbench().getWorkbenchWindows();
        int i = 0;
        while (i < windows.length) {
            WorkbenchWindow window = (WorkbenchWindow)windows[i];
            ICoolBarManager cb = window.getCoolBarManager2();
            if (cb != null) {
                IContributionItem[] items = cb.getItems();
                int j = 0;
                while (j < items.length) {
                    IToolBarManager tbm;
                    if (items[j] instanceof ToolBarContributionItem && mgr == (tbm = ((ToolBarContributionItem)items[j]).getToolBarManager())) {
                        cb.update(true);
                        return true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        return false;
    }

    public final void addSourceProvider(ISourceProvider provider) {
    }

    public final void dispose() {
        this.menuPersistence.dispose();
        Iterator i = this.evaluationsByItem.values().iterator();
        while (i.hasNext()) {
            IEvaluationReference ref = (IEvaluationReference)i.next();
            this.evaluationService.removeEvaluationListener(ref);
        }
        this.evaluationsByItem.clear();
        this.managersAwaitingUpdates.clear();
        if (this.serviceListener != null) {
            this.evaluationService.removeServiceListener(this.serviceListener);
            this.serviceListener = null;
        }
    }

    public final void readRegistry() {
        this.menuPersistence.read();
    }

    public final void removeSourceProvider(ISourceProvider provider) {
    }

    private String getIdFromURI(MenuLocationURI uri) {
        return String.valueOf(uri.getScheme()) + ":" + uri.getPath();
    }

    public List getAdditionsForURI(MenuLocationURI uri) {
        if (uri == null) {
            return null;
        }
        ArrayList caches = (ArrayList)this.uriToManager.get(this.getIdFromURI(uri));
        if (caches == null) {
            caches = new ArrayList();
            this.uriToManager.put(this.getIdFromURI(uri), caches);
        }
        return caches;
    }

    public void addContributionFactory(AbstractContributionFactory factory) {
        if (factory == null || factory.getLocation() == null) {
            return;
        }
        MenuLocationURI uri = new MenuLocationURI(factory.getLocation());
        String cacheId = this.getIdFromURI(uri);
        ArrayList<AbstractContributionFactory> caches = (ArrayList<AbstractContributionFactory>)this.uriToManager.get(cacheId);
        if (caches == null) {
            caches = new ArrayList<AbstractContributionFactory>();
            this.uriToManager.put(cacheId, caches);
        }
        caches.add(factory);
    }

    public void removeContributionFactory(AbstractContributionFactory factory) {
        if (factory == null || factory.getLocation() == null) {
            return;
        }
        MenuLocationURI uri = new MenuLocationURI(factory.getLocation());
        String cacheId = this.getIdFromURI(uri);
        List caches = (List)this.uriToManager.get(cacheId);
        if (caches != null) {
            caches.remove(factory);
        }
    }

    private boolean processAdditions(final IServiceLocator serviceLocatorToUse, Expression restriction, final ContributionManager mgr, final AbstractContributionFactory cache, final Set itemsAdded) {
        final int idx = this.getInsertionIndex(mgr, cache.getLocation());
        if (idx == -1) {
            return false;
        }
        final ContributionRoot ciList = new ContributionRoot(this, restriction, cache.getNamespace());
        ISafeRunnable run = new ISafeRunnable(){

            public void handleException(Throwable exception) {
            }

            public void run() throws Exception {
                int insertionIndex = idx;
                cache.createContributionItems(serviceLocatorToUse, ciList);
                if (ciList.getItems().size() > 0) {
                    WorkbenchMenuService.this.track(mgr, cache, ciList);
                    Iterator ciIter = ciList.getItems().iterator();
                    while (ciIter.hasNext()) {
                        IContributionItem ici = (IContributionItem)ciIter.next();
                        if (ici.getId() != null) {
                            itemsAdded.add(ici.getId());
                        }
                        int oldSize = mgr.getSize();
                        mgr.insert(insertionIndex, ici);
                        if (mgr.getSize() <= oldSize) continue;
                        ++insertionIndex;
                    }
                }
            }
        };
        SafeRunner.run((ISafeRunnable)run);
        return true;
    }

    private void track(ContributionManager mgr, AbstractContributionFactory cache, ContributionRoot ciList) {
        ArrayList<ContributionRoot> contributions = (ArrayList<ContributionRoot>)this.contributionManagerTracker.get(mgr);
        if (contributions == null) {
            IMenuManager m;
            contributions = new ArrayList<ContributionRoot>();
            this.contributionManagerTracker.put(mgr, contributions);
            if (mgr instanceof IMenuManager && (m = (IMenuManager)mgr).getRemoveAllWhenShown()) {
                m.addMenuListener(this.getMenuTrackerListener());
            }
        }
        contributions.add(ciList);
    }

    private IMenuListener getMenuTrackerListener() {
        if (this.menuTrackerListener == null) {
            this.menuTrackerListener = new IMenuListener(){

                public void menuAboutToShow(IMenuManager manager) {
                    WorkbenchMenuService.this.sweepContributions(manager);
                }
            };
        }
        return this.menuTrackerListener;
    }

    protected void sweepContributions(IMenuManager manager) {
        List contributions = (List)this.contributionManagerTracker.get(manager);
        if (contributions == null) {
            return;
        }
        Iterator i = contributions.iterator();
        while (i.hasNext()) {
            ContributionRoot items = (ContributionRoot)i.next();
            boolean removed = false;
            Iterator j = items.getItems().iterator();
            while (j.hasNext()) {
                IContributionItem item = (IContributionItem)j.next();
                if (!(item instanceof ContributionItem) || ((ContributionItem)item).getParent() != null) continue;
                removed = true;
                this.releaseItem(item);
            }
            if (!removed) continue;
            this.releaseCache(items);
            i.remove();
        }
    }

    private void releaseCache(ContributionRoot items) {
        items.release();
    }

    public void populateContributionManager(ContributionManager mgr, String uri) {
        this.populateContributionManager(this.serviceLocator, null, mgr, uri, true);
    }

    public void populateContributionManager(IServiceLocator serviceLocatorToUse, Expression restriction, ContributionManager mgr, String uri, boolean recurse) {
        MenuLocationURI contributionLocation = new MenuLocationURI(uri);
        List additionCaches = this.getAdditionsForURI(contributionLocation);
        ArrayList<AbstractContributionFactory> retryList = new ArrayList<AbstractContributionFactory>();
        HashSet itemsAdded = new HashSet();
        Iterator iterator = additionCaches.iterator();
        while (iterator.hasNext()) {
            AbstractContributionFactory cache = (AbstractContributionFactory)iterator.next();
            if (this.processAdditions(serviceLocatorToUse, restriction, mgr, cache, itemsAdded)) continue;
            retryList.add(cache);
        }
        boolean done = retryList.size() == 0;
        while (!done) {
            ArrayList curRetry = new ArrayList(retryList);
            int retryCount = retryList.size();
            retryList.clear();
            Iterator iterator2 = curRetry.iterator();
            while (iterator2.hasNext()) {
                AbstractContributionFactory cache = (AbstractContributionFactory)iterator2.next();
                if (this.processAdditions(serviceLocatorToUse, restriction, mgr, cache, itemsAdded)) continue;
                retryList.add(cache);
            }
            boolean bl = done = retryList.size() == 0 || retryList.size() == retryCount;
        }
        IContributionItem[] curItems = mgr.getItems();
        int i = 0;
        while (i < curItems.length) {
            IToolBarContributionItem tbci;
            if (curItems[i] instanceof ContributionManager) {
                String id = curItems[i].getId();
                if (id != null && id.length() > 0 && (recurse || itemsAdded.contains(id))) {
                    this.populateContributionManager(serviceLocatorToUse, restriction, (ContributionManager)curItems[i], String.valueOf(contributionLocation.getScheme()) + ":" + id, true);
                }
            } else if (curItems[i] instanceof IToolBarContributionItem && (tbci = (IToolBarContributionItem)curItems[i]).getId() != null && tbci.getId().length() > 0 && (recurse || itemsAdded.contains(tbci.getId()))) {
                this.populateContributionManager(serviceLocatorToUse, restriction, (ContributionManager)tbci.getToolBarManager(), String.valueOf(contributionLocation.getScheme()) + ":" + tbci.getId(), true);
            }
            ++i;
        }
    }

    private int getInsertionIndex(ContributionManager mgr, String location) {
        MenuLocationURI uri = new MenuLocationURI(location);
        String query = uri.getQuery();
        int additionsIndex = -1;
        if (query.length() == 0 || query.equals("after=additions")) {
            additionsIndex = mgr.indexOf("additions");
            additionsIndex = additionsIndex == -1 ? mgr.getItems().length : ++additionsIndex;
        } else {
            String[] queryParts = Util.split(query, '=');
            if (queryParts[1].length() > 0 && (additionsIndex = mgr.indexOf(queryParts[1])) != -1 && queryParts[0].equals("after")) {
                ++additionsIndex;
            }
        }
        return additionsIndex;
    }

    public IEvaluationContext getCurrentState() {
        return this.evaluationService.getCurrentState();
    }

    public void registerVisibleWhen(IContributionItem item, Expression visibleWhen, Expression restriction, String identifierID) {
        if (item == null) {
            throw new IllegalArgumentException("item cannot be null");
        }
        if (visibleWhen == null) {
            throw new IllegalArgumentException("visibleWhen expression cannot be null");
        }
        if (this.evaluationsByItem.get(item) != null) {
            String id = item.getId();
            WorkbenchPlugin.log("item is already registered: " + (id == null ? "no id" : id));
            return;
        }
        IIdentifier identifier = null;
        if (identifierID != null) {
            identifier = PlatformUI.getWorkbench().getActivitySupport().getActivityManager().getIdentifier(identifierID);
        }
        ContributionItemUpdater listener = new ContributionItemUpdater(item, identifier);
        if (visibleWhen != AlwaysEnabledExpression.INSTANCE) {
            IEvaluationReference ref = this.evaluationService.addEvaluationListener(visibleWhen, listener, PROP_VISIBLE, restriction);
            this.evaluationsByItem.put(item, ref);
        }
        this.activityListenersByItem.put(item, listener);
    }

    public void unregisterVisibleWhen(IContributionItem item) {
        IEvaluationReference ref;
        ContributionItemUpdater identifierListener = (ContributionItemUpdater)this.activityListenersByItem.get(item);
        if (identifierListener != null) {
            identifierListener.dispose();
        }
        if ((ref = (IEvaluationReference)this.evaluationsByItem.remove(item)) == null) {
            return;
        }
        this.evaluationService.removeEvaluationListener(ref);
    }

    public void releaseContributions(ContributionManager mgr) {
        IMenuManager m;
        List contributions = (List)this.contributionManagerTracker.remove(mgr);
        if (contributions == null) {
            return;
        }
        if (mgr instanceof IMenuManager && (m = (IMenuManager)mgr).getRemoveAllWhenShown()) {
            m.removeMenuListener(this.getMenuTrackerListener());
        }
        Iterator i = contributions.iterator();
        while (i.hasNext()) {
            ContributionRoot items = (ContributionRoot)i.next();
            Iterator j = items.getItems().iterator();
            while (j.hasNext()) {
                IContributionItem item = (IContributionItem)j.next();
                this.releaseItem(item);
            }
            this.releaseCache(items);
        }
        contributions.clear();
    }

    private void releaseItem(IContributionItem item) {
        this.unregisterVisibleWhen(item);
        if (item instanceof ContributionManager) {
            this.releaseContributions((ContributionManager)item);
        } else if (item instanceof IToolBarContributionItem) {
            IToolBarContributionItem tbci = (IToolBarContributionItem)item;
            this.releaseContributions((ContributionManager)tbci.getToolBarManager());
        }
    }

    private final class ContributionItemUpdater
    implements IPropertyChangeListener,
    IIdentifierListener {
        private final IContributionItem item;
        private IIdentifier identifier;
        private boolean lastExpressionResult = true;

        private ContributionItemUpdater(IContributionItem item, IIdentifier identifier) {
            this.item = item;
            if (identifier != null) {
                this.identifier = identifier;
                this.identifier.addIdentifierListener(this);
                this.updateVisibility();
            }
        }

        public void propertyChange(PropertyChangeEvent event) {
            if (event.getProperty() == WorkbenchMenuService.PROP_VISIBLE) {
                this.lastExpressionResult = event.getNewValue() != null ? (Boolean)event.getNewValue() : false;
                this.updateVisibility();
            }
        }

        private void updateVisibility() {
            boolean visible = this.identifier != null ? this.identifier.isEnabled() && this.lastExpressionResult : this.lastExpressionResult;
            this.item.setVisible(visible);
            IContributionManager parent = null;
            if (this.item instanceof ContributionItem) {
                parent = ((ContributionItem)this.item).getParent();
            } else if (this.item instanceof MenuManager) {
                parent = ((MenuManager)this.item).getParent();
            }
            if (parent != null) {
                parent.markDirty();
                WorkbenchMenuService.this.managersAwaitingUpdates.add(parent);
            }
        }

        public void identifierChanged(IdentifierEvent identifierEvent) {
            this.updateVisibility();
        }

        public void dispose() {
            this.identifier.removeIdentifierListener(this);
        }
    }
}

