/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.FontData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.ColorDialog;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Group;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.List;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;

public class FontDialog
extends Dialog {
    private FontData[] fontData;
    private FontData currentFontData;
    private Font sampleFont;
    private Color sampleColor;
    private RGB rgb;
    private boolean okSelected = false;
    private boolean ignoreEvents = false;
    private Hashtable characterSets = new Hashtable();
    private Shell shell;
    private List fontSetList;
    private List charSetList;
    private List faceNameList;
    private List extStyleList;
    private List fontStyleList;
    private List fontSizeList;
    private Label sampleLabel;
    private Button upButton;
    private Button downButton;
    private Button newButton;
    private Button removeButton;
    private Button okButton;
    private Button cancelButton;
    private Button colorButton;
    private static final String TEXT_SAMPLE = "AaBbYyZz";
    private static String[] SCALABLE_SIZES;
    private static final int DEFAULT_SIZE = 14;
    private static final String DEFAULT_STYLE = "medium";
    private static final Integer SCALABLE_KEY;
    private static final int LIST_WIDTH = 200;
    private static final int EXTSTYLE_WIDTH = 150;
    private static final int LIST_HEIGHT = 150;
    private static final int SAMPLE_HEIGHT = 75;
    private static final String PREFIX_ISO8859 = "iso8859";
    private static final String PREFIX_ISO646 = "iso646";
    private static final String PREFIX_UNICODE = "ucs";
    private static final String PREFIX_JAPANESE = "jis";
    private static final String PREFIX_SIMPLIFIEDCHINESE = "gb";
    private static final String PREFIX_TRADITIONALCHINESE = "cns";
    private static final String PREFIX_KOREAN = "ks";
    private static final String[] ISO_CHARSETS;

    static {
        SCALABLE_KEY = new Integer(0);
        ISO_CHARSETS = new String[]{"", SWT.getMessage("SWT_Charset_Western"), SWT.getMessage("SWT_Charset_EastEuropean"), SWT.getMessage("SWT_Charset_SouthEuropean"), SWT.getMessage("SWT_Charset_NorthEuropean"), SWT.getMessage("SWT_Charset_Cyrillic"), SWT.getMessage("SWT_Charset_Arabic"), SWT.getMessage("SWT_Charset_Greek"), SWT.getMessage("SWT_Charset_Hebrew"), SWT.getMessage("SWT_Charset_Turkish"), SWT.getMessage("SWT_Charset_Nordic"), SWT.getMessage("SWT_Charset_Thai"), "", SWT.getMessage("SWT_Charset_BalticRim"), SWT.getMessage("SWT_Charset_Celtic"), SWT.getMessage("SWT_Charset_Euro"), SWT.getMessage("SWT_Charset_Romanian")};
        SCALABLE_SIZES = new String[69];
        int i = 0;
        while (i < 69) {
            FontDialog.SCALABLE_SIZES[i] = String.valueOf(i + 4);
            ++i;
        }
    }

    public FontDialog(Shell parent) {
        this(parent, 0);
    }

    public FontDialog(Shell parent, int style) {
        super(parent, style | 0x20 | 0x800 | 0x10000);
        this.checkSubclass();
    }

    void addFonts(FontData[] fonts) {
        int i = 0;
        while (i < fonts.length) {
            Integer sizeValue;
            Hashtable<String, FontData> sizeSet;
            String extStyleName;
            Hashtable<Integer, Hashtable<String, FontData>> extStyleSet;
            String faceName;
            Hashtable faceSet;
            FontData font = fonts[i];
            String charSetName = this.getTranslatedCharSet(font, true);
            Hashtable charSet = (Hashtable)this.characterSets.get(charSetName);
            if (charSet == null) {
                charSet = new Hashtable(9);
                this.characterSets.put(charSetName, charSet);
            }
            if ((faceSet = (Hashtable)charSet.get(faceName = this.getTranslatedFaceName(font))) == null) {
                faceSet = new Hashtable(9);
                charSet.put(faceName, faceSet);
            }
            if ((extStyleSet = (Hashtable<Integer, Hashtable<String, FontData>>)faceSet.get(extStyleName = font.addStyle)) == null) {
                extStyleSet = new Hashtable<Integer, Hashtable<String, FontData>>(9);
                faceSet.put(extStyleName, extStyleSet);
            }
            if ((sizeSet = (Hashtable<String, FontData>)extStyleSet.get(sizeValue = new Integer(font.getHeight()))) == null) {
                sizeSet = new Hashtable<String, FontData>(9);
                extStyleSet.put(sizeValue, sizeSet);
            }
            String style = font.weight;
            sizeSet.put(style, font);
            ++i;
        }
    }

    void centerListIndex(List list, int index) {
        int visibleItems = list.getSize().y / list.getItemHeight();
        int topIndex = Math.max(0, index - visibleItems / 2);
        list.setTopIndex(topIndex);
    }

    FontData copyFontData(FontData data) {
        FontData result = new FontData();
        result.addStyle = data.addStyle;
        result.averageWidth = data.averageWidth;
        result.characterSetName = data.characterSetName;
        result.characterSetRegistry = data.characterSetRegistry;
        result.fontFamily = data.fontFamily;
        result.foundry = data.foundry;
        result.horizontalResolution = data.horizontalResolution;
        result.pixels = data.pixels;
        result.points = data.points;
        result.setWidth = data.setWidth;
        result.slant = data.slant;
        result.spacing = data.spacing;
        result.verticalResolution = data.verticalResolution;
        result.weight = data.weight;
        return result;
    }

    void createButtons(Composite parent) {
        int buttonAlignment = 770;
        this.okButton = new Button(parent, 8);
        this.okButton.setText(SWT.getMessage("SWT_OK"));
        this.okButton.setLayoutData(new GridData(buttonAlignment));
        this.shell.setDefaultButton(this.okButton);
        this.cancelButton = new Button(parent, 8);
        this.cancelButton.setText(SWT.getMessage("SWT_Cancel"));
        this.cancelButton.setLayoutData(new GridData(buttonAlignment));
        this.colorButton = new Button(parent, 8);
        this.colorButton.setText(SWT.getMessage("SWT_Color"));
        this.colorButton.setLayoutData(new GridData(buttonAlignment));
    }

    void createControls(Composite parent) {
        Composite composite = new Composite(parent, 0);
        GridLayout layout = new GridLayout();
        layout.numColumns = 2;
        composite.setLayout(layout);
        Composite controls = new Composite(composite, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.numColumns = 3;
        controls.setLayout(layout);
        new Label(controls, 0).setText(String.valueOf(SWT.getMessage("SWT_Character_set")) + ":");
        new Label(controls, 0).setText(String.valueOf(SWT.getMessage("SWT_Font")) + ":");
        new Label(controls, 0).setText(String.valueOf(SWT.getMessage("SWT_Extended_style")) + ":");
        this.charSetList = new List(controls, 2560);
        GridData gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.charSetList.setLayoutData(gridData);
        this.faceNameList = new List(controls, 2560);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.faceNameList.setLayoutData(gridData);
        this.extStyleList = new List(controls, 2562);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 150;
        this.extStyleList.setLayoutData(gridData);
        new Label(controls, 0).setText(String.valueOf(SWT.getMessage("SWT_Size")) + ":");
        new Label(controls, 0).setText(String.valueOf(SWT.getMessage("SWT_Style")) + ":");
        new Label(controls, 0);
        this.fontSizeList = new List(controls, 2560);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.fontSizeList.setLayoutData(gridData);
        this.fontStyleList = new List(controls, 2560);
        gridData = new GridData(768);
        gridData.heightHint = 150;
        gridData.widthHint = 200;
        this.fontStyleList.setLayoutData(gridData);
        new Label(controls, 0);
        Group fontSetGroup = new Group(controls, 0);
        fontSetGroup.setText(SWT.getMessage("SWT_FontSet"));
        layout = new GridLayout();
        layout.numColumns = 2;
        fontSetGroup.setLayout(layout);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        fontSetGroup.setLayoutData(data);
        this.fontSetList = new List(fontSetGroup, 2560);
        data = new GridData(1808);
        data.grabExcessHorizontalSpace = true;
        this.fontSetList.setLayoutData(data);
        Composite buttonsGroup = new Composite(fontSetGroup, 0);
        layout = new GridLayout();
        layout.numColumns = 3;
        layout.makeColumnsEqualWidth = false;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        buttonsGroup.setLayout(layout);
        Composite upDownButtonsGroup = new Composite(buttonsGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        upDownButtonsGroup.setLayout(layout);
        int buttonAlignment = 770;
        this.upButton = new Button(upDownButtonsGroup, 8);
        this.upButton.setLayoutData(new GridData(buttonAlignment));
        this.upButton.setText(SWT.getMessage("SWT_Up"));
        this.downButton = new Button(upDownButtonsGroup, 8);
        this.downButton.setLayoutData(new GridData(buttonAlignment));
        this.downButton.setText(SWT.getMessage("SWT_Down"));
        new Label(buttonsGroup, 514);
        Composite newRemoveButtonsGroup = new Composite(buttonsGroup, 0);
        layout = new GridLayout();
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        layout.verticalSpacing = 0;
        layout.horizontalSpacing = 0;
        newRemoveButtonsGroup.setLayout(layout);
        this.newButton = new Button(newRemoveButtonsGroup, 8);
        this.newButton.setLayoutData(new GridData(buttonAlignment));
        this.newButton.setText(SWT.getMessage("SWT_NewFont"));
        this.removeButton = new Button(newRemoveButtonsGroup, 8);
        this.removeButton.setLayoutData(new GridData(buttonAlignment));
        this.removeButton.setText(SWT.getMessage("SWT_Remove"));
        Group sampleGroup = new Group(controls, 0);
        sampleGroup.setText(SWT.getMessage("SWT_Sample"));
        gridData = new GridData();
        gridData.heightHint = 75;
        gridData.horizontalSpan = 3;
        gridData.horizontalAlignment = 4;
        sampleGroup.setLayoutData(gridData);
        layout = new GridLayout();
        layout.marginWidth = 10;
        layout.marginHeight = 10;
        sampleGroup.setLayout(layout);
        this.sampleLabel = new Label(sampleGroup, 0x1000000);
        this.sampleLabel.setText(TEXT_SAMPLE);
        gridData = new GridData();
        gridData.grabExcessHorizontalSpace = true;
        gridData.grabExcessVerticalSpace = true;
        gridData.verticalAlignment = 4;
        gridData.horizontalAlignment = 4;
        this.sampleLabel.setLayoutData(gridData);
        Composite okCancelGroup = new Composite(composite, 0);
        layout = new GridLayout();
        layout.verticalSpacing = 0;
        layout.marginWidth = 0;
        layout.marginHeight = 0;
        okCancelGroup.setLayout(layout);
        okCancelGroup.setLayoutData(new GridData(2));
        this.createButtons(okCancelGroup);
    }

    Hashtable getExtStyles(String charsetName, String faceName) {
        Hashtable faces = this.getFaces(charsetName);
        if (faces == null) {
            return null;
        }
        return (Hashtable)faces.get(faceName);
    }

    Hashtable getFaces(String charsetName) {
        return (Hashtable)this.getFonts().get(charsetName);
    }

    public FontData getFontData() {
        if (this.fontData != null && this.fontData.length > 0) {
            return this.fontData[0];
        }
        return null;
    }

    FontData getFontData(String charsetName, String faceName, String extStyle, int size, String style) {
        Hashtable styles = this.getStyles(charsetName, faceName, extStyle, size);
        if (styles == null) {
            return null;
        }
        return (FontData)styles.get(style);
    }

    public FontData[] getFontList() {
        return this.fontData;
    }

    Hashtable getFonts() {
        return this.characterSets;
    }

    String getListSelection(List list) {
        String[] selection = list.getSelection();
        if (selection.length > 0) {
            return selection[0];
        }
        return "";
    }

    public RGB getRGB() {
        return this.rgb;
    }

    FontData getSelectionFontData() {
        String style;
        FontData result;
        String charSetName = this.getListSelection(this.charSetList);
        String faceName = this.getListSelection(this.faceNameList);
        String extStyle = this.getListSelection(this.extStyleList);
        int size = 14;
        try {
            size = Integer.valueOf(this.getListSelection(this.fontSizeList));
            if (size < 1) {
                size = 14;
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((result = this.getFontData(charSetName, faceName, extStyle, size, style = this.getListSelection(this.fontStyleList))) != null) {
            result = this.copyFontData(result);
        } else {
            result = new FontData();
            result.characterSetRegistry = charSetName;
            result.setName(faceName);
            result.addStyle = extStyle;
            result.weight = style;
        }
        result.setHeight(size);
        return result;
    }

    Hashtable getSizes(String charsetName, String faceName, String extStyle) {
        Hashtable extStyles = this.getExtStyles(charsetName, faceName);
        if (extStyles == null) {
            return null;
        }
        return (Hashtable)extStyles.get(extStyle);
    }

    Hashtable getStyles(String charsetName, String faceName, String extStyle, int size) {
        Hashtable sizes = this.getSizes(charsetName, faceName, extStyle);
        if (sizes == null) {
            return null;
        }
        Hashtable result = (Hashtable)sizes.get(new Integer(size));
        if (result == null) {
            result = (Hashtable)sizes.get(SCALABLE_KEY);
        }
        return result;
    }

    String getTranslatedCharSet(FontData fontData, boolean includeDescription) {
        String characterSet = fontData.characterSetRegistry;
        String translatedCharSet = null;
        if (characterSet.startsWith(PREFIX_ISO8859)) {
            int charSetName = 1;
            try {
                charSetName = Integer.valueOf(fontData.characterSetName);
            }
            catch (NumberFormatException numberFormatException) {}
            characterSet = "iso8859-" + charSetName;
            if (charSetName < ISO_CHARSETS.length) {
                translatedCharSet = ISO_CHARSETS[charSetName];
            }
        } else if (characterSet.startsWith(PREFIX_ISO646)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_ASCII");
        } else if (characterSet.startsWith(PREFIX_UNICODE)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_Unicode");
        } else if (characterSet.startsWith(PREFIX_JAPANESE)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_Japanese");
        } else if (characterSet.startsWith(PREFIX_SIMPLIFIEDCHINESE)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_SimplifiedChinese");
        } else if (characterSet.startsWith(PREFIX_TRADITIONALCHINESE)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_TraditionalChinese");
        } else if (characterSet.startsWith(PREFIX_KOREAN)) {
            translatedCharSet = SWT.getMessage("SWT_Charset_Korean");
        }
        translatedCharSet = includeDescription && translatedCharSet != null ? String.valueOf(characterSet) + " (" + translatedCharSet + ')' : characterSet;
        return translatedCharSet;
    }

    String getTranslatedFaceName(FontData fontData) {
        StringBuffer faceNameBuffer;
        if (fontData.foundry != null && fontData.foundry.length() > 0) {
            faceNameBuffer = new StringBuffer(fontData.fontFamily);
            faceNameBuffer.append(" (");
            faceNameBuffer.append(fontData.foundry);
            faceNameBuffer.append(')');
        } else {
            faceNameBuffer = new StringBuffer(fontData.getName());
        }
        return faceNameBuffer.toString();
    }

    void handleEvent(Event event) {
        if (this.ignoreEvents) {
            return;
        }
        if (event.widget instanceof List) {
            int newSelectIndex;
            List list = (List)event.widget;
            String text = this.getListSelection(list);
            int oldSelectIndex = (Integer)list.getData();
            if (oldSelectIndex != (newSelectIndex = list.indexOf(text)) || newSelectIndex == -1) {
                this.ignoreEvents = true;
                if (list == this.charSetList) {
                    this.initFaceNameList();
                } else if (list == this.faceNameList) {
                    this.initExtStyleList();
                } else if (list == this.extStyleList) {
                    this.initSizeList();
                } else if (list == this.fontSizeList) {
                    this.initStyleList();
                } else if (event.widget == this.fontSetList) {
                    this.currentFontData = this.fontData[this.fontSetList.getSelectionIndex()];
                    this.setFontControls(this.currentFontData);
                    this.updateButtonEnablements();
                }
                this.updateSampleFont();
                this.updateFontList();
                list.setData(new Integer(newSelectIndex));
                if (newSelectIndex != -1) {
                    list.select(newSelectIndex);
                }
                this.ignoreEvents = false;
            }
            return;
        }
        if (event.widget instanceof Button) {
            if (event.widget == this.okButton) {
                this.okSelected = true;
                this.shell.close();
            } else if (event.widget == this.cancelButton) {
                this.okSelected = false;
                this.shell.close();
            } else if (event.widget == this.colorButton) {
                ColorDialog colorDialog = new ColorDialog(this.shell, 0);
                colorDialog.setRGB(this.rgb);
                RGB newRgb = colorDialog.open();
                if (newRgb != null) {
                    this.rgb = newRgb;
                    this.updateSampleColor();
                }
            } else if (event.widget == this.newButton) {
                FontData newFd;
                FontData[] newFontData = new FontData[this.fontData.length + 1];
                System.arraycopy(this.fontData, 0, newFontData, 0, this.fontData.length);
                FontData source = this.fontData[this.fontSetList.getSelectionIndex()];
                newFontData[newFontData.length - 1] = newFd = this.copyFontData(source);
                this.fontData = newFontData;
                this.updateFontList();
                this.fontSetList.select(newFontData.length - 1);
                this.fontSetList.setData(new Integer(newFontData.length - 1));
                this.fontSetList.showSelection();
                this.updateButtonEnablements();
            } else if (event.widget == this.removeButton) {
                int selectionIndex = this.fontSetList.getSelectionIndex();
                FontData[] newFontData = new FontData[this.fontData.length - 1];
                System.arraycopy(this.fontData, 0, newFontData, 0, selectionIndex);
                System.arraycopy(this.fontData, selectionIndex + 1, newFontData, selectionIndex, newFontData.length - selectionIndex);
                this.fontData = newFontData;
                this.updateFontList();
                this.updateButtonEnablements();
                this.setFontControls(this.fontData[this.fontSetList.getSelectionIndex()]);
            } else if (event.widget == this.upButton) {
                int selectionIndex = this.fontSetList.getSelectionIndex();
                FontData temp = this.fontData[selectionIndex];
                this.fontData[selectionIndex] = this.fontData[selectionIndex - 1];
                this.fontData[selectionIndex - 1] = temp;
                this.fontSetList.select(selectionIndex - 1);
                this.fontSetList.setData(new Integer(selectionIndex - 1));
                this.updateFontList();
                this.updateButtonEnablements();
            } else if (event.widget == this.downButton) {
                int selectionIndex = this.fontSetList.getSelectionIndex();
                FontData temp = this.fontData[selectionIndex];
                this.fontData[selectionIndex] = this.fontData[selectionIndex + 1];
                this.fontData[selectionIndex + 1] = temp;
                this.fontSetList.select(selectionIndex + 1);
                this.fontSetList.setData(new Integer(selectionIndex + 1));
                this.updateFontList();
                this.updateButtonEnablements();
            }
        }
    }

    void hookListeners() {
        Listener listener = new Listener(){

            public void handleEvent(Event event) {
                FontDialog.this.handleEvent(event);
            }
        };
        this.okButton.addListener(13, listener);
        this.cancelButton.addListener(13, listener);
        this.colorButton.addListener(13, listener);
        this.charSetList.addListener(13, listener);
        this.faceNameList.addListener(13, listener);
        this.fontStyleList.addListener(13, listener);
        this.extStyleList.addListener(13, listener);
        this.fontSizeList.addListener(13, listener);
        this.newButton.addListener(13, listener);
        this.removeButton.addListener(13, listener);
        this.upButton.addListener(13, listener);
        this.downButton.addListener(13, listener);
        this.fontSetList.addListener(13, listener);
    }

    void initExtStyleList() {
        String oldSelect = this.getListSelection(this.extStyleList);
        this.extStyleList.removeAll();
        String characterSet = this.getListSelection(this.charSetList);
        String faceName = this.getListSelection(this.faceNameList);
        Hashtable extStyles = this.getExtStyles(characterSet, faceName);
        this.setItemsSorted(this.extStyleList, extStyles);
        int selectIndex = this.extStyleList.indexOf(oldSelect);
        this.extStyleList.select(selectIndex);
        this.extStyleList.setData(new Integer(selectIndex));
        this.centerListIndex(this.extStyleList, selectIndex);
        this.initSizeList();
    }

    void initFaceNameList() {
        String oldSelect = this.getListSelection(this.faceNameList);
        this.faceNameList.removeAll();
        String charSetText = this.getListSelection(this.charSetList);
        if (charSetText.length() == 0) {
            return;
        }
        Hashtable faceNames = this.getFaces(charSetText);
        this.setItemsSorted(this.faceNameList, faceNames);
        int selectIndex = this.faceNameList.indexOf(oldSelect);
        selectIndex = Math.max(0, selectIndex);
        this.faceNameList.select(selectIndex);
        this.faceNameList.setData(new Integer(selectIndex));
        this.centerListIndex(this.faceNameList, selectIndex);
        this.initExtStyleList();
    }

    void initFonts() {
        Display display = this.shell.display;
        this.addFonts(display.getFontList(null, false));
        this.addFonts(display.getFontList(null, true));
        this.setItemsSorted(this.charSetList, this.getFonts());
        if (this.fontData != null) {
            Font font = new Font((Device)display, this.fontData);
            this.fontData = font.getFontData();
            this.currentFontData = this.fontData[0];
            font.dispose();
        } else {
            this.fontData = display.textFont.getFontData();
            this.currentFontData = this.fontData[0];
        }
    }

    void initSizeList() {
        int selectIndex;
        String oldSelect = this.getListSelection(this.fontSizeList);
        this.fontSizeList.removeAll();
        String characterSet = this.getListSelection(this.charSetList);
        String faceName = this.getListSelection(this.faceNameList);
        String extStyle = this.getListSelection(this.extStyleList);
        Hashtable sizes = this.getSizes(characterSet, faceName, extStyle);
        if (sizes != null) {
            if (sizes.get(SCALABLE_KEY) == null) {
                this.setSizeItemsSorted(sizes.keys());
            } else {
                Vector<Integer> allSizes = new Vector<Integer>();
                int i = 0;
                while (i < SCALABLE_SIZES.length) {
                    allSizes.addElement(Integer.valueOf(SCALABLE_SIZES[i]));
                    ++i;
                }
                Enumeration providedSizes = sizes.keys();
                while (providedSizes.hasMoreElements()) {
                    Integer size = (Integer)providedSizes.nextElement();
                    if (size.equals(SCALABLE_KEY) || allSizes.contains(size)) continue;
                    allSizes.addElement(size);
                }
                this.setSizeItemsSorted(allSizes.elements());
            }
        }
        if ((selectIndex = this.fontSizeList.indexOf(oldSelect)) == -1) {
            selectIndex = this.fontSizeList.indexOf(String.valueOf(14));
        }
        selectIndex = Math.max(0, selectIndex);
        this.fontSizeList.select(selectIndex);
        this.fontSizeList.setData(new Integer(selectIndex));
        this.centerListIndex(this.fontSizeList, selectIndex);
        this.initStyleList();
    }

    void initStyleList() {
        int selectIndex;
        String oldSelect = this.getListSelection(this.fontStyleList);
        this.fontStyleList.removeAll();
        String characterSet = this.getListSelection(this.charSetList);
        String faceName = this.getListSelection(this.faceNameList);
        String extStyle = this.getListSelection(this.extStyleList);
        try {
            int size = Integer.valueOf(this.getListSelection(this.fontSizeList));
            if (size > 0) {
                Hashtable styles = this.getStyles(characterSet, faceName, extStyle, size);
                this.setItemsSorted(this.fontStyleList, styles);
            }
        }
        catch (NumberFormatException numberFormatException) {}
        if ((selectIndex = this.fontStyleList.indexOf(oldSelect)) == -1) {
            selectIndex = this.fontStyleList.indexOf(String.valueOf(DEFAULT_STYLE));
        }
        selectIndex = Math.max(0, selectIndex);
        this.fontStyleList.select(selectIndex);
        this.fontStyleList.setData(new Integer(selectIndex));
        this.centerListIndex(this.fontStyleList, selectIndex);
    }

    public FontData open() {
        this.shell = new Shell(this.getParent(), this.getStyle() | 0x20 | 0x800 | 0x10000);
        this.shell.setLayout(new GridLayout());
        this.createControls(this.shell);
        FontData[] originalFontData = this.fontData;
        RGB originalRGB = this.rgb;
        this.initFonts();
        this.openDialog();
        this.setFontControls(this.currentFontData);
        this.updateSampleFont();
        this.updateSampleColor();
        this.updateFontList();
        this.fontSetList.select(0);
        this.fontSetList.setData(new Integer(0));
        this.updateButtonEnablements();
        this.hookListeners();
        Display display = this.shell.display;
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        FontData result = null;
        if (this.okSelected) {
            result = this.fontData[0];
        } else {
            this.fontData = originalFontData;
            this.rgb = originalRGB;
        }
        if (this.sampleFont != null) {
            this.sampleFont.dispose();
        }
        this.sampleFont = null;
        if (this.sampleColor != null) {
            this.sampleColor.dispose();
        }
        this.sampleColor = null;
        return result;
    }

    void openDialog() {
        Point pt = this.shell.computeSize(-1, -1, false);
        Display display = this.shell.display;
        Rectangle displayRect = display.getBounds();
        int widthLimit = displayRect.width * 7 / 8;
        int heightLimit = displayRect.height * 7 / 8;
        if (pt.x > widthLimit) {
            pt = this.shell.computeSize(widthLimit, -1, false);
        }
        Rectangle parentBounds = null;
        parentBounds = this.parent.isVisible() ? this.getParent().getBounds() : this.parent.getMonitor().getBounds();
        int originX = (parentBounds.width - pt.x) / 2 + parentBounds.x;
        originX = Math.max(originX, 0);
        originX = Math.min(originX, widthLimit - pt.x);
        int originY = (parentBounds.height - pt.y) / 2 + parentBounds.y;
        originY = Math.max(originY, 0);
        originY = Math.min(originY, heightLimit - pt.y);
        this.shell.setBounds(originX, originY, pt.x, pt.y);
        String title = this.getText();
        if (title.length() == 0) {
            title = SWT.getMessage("SWT_FontDialog_Title");
        }
        this.shell.setText(title);
        this.shell.open();
    }

    void setFontControls(FontData fontData) {
        this.ignoreEvents = true;
        String characterSet = this.getTranslatedCharSet(fontData, true);
        String faceName = this.getTranslatedFaceName(fontData);
        this.charSetList.select(new String[]{characterSet});
        int index = this.charSetList.indexOf(characterSet);
        this.charSetList.setData(new Integer(index));
        if (index != -1) {
            this.centerListIndex(this.charSetList, index);
        }
        this.initFaceNameList();
        this.faceNameList.select(new String[]{faceName});
        index = this.faceNameList.indexOf(faceName);
        this.faceNameList.setData(new Integer(index));
        if (index != -1) {
            this.centerListIndex(this.faceNameList, index);
        }
        this.initExtStyleList();
        this.extStyleList.select(new String[]{fontData.addStyle});
        index = this.extStyleList.indexOf(fontData.addStyle);
        this.extStyleList.setData(new Integer(index));
        if (index != -1) {
            this.centerListIndex(this.extStyleList, index);
        }
        this.initSizeList();
        String value = String.valueOf(fontData.getHeight());
        this.fontSizeList.select(new String[]{value});
        index = this.fontSizeList.indexOf(value);
        this.fontSizeList.setData(new Integer(index));
        if (index != -1) {
            this.centerListIndex(this.fontSizeList, index);
        }
        this.initStyleList();
        this.fontStyleList.select(new String[]{fontData.weight});
        index = this.fontStyleList.indexOf(fontData.weight);
        this.fontStyleList.setData(new Integer(index));
        if (index != -1) {
            this.centerListIndex(this.fontStyleList, index);
        }
        this.ignoreEvents = false;
    }

    public void setFontData(FontData fontData) {
        if (fontData == null) {
            this.fontData = null;
        } else {
            this.fontData = new FontData[1];
            this.fontData[0] = fontData;
        }
    }

    public void setFontList(FontData[] fontData) {
        this.fontData = fontData;
    }

    void setItemsSorted(List list, Hashtable items) {
        if (items == null) {
            return;
        }
        Enumeration itemKeys = items.keys();
        String[] sortedItems = new String[items.size()];
        int index = 0;
        while (itemKeys.hasMoreElements()) {
            String item = (String)itemKeys.nextElement();
            if (item.length() == 0) continue;
            sortedItems[index++] = item;
        }
        if (index != sortedItems.length) {
            String[] newItems = new String[index];
            System.arraycopy(sortedItems, 0, newItems, 0, index);
            sortedItems = newItems;
        }
        this.sort(sortedItems);
        list.setItems(sortedItems);
    }

    public void setRGB(RGB rgb) {
        this.rgb = rgb;
    }

    void setSizeItemsSorted(Enumeration itemsEnum) {
        Vector items = new Vector();
        while (itemsEnum.hasMoreElements()) {
            items.addElement(itemsEnum.nextElement());
        }
        Object[] sortedItems = new Integer[items.size()];
        items.copyInto(sortedItems);
        this.sort((Integer[])sortedItems);
        String[] sortedItemStrings = new String[items.size()];
        int i = 0;
        while (i < sortedItemStrings.length) {
            sortedItemStrings[i] = String.valueOf((Integer)sortedItems[i]);
            ++i;
        }
        this.fontSizeList.setItems(sortedItemStrings);
    }

    void sort(Integer[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j] > items[j + gap]) {
                        Integer swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void sort(String[] items) {
        int length = items.length;
        int gap = length / 2;
        while (gap > 0) {
            int i = gap;
            while (i < length) {
                int j = i - gap;
                while (j >= 0) {
                    if (items[j].compareTo(items[j + gap]) > 0) {
                        String swap = items[j];
                        items[j] = items[j + gap];
                        items[j + gap] = swap;
                    }
                    j -= gap;
                }
                ++i;
            }
            gap /= 2;
        }
    }

    void updateButtonEnablements() {
        this.removeButton.setEnabled(this.fontSetList.getItemCount() > 1);
        this.upButton.setEnabled(this.fontSetList.getSelectionIndex() > 0);
        this.downButton.setEnabled(this.fontSetList.getSelectionIndex() < this.fontSetList.getItemCount() - 1);
    }

    void updateFontList() {
        int selectionIndex = this.fontSetList.getSelectionIndex();
        int topIndex = Math.max(0, this.fontSetList.getTopIndex());
        String[] items = new String[this.fontData.length];
        int i = 0;
        while (i < this.fontData.length) {
            StringBuffer buffer = new StringBuffer();
            buffer.append(i);
            buffer.append(": ");
            buffer.append(this.getTranslatedCharSet(this.fontData[i], false));
            buffer.append("-");
            buffer.append(this.getTranslatedFaceName(this.fontData[i]));
            buffer.append("-");
            if (!this.fontData[i].addStyle.equals("")) {
                buffer.append(this.fontData[i].addStyle);
                buffer.append("-");
            }
            buffer.append(this.fontData[i].getHeight());
            buffer.append("-");
            buffer.append(this.fontData[i].weight);
            items[i] = buffer.toString();
            ++i;
        }
        this.fontSetList.setItems(items);
        if (selectionIndex >= items.length) {
            --selectionIndex;
        }
        this.fontSetList.select(selectionIndex);
        this.fontSetList.setData(new Integer(selectionIndex));
        this.fontSetList.setTopIndex(topIndex);
        this.fontSetList.showSelection();
    }

    void updateSampleColor() {
        if (this.rgb == null) {
            this.rgb = new RGB(0, 0, 0);
        }
        if (this.sampleColor != null) {
            if (this.sampleColor.getRGB().equals(this.rgb)) {
                return;
            }
            this.sampleColor.dispose();
        }
        this.sampleColor = new Color(this.parent.display, this.rgb);
        this.sampleLabel.setForeground(this.sampleColor);
    }

    void updateSampleFont() {
        FontData selectionFontData = this.getSelectionFontData();
        if (this.sampleFont != null) {
            this.sampleFont.dispose();
        }
        int selectionIndex = Math.max(0, this.fontSetList.getSelectionIndex());
        this.fontData[selectionIndex] = selectionFontData;
        this.sampleFont = new Font((Device)this.shell.display, selectionFontData);
        this.sampleLabel.setFont(this.sampleFont);
    }
}

