/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.services;

import org.eclipse.core.expressions.Expression;
import org.eclipse.core.expressions.IEvaluationContext;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.ui.ISourceProvider;
import org.eclipse.ui.internal.services.EvaluationAuthority;
import org.eclipse.ui.internal.services.EvaluationReference;
import org.eclipse.ui.internal.services.IEvaluationReference;
import org.eclipse.ui.internal.services.IEvaluationService;

public final class EvaluationService
implements IEvaluationService {
    private EvaluationAuthority restrictionAuthority;
    private EvaluationAuthority evaluationAuthority;
    private IPropertyChangeListener restrictionListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            IEvaluationReference source = (IEvaluationReference)event.getSource();
            if (source == null) {
                return;
            }
            IEvaluationReference mappedReference = source.getTargetReference();
            if (mappedReference == null) {
                return;
            }
            boolean evaluationEnabled = false;
            evaluationEnabled = event.getNewValue() != null ? (Boolean)event.getNewValue() : false;
            mappedReference.setPostingChanges(evaluationEnabled);
        }
    };

    public EvaluationService() {
        this.evaluationAuthority = new EvaluationAuthority();
        this.restrictionAuthority = new EvaluationAuthority();
    }

    public IEvaluationReference addEvaluationListener(Expression expression, IPropertyChangeListener listener, String property, Expression restrictEvaluation) {
        EvaluationReference expressionReference = new EvaluationReference(expression, listener, property, null);
        this.evaluationAuthority.addEvaluationListener(expressionReference);
        if (restrictEvaluation != null) {
            IPropertyChangeListener restrictionListener = this.getRestrictionListener();
            EvaluationReference restrictRef = new EvaluationReference(restrictEvaluation, restrictionListener, "evaluate", expressionReference);
            expressionReference.setTargetReference(restrictRef);
            this.restrictionAuthority.addEvaluationListener(restrictRef);
        }
        return expressionReference;
    }

    private IPropertyChangeListener getRestrictionListener() {
        return this.restrictionListener;
    }

    public void removeEvaluationListener(IEvaluationReference ref) {
        this.evaluationAuthority.removeEvaluationListener(ref);
        IEvaluationReference target = ref.getTargetReference();
        if (target != null) {
            this.restrictionAuthority.removeEvaluationListener(target);
        }
    }

    public void addSourceProvider(ISourceProvider provider) {
        this.restrictionAuthority.addSourceProvider(provider);
        this.evaluationAuthority.addSourceProvider(provider);
    }

    public void removeSourceProvider(ISourceProvider provider) {
        this.restrictionAuthority.removeSourceProvider(provider);
        this.evaluationAuthority.removeSourceProvider(provider);
    }

    public void dispose() {
        this.restrictionAuthority.dispose();
        this.evaluationAuthority.dispose();
    }

    public IEvaluationContext getCurrentState() {
        return this.evaluationAuthority.getCurrentState();
    }

    public void addServiceListener(IPropertyChangeListener listener) {
        this.restrictionAuthority.addServiceListener(listener);
        this.evaluationAuthority.addServiceListener(listener);
    }

    public void removeServiceListener(IPropertyChangeListener listener) {
        this.restrictionAuthority.removeServiceListener(listener);
        this.evaluationAuthority.removeServiceListener(listener);
    }
}

