/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.graphics;

import java.io.InputStream;
import org.eclipse.swt.SWT;
import org.eclipse.swt.SWTException;
import org.eclipse.swt.graphics.Color;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Drawable;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.ImageData;
import org.eclipse.swt.graphics.PaletteData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.RGB;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.graphics.Resource;
import org.eclipse.swt.internal.wpf.OS;

public final class Image
extends Resource
implements Drawable {
    public int type;
    public int handle;
    int transparentPixel = -1;
    GC memGC;
    byte[] alphaData;
    int alpha = -1;
    ImageData data;
    int width = -1;
    int height = -1;
    static final int DEFAULT_SCANLINE_PAD = 4;

    Image() {
    }

    public Image(Device device, int width, int height) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, width, height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, Image srcImage, int flag) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.device = device;
        if (srcImage == null) {
            SWT.error(4);
        }
        if (srcImage.isDisposed()) {
            SWT.error(5);
        }
        Rectangle rect = srcImage.getBounds();
        switch (flag) {
            case 0: {
                this.type = srcImage.type;
                this.handle = OS.BitmapSource_Clone(srcImage.handle);
                this.transparentPixel = srcImage.transparentPixel;
                this.alpha = srcImage.alpha;
                if (srcImage.alphaData != null) {
                    this.alphaData = new byte[srcImage.alphaData.length];
                    System.arraycopy(srcImage.alphaData, 0, this.alphaData, 0, this.alphaData.length);
                }
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 1: {
                ImageData data = srcImage.getImageData();
                PaletteData palette = data.palette;
                RGB[] rgbs = new RGB[]{device.getSystemColor(2).getRGB(), device.getSystemColor(18).getRGB(), device.getSystemColor(22).getRGB()};
                ImageData newData = new ImageData(rect.width, rect.height, 8, new PaletteData(rgbs));
                newData.alpha = data.alpha;
                newData.alphaData = data.alphaData;
                newData.maskData = data.maskData;
                newData.maskPad = data.maskPad;
                if (data.transparentPixel != -1) {
                    newData.transparentPixel = 0;
                }
                int[] scanline = new int[rect.width];
                int[] maskScanline = null;
                ImageData mask = null;
                if (data.maskData != null) {
                    mask = data.getTransparencyMask();
                }
                if (mask != null) {
                    maskScanline = new int[rect.width];
                }
                int redMask = palette.redMask;
                int greenMask = palette.greenMask;
                int blueMask = palette.blueMask;
                int redShift = palette.redShift;
                int greenShift = palette.greenShift;
                int blueShift = palette.blueShift;
                int y = 0;
                while (y < rect.height) {
                    int offset = y * newData.bytesPerLine;
                    data.getPixels(0, y, rect.width, scanline, 0);
                    if (mask != null) {
                        mask.getPixels(0, y, rect.width, maskScanline, 0);
                    }
                    int x = 0;
                    while (x < rect.width) {
                        int pixel = scanline[x];
                        if (pixel != data.transparentPixel && (mask == null || maskScanline[x] != 0)) {
                            int blue;
                            int green;
                            int red;
                            if (palette.isDirect) {
                                red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                            } else {
                                red = palette.colors[pixel].red;
                                green = palette.colors[pixel].green;
                                blue = palette.colors[pixel].blue;
                            }
                            int intensity = red * red + green * green + blue * blue;
                            newData.data[offset] = intensity < 98304 ? 1 : 2;
                        }
                        ++offset;
                        ++x;
                    }
                    ++y;
                }
                this.init(device, newData);
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
            case 2: {
                ImageData data = srcImage.getImageData();
                PaletteData palette = data.palette;
                ImageData newData = data;
                if (!palette.isDirect) {
                    RGB[] rgbs = palette.getRGBs();
                    int i = 0;
                    while (i < rgbs.length) {
                        if (data.transparentPixel != i) {
                            int intensity;
                            RGB color = rgbs[i];
                            int red = color.red;
                            int green = color.green;
                            int blue = color.blue;
                            color.green = color.blue = (intensity = red + red + green + green + green + green + green + blue >> 3);
                            color.red = color.blue;
                        }
                        ++i;
                    }
                    newData.palette = new PaletteData(rgbs);
                } else {
                    RGB[] rgbs = new RGB[256];
                    int i = 0;
                    while (i < rgbs.length) {
                        rgbs[i] = new RGB(i, i, i);
                        ++i;
                    }
                    newData = new ImageData(rect.width, rect.height, 8, new PaletteData(rgbs));
                    newData.alpha = data.alpha;
                    newData.alphaData = data.alphaData;
                    newData.maskData = data.maskData;
                    newData.maskPad = data.maskPad;
                    if (data.transparentPixel != -1) {
                        newData.transparentPixel = 254;
                    }
                    int[] scanline = new int[rect.width];
                    int redMask = palette.redMask;
                    int greenMask = palette.greenMask;
                    int blueMask = palette.blueMask;
                    int redShift = palette.redShift;
                    int greenShift = palette.greenShift;
                    int blueShift = palette.blueShift;
                    int y = 0;
                    while (y < rect.height) {
                        int offset = y * newData.bytesPerLine;
                        data.getPixels(0, y, rect.width, scanline, 0);
                        int x = 0;
                        while (x < rect.width) {
                            int pixel = scanline[x];
                            if (pixel != data.transparentPixel) {
                                int red = pixel & redMask;
                                red = redShift < 0 ? red >>> -redShift : red << redShift;
                                int green = pixel & greenMask;
                                green = greenShift < 0 ? green >>> -greenShift : green << greenShift;
                                int blue = pixel & blueMask;
                                blue = blueShift < 0 ? blue >>> -blueShift : blue << blueShift;
                                int intensity = red + red + green + green + green + green + green + blue >> 3;
                                if (newData.transparentPixel == intensity) {
                                    intensity = 255;
                                }
                                newData.data[offset] = (byte)intensity;
                            } else {
                                newData.data[offset] = -2;
                            }
                            ++offset;
                            ++x;
                        }
                        ++y;
                    }
                }
                this.init(device, newData);
                if (device.tracking) {
                    device.new_Object(this);
                }
                return;
            }
        }
        SWT.error(5);
    }

    public Image(Device device, Rectangle bounds) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (bounds == null) {
            SWT.error(4);
        }
        this.init(device, bounds.width, bounds.height);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData data) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, data);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, ImageData source, ImageData mask) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (source == null) {
            SWT.error(4);
        }
        if (mask == null) {
            SWT.error(4);
        }
        if (source.width != mask.width || source.height != mask.height) {
            SWT.error(5);
        }
        mask = ImageData.convertMask(mask);
        ImageData image = new ImageData(source.width, source.height, source.depth, source.palette, source.scanlinePad, source.data);
        image.maskPad = mask.scanlinePad;
        image.maskData = mask.data;
        this.init(device, image);
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, InputStream stream) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        this.init(device, new ImageData(stream));
        if (device.tracking) {
            device.new_Object(this);
        }
    }

    public Image(Device device, String filename) {
        if (device == null) {
            device = Device.getDevice();
        }
        if (device == null) {
            SWT.error(4);
        }
        if (filename == null) {
            SWT.error(4);
        }
        this.device = device;
        try {
            int uri;
            this.handle = OS.gcnew_BitmapImage();
            if (this.handle == 0) {
                SWT.error(2);
            }
            int length = filename.length();
            char[] chars = new char[length + 1];
            filename.getChars(0, length, chars, 0);
            int str = OS.gcnew_String(chars);
            if (str == 0) {
                SWT.error(2);
            }
            if (!OS.File_Exists(str)) {
                SWT.error(39);
            }
            if ((uri = OS.gcnew_Uri(str, 0)) == 0) {
                SWT.error(2);
            }
            OS.BitmapImage_BeginInit(this.handle);
            OS.BitmapImage_CreateOptions(this.handle, 1);
            OS.BitmapImage_UriSource(this.handle, uri);
            OS.BitmapImage_EndInit(this.handle);
            if (OS.Freezable_CanFreeze(this.handle)) {
                OS.Freezable_Freeze(this.handle);
            }
            OS.GCHandle_Free(uri);
            OS.GCHandle_Free(str);
            return;
        }
        catch (SWTException sWTException) {
            this.init(device, new ImageData(filename));
            if (device.tracking) {
                device.new_Object(this);
            }
            return;
        }
    }

    public void dispose() {
        if (this.handle == 0) {
            return;
        }
        if (this.device.isDisposed()) {
            return;
        }
        if (this.memGC != null) {
            this.memGC.dispose();
        }
        OS.GCHandle_Free(this.handle);
        this.handle = 0;
        this.memGC = null;
        if (this.device.tracking) {
            this.device.dispose_Object(this);
        }
        this.device = null;
    }

    public boolean equals(Object object) {
        if (object == this) {
            return true;
        }
        if (!(object instanceof Image)) {
            return false;
        }
        Image image = (Image)object;
        return this.device == image.device && this.handle == image.handle;
    }

    public Color getBackground() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.transparentPixel == -1) {
            return null;
        }
        return null;
    }

    public Rectangle getBounds() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (this.width == -1 || this.height == -1) {
            this.width = OS.BitmapSource_PixelWidth(this.handle);
            this.height = OS.BitmapSource_PixelHeight(this.handle);
        }
        return new Rectangle(0, 0, this.width, this.height);
    }

    Point getDPI() {
        return new Point(96, 96);
    }

    public ImageData getImageData() {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        int format = OS.BitmapSource_Format(this.handle);
        int depth = OS.PixelFormat_BitsPerPixel(format);
        int width = OS.BitmapSource_PixelWidth(this.handle);
        int height = OS.BitmapSource_PixelHeight(this.handle);
        int scanlinePad = 4;
        int bytesPerLine = ((width * depth + 7) / 8 + (scanlinePad - 1)) / scanlinePad * scanlinePad;
        byte[] buffer = new byte[bytesPerLine * height];
        int rect = OS.Int32Rect_Empty();
        OS.BitmapSource_CopyPixels(this.handle, rect, buffer, buffer.length, bytesPerLine);
        OS.GCHandle_Free(rect);
        PaletteData paletteData = null;
        int palette = OS.BitmapSource_Palette(this.handle);
        if (palette != 0) {
            int colors = OS.BitmapPalette_Colors(palette);
            int count = OS.ColorList_Count(colors);
            RGB[] rgbs = new RGB[count];
            paletteData = new PaletteData(rgbs);
            if (count != 0) {
                int index = 0;
                int enumerator = OS.ColorList_GetEnumerator(colors);
                while (OS.IEnumerator_MoveNext(enumerator)) {
                    int color = OS.ColorList_Current(enumerator);
                    rgbs[index++] = new RGB(OS.Color_R(color) & 0xFF, OS.Color_G(color) & 0xFF, OS.Color_B(color) & 0xFF);
                    OS.GCHandle_Free(color);
                }
                OS.GCHandle_Free(enumerator);
            }
            OS.GCHandle_Free(colors);
            OS.GCHandle_Free(palette);
        } else {
            int[] formats = new int[]{OS.PixelFormats_Bgr555(), OS.PixelFormats_Bgr565(), OS.PixelFormats_Bgr24(), OS.PixelFormats_Rgb24(), OS.PixelFormats_Bgr32(), OS.PixelFormats_Bgra32(), OS.PixelFormats_Pbgra32(), OS.PixelFormats_Bgr101010()};
            int i = 0;
            while (i < formats.length) {
                if (OS.Object_Equals(format, formats[i])) {
                    switch (i) {
                        case 0: {
                            paletteData = new PaletteData(31744, 992, 31);
                            break;
                        }
                        case 1: {
                            paletteData = new PaletteData(63488, 2016, 31);
                            break;
                        }
                        case 2: {
                            paletteData = new PaletteData(255, 65280, 0xFF0000);
                            break;
                        }
                        case 3: {
                            paletteData = new PaletteData(0xFF0000, 65280, 255);
                            break;
                        }
                        case 4: 
                        case 5: 
                        case 6: {
                            paletteData = new PaletteData(65280, 0xFF0000, -16777216);
                            break;
                        }
                        case 7: {
                            paletteData = new PaletteData(1023, 1047552, 0x3FF0000);
                        }
                    }
                }
                OS.GCHandle_Free(formats[i]);
                ++i;
            }
        }
        OS.GCHandle_Free(format);
        ImageData data = new ImageData(width, height, depth, paletteData, scanlinePad, buffer);
        data.transparentPixel = this.transparentPixel;
        if (this.transparentPixel == -1 && this.type == 1) {
            int maskPad = 2;
            int maskBpl = ((width + 7) / 8 + (maskPad - 1)) / maskPad * maskPad;
            byte[] maskData = new byte[height * maskBpl];
            int offset = 3;
            int maskOffset = 0;
            int y = 0;
            while (y < height) {
                int x = 0;
                while (x < width) {
                    if (buffer[offset] != 0) {
                        int n = maskOffset + (x >> 3);
                        maskData[n] = (byte)(maskData[n] | 1 << 7 - (x & 7));
                    } else {
                        int n = maskOffset + (x >> 3);
                        maskData[n] = (byte)(maskData[n] & ~(1 << 7 - (x & 7)));
                    }
                    offset += 4;
                    ++x;
                }
                maskOffset += maskBpl;
                ++y;
            }
            data.maskData = maskData;
            data.maskPad = maskPad;
        }
        data.alpha = this.alpha;
        if (this.alpha == -1 && this.alphaData != null) {
            data.alphaData = new byte[this.alphaData.length];
            System.arraycopy(this.alphaData, 0, data.alphaData, 0, this.alphaData.length);
        }
        return data;
    }

    public int hashCode() {
        return this.handle;
    }

    void init(Device device, int width, int height) {
        if (width <= 0 || height <= 0) {
            SWT.error(5);
        }
        this.device = device;
        this.type = 0;
        Point dpi = this.getDPI();
        int pixelFormat = OS.PixelFormats_Bgr24();
        int stride = width * 3;
        byte[] buffer = new byte[stride * height];
        int i = 0;
        while (i < buffer.length) {
            buffer[i] = -1;
            ++i;
        }
        this.handle = OS.BitmapSource_Create(width, height, dpi.x, dpi.y, pixelFormat, 0, buffer, buffer.length, stride);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.GCHandle_Free(pixelFormat);
        if (OS.Freezable_CanFreeze(this.handle)) {
            OS.Freezable_Freeze(this.handle);
        }
    }

    void init(Device device, ImageData data) {
        RGB[] rgbs;
        PaletteData palette = data.palette;
        if ((data.depth != 1 && data.depth != 2 && data.depth != 4 && data.depth != 8 || palette.isDirect) && data.depth != 8 && (data.depth != 16 && data.depth != 24 && data.depth != 32 || !palette.isDirect)) {
            SWT.error(38);
        }
        this.device = device;
        int width = data.width;
        int height = data.height;
        int redMask = palette.redMask;
        int greenMask = palette.greenMask;
        int blueMask = palette.blueMask;
        ImageData newData = null;
        int pixelFormat = 0;
        boolean transparent = false;
        if (data.maskData != null) {
            transparent = true;
        } else if (data.transparentPixel != -1) {
            transparent = palette.isDirect;
        } else if (data.alpha != -1) {
            transparent = palette.isDirect;
        } else {
            boolean bl = transparent = data.alphaData != null;
        }
        if (transparent) {
            pixelFormat = OS.PixelFormats_Bgra32();
            if (!palette.isDirect || data.depth != 32 || redMask != 65280 || greenMask != 0xFF0000 || blueMask != -16777216) {
                newData = new ImageData(width, height, 32, new PaletteData(65280, 0xFF0000, -16777216));
            }
        } else {
            switch (data.depth) {
                case 1: {
                    pixelFormat = OS.PixelFormats_Indexed1();
                    break;
                }
                case 2: {
                    pixelFormat = OS.PixelFormats_Indexed2();
                    break;
                }
                case 4: {
                    pixelFormat = OS.PixelFormats_Indexed4();
                    break;
                }
                case 8: {
                    if (!palette.isDirect) {
                        pixelFormat = OS.PixelFormats_Indexed8();
                        break;
                    }
                    pixelFormat = OS.PixelFormats_Bgr32();
                    newData = new ImageData(data.width, data.height, 32, new PaletteData(65280, 0xFF0000, -16777216));
                    break;
                }
                case 16: {
                    if (redMask == 31744 && greenMask == 992 && blueMask == 31) {
                        pixelFormat = OS.PixelFormats_Bgr555();
                        break;
                    }
                    if (redMask == 63488 && greenMask == 2016 && blueMask == 31) {
                        pixelFormat = OS.PixelFormats_Bgr565();
                        break;
                    }
                    pixelFormat = OS.PixelFormats_Bgr555();
                    newData = new ImageData(data.width, data.height, 16, new PaletteData(31744, 992, 31));
                    break;
                }
                case 24: {
                    if (redMask == 255 && greenMask == 65280 && blueMask == 0xFF0000) {
                        pixelFormat = OS.PixelFormats_Bgr24();
                        break;
                    }
                    if (redMask == 0xFF0000 && greenMask == 65280 && blueMask == 255) {
                        pixelFormat = OS.PixelFormats_Rgb24();
                        break;
                    }
                    pixelFormat = OS.PixelFormats_Bgr24();
                    newData = new ImageData(data.width, data.height, 24, new PaletteData(255, 65280, 0xFF0000));
                    break;
                }
                case 32: {
                    if (redMask == 1023 && greenMask == 1047552 && blueMask == 0x3FF0000) {
                        pixelFormat = OS.PixelFormats_Bgr101010();
                        break;
                    }
                    if (redMask == 65280 && greenMask == 0xFF0000 && blueMask == -16777216) {
                        pixelFormat = OS.PixelFormats_Bgr32();
                        break;
                    }
                    pixelFormat = OS.PixelFormats_Bgr32();
                    newData = new ImageData(data.width, data.height, 32, new PaletteData(65280, 0xFF0000, -16777216));
                }
            }
        }
        if (newData != null) {
            PaletteData newPalette = newData.palette;
            if (palette.isDirect) {
                ImageData.blit(1, data.data, data.depth, data.bytesPerLine, data.getByteOrder(), 0, 0, width, height, redMask, greenMask, blueMask, 255, null, 0, 0, 0, newData.data, newData.depth, newData.bytesPerLine, newData.getByteOrder(), 0, 0, width, height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
            } else {
                rgbs = palette.getRGBs();
                int length = rgbs.length;
                byte[] srcReds = new byte[length];
                byte[] srcGreens = new byte[length];
                byte[] srcBlues = new byte[length];
                int i = 0;
                while (i < rgbs.length) {
                    RGB rgb = rgbs[i];
                    if (rgb != null) {
                        srcReds[i] = (byte)rgb.red;
                        srcGreens[i] = (byte)rgb.green;
                        srcBlues[i] = (byte)rgb.blue;
                    }
                    ++i;
                }
                ImageData.blit(1, data.data, data.depth, data.bytesPerLine, data.getByteOrder(), 0, 0, width, height, srcReds, srcGreens, srcBlues, 255, null, 0, 0, 0, newData.data, newData.depth, newData.bytesPerLine, newData.getByteOrder(), 0, 0, width, height, newPalette.redMask, newPalette.greenMask, newPalette.blueMask, false, false);
            }
            if (data.transparentPixel != -1) {
                newData.transparentPixel = newPalette.getPixel(palette.getRGB(data.transparentPixel));
            }
            newData.maskPad = data.maskPad;
            newData.maskData = data.maskData;
            newData.alpha = data.alpha;
            newData.alphaData = data.alphaData;
            data = newData;
            palette = data.palette;
        }
        int bitmapPalette = 0;
        if (!palette.isDirect) {
            if (data.transparentPixel != -1) {
                this.transparentPixel = data.transparentPixel;
            } else {
                this.alpha = data.alpha;
            }
            rgbs = palette.colors;
            int list = OS.gcnew_ColorList(rgbs.length);
            int i = 0;
            while (i < rgbs.length) {
                RGB rgb = rgbs[i];
                byte alpha = data.transparentPixel != -1 ? (byte)(i == data.transparentPixel ? 0 : 255) : (byte)(data.alpha & 0xFF);
                int color = OS.Color_FromArgb(alpha, (byte)rgb.red, (byte)rgb.green, (byte)rgb.blue);
                OS.ColorList_Add(list, color);
                OS.GCHandle_Free(color);
                ++i;
            }
            bitmapPalette = OS.gcnew_BitmapPalette(list);
            OS.GCHandle_Free(list);
        }
        this.type = 0;
        if (transparent) {
            if (data.maskData != null || data.transparentPixel != -1) {
                this.type = data.transparentPixel != -1 ? 0 : 1;
                this.transparentPixel = data.transparentPixel;
                ImageData maskImage = data.getTransparencyMask();
                byte[] maskData = maskImage.data;
                int maskBpl = maskImage.bytesPerLine;
                int offset = 3;
                int maskOffset = 0;
                int y = 0;
                while (y < height) {
                    int x = 0;
                    while (x < width) {
                        data.data[offset] = (maskData[maskOffset + (x >> 3)] & 1 << 7 - (x & 7)) != 0 ? -1 : 0;
                        offset += 4;
                        ++x;
                    }
                    maskOffset += maskBpl;
                    ++y;
                }
            } else if (data.alpha != -1) {
                this.alpha = data.alpha;
                int i = 3;
                int j = 0;
                while (i < data.data.length) {
                    data.data[i] = (byte)this.alpha;
                    i += 4;
                    ++j;
                }
            } else {
                int length = data.alphaData.length;
                this.alphaData = new byte[length];
                System.arraycopy(data.alphaData, 0, this.alphaData, 0, length);
                int i = 3;
                int j = 0;
                while (i < data.data.length) {
                    data.data[i] = this.alphaData[j];
                    i += 4;
                    ++j;
                }
            }
        }
        Point dpi = this.getDPI();
        this.handle = OS.BitmapSource_Create(width, height, dpi.x, dpi.y, pixelFormat, bitmapPalette, data.data, data.data.length, data.bytesPerLine);
        if (OS.Freezable_CanFreeze(this.handle)) {
            OS.Freezable_Freeze(this.handle);
        }
        OS.GCHandle_Free(pixelFormat);
        if (bitmapPalette != 0) {
            OS.GCHandle_Free(bitmapPalette);
        }
        if (this.handle == 0) {
            SWT.error(2);
        }
    }

    public int internal_new_GC(GCData data) {
        int visual;
        if (this.handle == 0) {
            SWT.error(44);
        }
        if (this.type != 0 || this.memGC != null) {
            SWT.error(5);
        }
        if (this.width == -1 || this.height == -1) {
            this.width = OS.BitmapSource_PixelWidth(this.handle);
            this.height = OS.BitmapSource_PixelHeight(this.handle);
        }
        if ((visual = OS.gcnew_DrawingVisual()) == 0) {
            SWT.error(2);
        }
        int rect = OS.gcnew_Rect(0.0, 0.0, this.width, this.height);
        int geometry = OS.gcnew_RectangleGeometry(rect);
        OS.ContainerVisual_Clip(visual, geometry);
        int dc = OS.DrawingVisual_RenderOpen(visual);
        if (dc == 0) {
            SWT.error(2);
        }
        OS.DrawingContext_DrawImage(dc, this.handle, rect);
        OS.GCHandle_Free(rect);
        OS.GCHandle_Free(geometry);
        if (data != null) {
            int mask = 0x6000000;
            if ((data.style & mask) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this.device;
            data.image = this;
            data.background = OS.Colors_White;
            data.foreground = OS.Colors_Black;
            data.font = this.device.systemFont;
            data.visual = visual;
        }
        return dc;
    }

    public void internal_dispose_GC(int dc, GCData data) {
        OS.DrawingContext_Close(dc);
        Point dpi = this.getDPI();
        int pixelFormat = OS.PixelFormats_Pbgra32();
        int renderHandle = OS.gcnew_RenderTargetBitmap(this.width, this.height, dpi.x, dpi.y, pixelFormat);
        OS.GCHandle_Free(pixelFormat);
        if (renderHandle == 0) {
            SWT.error(2);
        }
        OS.RenderTargetBitmap_Render(renderHandle, data.visual);
        OS.GCHandle_Free(data.visual);
        OS.GCHandle_Free(dc);
        int format = OS.BitmapSource_Format(this.handle);
        int palette = OS.BitmapSource_Palette(this.handle);
        OS.GCHandle_Free(this.handle);
        this.handle = OS.gcnew_FormatConvertedBitmap(renderHandle, format, palette, 100.0);
        OS.GCHandle_Free(palette);
        OS.GCHandle_Free(format);
        if (this.handle == 0) {
            SWT.error(2);
        }
        OS.GCHandle_Free(renderHandle);
        if (OS.Freezable_CanFreeze(this.handle)) {
            OS.Freezable_Freeze(this.handle);
        }
    }

    public boolean isDisposed() {
        return this.handle == 0;
    }

    public void setBackground(Color color) {
        if (this.isDisposed()) {
            SWT.error(44);
        }
        if (color == null) {
            SWT.error(4);
        }
        if (color.isDisposed()) {
            SWT.error(5);
        }
        if (this.transparentPixel == -1) {
            return;
        }
    }

    public String toString() {
        if (this.isDisposed()) {
            return "Image {*DISPOSED*}";
        }
        return "Image {" + this.handle + "}";
    }

    public static Image wpf_new(Device device, int type, int handle) {
        if (device == null) {
            device = Device.getDevice();
        }
        Image image = new Image();
        image.type = type;
        image.handle = handle;
        image.device = device;
        return image;
    }
}

