/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Font;
import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Caret;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class Canvas
extends Composite {
    Caret caret;

    Canvas() {
    }

    public Canvas(Composite parent, int style) {
        super(parent, style);
    }

    void clearArea(int x, int y, int width, int height) {
        this.checkWidget();
    }

    public Caret getCaret() {
        this.checkWidget();
        return this.caret;
    }

    int getCaretHandle() {
        if (this.caret != null && !this.caret.isDisposed()) {
            return this.caret.handle;
        }
        return 0;
    }

    void releaseChildren(boolean destroy) {
        super.releaseChildren(destroy);
        if (this.caret != null) {
            this.caret.release(false);
            this.caret = null;
        }
    }

    public void drawBackground(GC gc, int x, int y, int width, int height) {
        Control control;
        this.checkWidget();
        if (gc == null) {
            this.error(4);
        }
        if (gc.isDisposed()) {
            this.error(5);
        }
        if ((control = this.findBackgroundControl()) != null) {
            if (width < 0) {
                x += width;
                width = -width;
            }
            if (height < 0) {
                y += height;
                height = -height;
            }
            Point pt = this.display.map(this, control, 0, 0);
            int transform = OS.gcnew_TranslateTransform(-pt.x, -pt.y);
            OS.DrawingContext_PushTransform(gc.handle, transform);
            int rect = OS.gcnew_Rect(x += pt.x, y += pt.y, width, height);
            int backgroundHandle = control.backgroundHandle();
            int property = this.backgroundProperty();
            int brush = OS.DependencyObject_GetValue(backgroundHandle, property);
            OS.GCHandle_Free(property);
            OS.DrawingContext_DrawRectangle(gc.handle, brush, 0, rect);
            OS.DrawingContext_Pop(gc.handle);
            OS.GCHandle_Free(transform);
            OS.GCHandle_Free(rect);
            OS.GCHandle_Free(brush);
        } else {
            gc.fillRectangle(x, y, width, height);
        }
    }

    public void scroll(int destX, int destY, int x, int y, int width, int height, boolean all) {
        this.checkWidget();
        this.redraw(false);
    }

    public void setCaret(Caret caret) {
        this.checkWidget();
        if (caret != null && caret.isDisposed()) {
            this.error(5);
        }
        int children = OS.Panel_Children(this.handle);
        if (this.caret != null) {
            OS.UIElementCollection_Remove(children, this.caret.handle);
        }
        this.caret = caret;
        if (caret != null) {
            OS.UIElementCollection_Insert(children, 0, caret.handle);
            if (this.hasFocus()) {
                caret.show();
            }
        }
        OS.GCHandle_Free(children);
    }

    public void setFont(Font font) {
        this.checkWidget();
        if (this.caret != null) {
            this.caret.setFont(font);
        }
        super.setFont(font);
    }

    void HandlePreviewGotKeyboardFocus(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        super.HandlePreviewGotKeyboardFocus(sender, e);
        if (this.caret != null) {
            this.caret.show();
        }
    }

    void HandleLostKeyboardFocus(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        super.HandleLostKeyboardFocus(sender, e);
        if (this.caret != null) {
            this.caret.hide();
        }
    }
}

