/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Dialog;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Widget;

public class FileDialog
extends Dialog {
    String[] filterNames = new String[0];
    String[] filterExtensions = new String[0];
    String[] fileNames = new String[0];
    String filterPath = "";
    String fileName = "";

    public FileDialog(Shell parent) {
        this(parent, 32768);
    }

    public FileDialog(Shell parent, int style) {
        super(parent, style);
        this.checkSubclass();
    }

    public String getFileName() {
        return this.fileName;
    }

    public String[] getFileNames() {
        return this.fileNames;
    }

    public String[] getFilterExtensions() {
        return this.filterExtensions;
    }

    public String[] getFilterNames() {
        return this.filterNames;
    }

    public String getFilterPath() {
        return this.filterPath;
    }

    public String open() {
        int dialog;
        if ((this.style & 0x2000) != 0) {
            dialog = OS.gcnew_SaveFileDialog();
        } else {
            dialog = OS.gcnew_OpenFileDialog();
            if ((this.style & 2) != 0) {
                OS.OpenFileDialog_Multiselect(dialog, true);
            }
        }
        int titlePtr = this.parent.createDotNetString(this.title, false);
        OS.FileDialog_Title(dialog, titlePtr);
        OS.GCHandle_Free(titlePtr);
        int fileNamePtr = this.parent.createDotNetString(this.fileName, false);
        OS.FileDialog_FileName(dialog, fileNamePtr);
        OS.GCHandle_Free(fileNamePtr);
        if (this.filterExtensions != null && this.filterExtensions.length > 0) {
            StringBuffer strFilter = new StringBuffer();
            int i = 0;
            while (i < this.filterExtensions.length) {
                if (i > 0) {
                    strFilter.append("|");
                }
                if (this.filterNames != null && i < this.filterNames.length) {
                    strFilter.append(this.filterNames[i]);
                } else {
                    strFilter.append(this.filterExtensions[i]);
                }
                strFilter.append("|");
                strFilter.append(this.filterExtensions[i]);
                ++i;
            }
            int filterPtr = this.parent.createDotNetString(strFilter.toString(), false);
            OS.FileDialog_Filter(dialog, filterPtr);
            OS.GCHandle_Free(filterPtr);
        }
        int filterPathPtr = this.parent.createDotNetString(this.filterPath, false);
        OS.FileDialog_InitialDirectory(dialog, filterPathPtr);
        OS.GCHandle_Free(filterPathPtr);
        int parentHandle = (this.parent.style & 0x4000) == 0 ? this.parent.shellHandle : 0;
        boolean success = OS.CommonDialog_ShowDialog(dialog, parentHandle);
        String fullPath = null;
        if (success) {
            int strings = OS.FileDialog_FileNames(dialog);
            int length = OS.ICollection_Count(strings);
            this.fileNames = new String[length];
            int i = 0;
            while (i < length) {
                int str = OS.IList_default(strings, i);
                int fileInfo = OS.gcnew_FileInfo(str);
                int name = OS.FileInfo_Name(fileInfo);
                this.fileNames[i] = Widget.createJavaString(name);
                if (i == 0) {
                    int dir = OS.FileInfo_DirectoryName(fileInfo);
                    this.filterPath = Widget.createJavaString(dir);
                    OS.GCHandle_Free(dir);
                }
                OS.GCHandle_Free(name);
                OS.GCHandle_Free(fileInfo);
                OS.GCHandle_Free(str);
                ++i;
            }
            OS.GCHandle_Free(strings);
            fullPath = String.valueOf(this.filterPath) + "\\" + this.fileNames[0];
        } else {
            this.fileNames = new String[0];
        }
        OS.GCHandle_Free(dialog);
        return fullPath;
    }

    public void setFileName(String string) {
        this.fileName = string;
    }

    public void setFilterExtensions(String[] extensions) {
        this.filterExtensions = extensions;
    }

    public void setFilterNames(String[] names) {
        this.filterNames = names;
    }

    public void setFilterPath(String string) {
        this.filterPath = string;
    }
}

