/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;

public class ProgressBar
extends Control {
    public ProgressBar(Composite parent, int style) {
        super(parent, ProgressBar.checkStyle(style));
    }

    static int checkStyle(int style) {
        return ProgressBar.checkBits(style |= 0x80000, 256, 512, 0, 0, 0, 0);
    }

    public Point computeSize(int wHint, int hHint, boolean changed) {
        this.checkWidget();
        int border = this.getBorderWidth();
        int width = border * 2;
        int height = border * 2;
        if ((this.style & 0x100) != 0) {
            width = (int)((double)width + OS.SystemParameters_HorizontalScrollBarButtonWidth() * 10.0);
            height = (int)((double)height + OS.SystemParameters_HorizontalScrollBarHeight());
        } else {
            width = (int)((double)width + OS.SystemParameters_VerticalScrollBarWidth());
            height = (int)((double)height + OS.SystemParameters_VerticalScrollBarButtonHeight() * 10.0);
        }
        if (wHint != -1) {
            width = wHint + border * 2;
        }
        if (hHint != -1) {
            height = hHint + border * 2;
        }
        return new Point(width, height);
    }

    void createHandle() {
        this.handle = OS.gcnew_ProgressBar();
        if (this.handle == 0) {
            this.error(2);
        }
        if ((this.style & 0x200) != 0) {
            OS.ProgressBar_Orientation(this.handle, 1);
        }
        if ((this.style & 2) != 0) {
            OS.ProgressBar_IsIndeterminate(this.handle, true);
        }
    }

    public int getMaximum() {
        this.checkWidget();
        return (int)OS.RangeBase_Maximum(this.handle);
    }

    public int getMinimum() {
        this.checkWidget();
        return (int)OS.RangeBase_Minimum(this.handle);
    }

    public int getSelection() {
        this.checkWidget();
        return (int)OS.RangeBase_Value(this.handle);
    }

    public void setMaximum(int value) {
        this.checkWidget();
        int minimum = (int)OS.RangeBase_Minimum(this.handle);
        if (minimum >= 0 && minimum < value) {
            OS.RangeBase_Maximum(this.handle, value);
        }
    }

    public void setMinimum(int value) {
        this.checkWidget();
        int maximum = (int)OS.RangeBase_Maximum(this.handle);
        if (maximum >= 0 && value < maximum) {
            OS.RangeBase_Minimum(this.handle, value);
        }
    }

    public void setSelection(int value) {
        this.checkWidget();
        if (value < 0) {
            return;
        }
        OS.RangeBase_Value(this.handle, value);
    }
}

