/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.widgets;

import org.eclipse.swt.SWT;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.TreeListener;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.internal.wpf.OS;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.TreeColumn;
import org.eclipse.swt.widgets.TreeItem;
import org.eclipse.swt.widgets.TypedListener;
import org.eclipse.swt.widgets.Widget;

public class Tree
extends Composite {
    int columns;
    int parentingHandle;
    int headerTemplate;
    int columnCount;
    int itemCount;
    int selectedItemCount;
    TreeItem[] selectedItems;
    TreeItem anchor;
    byte headerVisibility = (byte)2;
    boolean ignoreSelection;
    static final String HEADER_PART_NAME = "SWT_PART_HEADER";
    static final String CHECKBOX_PART_NAME = "SWT_PART_CHECKBOX";
    static final String IMAGE_PART_NAME = "SWT_PART_IMAGE";
    static final String TEXT_PART_NAME = "SWT_PART_TEXT";
    static final String SCROLLVIEWER_PART_NAME = "SWT_PART_SCROLLVIEWER";
    static final int BACKGROUND_NOTIFY = 3;
    static final int CHECK_NOTIFY = 4;
    static final int FONT_NOTIFY = 5;
    static final int FOREGROUND_NOTIFY = 2;
    static final int IMAGE_NOTIFY = 1;
    static final int TEXT_NOTIFY = 0;
    static String scrollViewerStyle = "<Style TargetType=\"ScrollViewer\" xmlns=\"http://schemas.microsoft.com/winfx/2006/xaml/presentation\" xmlns:s=\"clr-namespace:System;assembly=mscorlib\" xmlns:x=\"http://schemas.microsoft.com/winfx/2006/xaml\"><Setter Property=\"UIElement.Focusable\" Value=\"False\"/><Setter Property=\"Control.Template\"><Setter.Value><ControlTemplate TargetType=\"ScrollViewer\"><Grid Background=\"{TemplateBinding Panel.Background}\" SnapsToDevicePixels=\"True\"><Grid.ColumnDefinitions><ColumnDefinition Width=\"*\" /><ColumnDefinition Width=\"Auto\" /></Grid.ColumnDefinitions><Grid.RowDefinitions><RowDefinition Height=\"*\" /><RowDefinition Height=\"Auto\" /></Grid.RowDefinitions><DockPanel Margin=\"{TemplateBinding Control.Padding}\"><ScrollViewer HorizontalScrollBarVisibility=\"Hidden\" VerticalScrollBarVisibility=\"Hidden\" Focusable=\"False\" DockPanel.Dock=\"Top\"><GridViewHeaderRowPresenter Name=\"SWT_PART_HEADER\" Margin=\"2,0,2,0\" Visibility=\"Collapsed\" ColumnHeaderToolTip=\"{x:Null}\" ColumnHeaderContainerStyle=\"{x:Null}\" SnapsToDevicePixels=\"{TemplateBinding UIElement.SnapsToDevicePixels}\" AllowsColumnReorder=\"True\" ColumnHeaderTemplate=\"{x:Null}\" ColumnHeaderContextMenu=\"{x:Null}\"><GridViewHeaderRowPresenter.Columns><TemplateBinding Property=\"GridViewHeaderRowPresenter.Columns\"/></GridViewHeaderRowPresenter.Columns></GridViewHeaderRowPresenter></ScrollViewer><ScrollContentPresenter VirtualizingStackPanel.IsVirtualizing=\"True\" CanVerticallyScroll=\"False\" CanHorizontallyScroll=\"False\" Name=\"PART_ScrollContentPresenter\" SnapsToDevicePixels=\"{TemplateBinding UIElement.SnapsToDevicePixels}\" ContentTemplate=\"{TemplateBinding ContentControl.ContentTemplate}\" CanContentScroll=\"{TemplateBinding ScrollViewer.CanContentScroll}\" Content=\"{TemplateBinding ContentControl.Content}\" KeyboardNavigation.DirectionalNavigation=\"Local\" /></DockPanel><ScrollBar Value=\"{TemplateBinding HorizontalOffset}\" Maximum=\"{TemplateBinding ScrollViewer.ScrollableWidth}\" Visibility=\"{TemplateBinding ScrollViewer.ComputedHorizontalScrollBarVisibility}\" Name=\"PART_HorizontalScrollBar\" Cursor=\"Arrow\"  Minimum=\"0\"  Orientation=\"Horizontal\"  Grid.Row=\"1\" ViewportSize=\"{TemplateBinding ViewportWidth}\"/><ScrollBar Value=\"{TemplateBinding VerticalOffset}\" Maximum=\"{TemplateBinding ScrollViewer.ScrollableHeight}\" Visibility=\"{TemplateBinding ScrollViewer.ComputedVerticalScrollBarVisibility}\"  Name=\"PART_VerticalScrollBar\" Cursor=\"Arrow\" Minimum=\"0\" Orientation=\"Vertical\" Grid.Column=\"1\" ViewportSize=\"{TemplateBinding ViewportHeight}\" /><DockPanel Background=\"{x:Null}\" LastChildFill=\"False\" Grid.Column=\"1\" Grid.Row=\"1\"><Rectangle Width=\"1\" Visibility=\"{TemplateBinding ScrollViewer.ComputedVerticalScrollBarVisibility}\" Fill=\"#FFFFFFFF\" DockPanel.Dock=\"Left\" /><Rectangle Height=\"1\" Visibility=\"{TemplateBinding ScrollViewer.ComputedHorizontalScrollBarVisibility}\" Fill=\"#FFFFFFFF\" DockPanel.Dock=\"Top\" /></DockPanel></Grid></ControlTemplate></Setter.Value></Setter></Style>";

    public Tree(Composite parent, int style) {
        super(parent, Tree.checkStyle(style));
    }

    static int checkStyle(int style) {
        style |= 0x300;
        return Tree.checkBits(style |= 0x10000, 4, 2, 0, 0, 0, 0);
    }

    public void addSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(13, typedListener);
        this.addListener(14, typedListener);
    }

    public void addTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        TypedListener typedListener = new TypedListener(listener);
        this.addListener(17, typedListener);
        this.addListener(18, typedListener);
    }

    int backgroundHandle() {
        return this.parentingHandle;
    }

    boolean checkData(TreeItem item) {
        if ((this.style & 0x10000000) == 0) {
            return true;
        }
        if (!item.cached) {
            item.cached = true;
            int parentItem = OS.FrameworkElement_Parent(item.handle);
            int items = OS.ItemsControl_Items(parentItem);
            int index = OS.ItemCollection_IndexOf(items, item.handle);
            OS.GCHandle_Free(items);
            OS.GCHandle_Free(parentItem);
            Event event = new Event();
            event.item = item;
            event.index = index;
            this.sendEvent(36, event);
            if (this.isDisposed() || item.isDisposed()) {
                return false;
            }
        }
        return true;
    }

    protected void checkSubclass() {
        if (!this.isValidSubclass()) {
            this.error(43);
        }
    }

    public void clear(int index, boolean all) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            SWT.error(6);
        }
        this.clear(this.handle, index, all);
    }

    void clear(int parentHandle, int index, boolean all) {
        int items = OS.ItemsControl_Items(parentHandle);
        TreeItem item = this.getItem(items, index, false);
        if (item != null) {
            item.clear();
            if (all) {
                this.clearAll(item, true);
            }
        }
        OS.GCHandle_Free(items);
    }

    public void clearAll(boolean all) {
        this.checkWidget();
        this.clearAll(null, all);
    }

    void clearAll(TreeItem parentItem, boolean all) {
        int count = parentItem != null ? parentItem.itemCount : this.itemCount;
        int parentHandle = parentItem != null ? parentItem.handle : this.handle;
        int items = OS.ItemsControl_Items(parentHandle);
        int i = 0;
        while (i < count) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null) {
                item.clear();
                if (all) {
                    this.clearAll(item, true);
                }
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    int createCellTemplate(int index) {
        int template = OS.gcnew_DataTemplate();
        int stackPanelType = OS.StackPanel_typeid();
        int stackPanelNode = OS.gcnew_FrameworkElementFactory(stackPanelType);
        if (index == 0 && (this.style & 0x20) != 0) {
            int checkBoxType = OS.CheckBox_typeid();
            int checkBoxName = this.createDotNetString(CHECKBOX_PART_NAME, false);
            int checkBoxNode = OS.gcnew_FrameworkElementFactory(checkBoxType, checkBoxName);
            int verticalAlignmentProperty = OS.FrameworkElement_VerticalAlignmentProperty();
            OS.FrameworkElementFactory_SetValueVerticalAlignment(checkBoxNode, verticalAlignmentProperty, 1);
            int marginProperty = OS.FrameworkElement_MarginProperty();
            int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
            OS.FrameworkElementFactory_SetValue(checkBoxNode, marginProperty, thickness);
            int threeStateProperty = OS.ToggleButton_IsThreeStateProperty();
            OS.FrameworkElementFactory_SetValue(checkBoxNode, threeStateProperty, true);
            OS.FrameworkElementFactory_AppendChild(stackPanelNode, checkBoxNode);
            int checkPath = this.createDotNetString("Check", false);
            int checkBinding = OS.gcnew_Binding(checkPath);
            int isCheckedProperty = OS.ToggleButton_IsCheckedProperty();
            OS.FrameworkElementFactory_SetBinding(checkBoxNode, isCheckedProperty, checkBinding);
            OS.GCHandle_Free(checkPath);
            OS.GCHandle_Free(checkBinding);
            OS.GCHandle_Free(isCheckedProperty);
            OS.GCHandle_Free(checkBoxName);
            OS.GCHandle_Free(threeStateProperty);
            OS.GCHandle_Free(thickness);
            OS.GCHandle_Free(marginProperty);
            OS.GCHandle_Free(verticalAlignmentProperty);
            OS.GCHandle_Free(checkBoxNode);
            OS.GCHandle_Free(checkBoxType);
        }
        int textType = OS.TextBlock_typeid();
        int textName = this.createDotNetString(TEXT_PART_NAME, false);
        int textNode = OS.gcnew_FrameworkElementFactory(textType, textName);
        int imageType = OS.Image_typeid();
        int imageName = this.createDotNetString(IMAGE_PART_NAME, false);
        int imageNode = OS.gcnew_FrameworkElementFactory(imageType, imageName);
        int marginProperty = OS.FrameworkElement_MarginProperty();
        int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
        OS.FrameworkElementFactory_SetValue(imageNode, marginProperty, thickness);
        int orientationProperty = OS.StackPanel_OrientationProperty();
        OS.FrameworkElementFactory_SetValueOrientation(stackPanelNode, orientationProperty, 0);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, imageNode);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, textNode);
        OS.FrameworkTemplate_VisualTree(template, stackPanelNode);
        int cellConverter = OS.gcnew_SWTCellConverter();
        int textPath = this.createDotNetString("Text", false);
        int textBinding = OS.gcnew_Binding(textPath);
        OS.Binding_Converter(textBinding, cellConverter);
        OS.Binding_ConverterParameter(textBinding, index);
        int textProperty = OS.TextBlock_TextProperty();
        OS.FrameworkElementFactory_SetBinding(textNode, textProperty, textBinding);
        int imagePath = this.createDotNetString("Image", false);
        int imageBinding = OS.gcnew_Binding(imagePath);
        OS.Binding_Converter(imageBinding, cellConverter);
        OS.Binding_ConverterParameter(imageBinding, index);
        int imageProperty = OS.Image_SourceProperty();
        OS.FrameworkElementFactory_SetBinding(imageNode, imageProperty, imageBinding);
        OS.GCHandle_Free(textBinding);
        OS.GCHandle_Free(textPath);
        OS.GCHandle_Free(textProperty);
        OS.GCHandle_Free(imageBinding);
        OS.GCHandle_Free(imagePath);
        OS.GCHandle_Free(imageProperty);
        OS.GCHandle_Free(cellConverter);
        OS.GCHandle_Free(imageName);
        OS.GCHandle_Free(textName);
        OS.GCHandle_Free(marginProperty);
        OS.GCHandle_Free(thickness);
        OS.GCHandle_Free(stackPanelType);
        OS.GCHandle_Free(imageType);
        OS.GCHandle_Free(textType);
        OS.GCHandle_Free(stackPanelNode);
        OS.GCHandle_Free(textNode);
        OS.GCHandle_Free(imageNode);
        OS.GCHandle_Free(orientationProperty);
        return template;
    }

    int createControlTemplate() {
        int template = OS.gcnew_ControlTemplate();
        int borderType = OS.Border_typeid();
        int borderNode = OS.gcnew_FrameworkElementFactory(borderType);
        int brushProperty = OS.Control_BorderBrushProperty();
        int brushBinding = OS.gcnew_TemplateBindingExtension(brushProperty);
        OS.FrameworkElementFactory_SetValue(borderNode, brushProperty, brushBinding);
        int thicknessProperty = OS.Control_BorderThicknessProperty();
        int thicknessBinding = OS.gcnew_TemplateBindingExtension(thicknessProperty);
        OS.FrameworkElementFactory_SetValue(borderNode, thicknessProperty, thicknessBinding);
        int scrollViewerType = OS.ScrollViewer_typeid();
        int scrollViewerName = this.createDotNetString(SCROLLVIEWER_PART_NAME, false);
        int scrollViewerNode = OS.gcnew_FrameworkElementFactory(scrollViewerType, scrollViewerName);
        int itemsPresenterType = OS.ItemsPresenter_typeid();
        int itemsPresenterNode = OS.gcnew_FrameworkElementFactory(itemsPresenterType);
        OS.FrameworkElementFactory_AppendChild(borderNode, scrollViewerNode);
        OS.FrameworkElementFactory_AppendChild(scrollViewerNode, itemsPresenterNode);
        int scrollStyle = this.createDotNetString(scrollViewerStyle, false);
        int stringReader = OS.gcnew_StringReader(scrollStyle);
        int xmlReader = OS.XmlReader_Create(stringReader);
        int xamlStyle = OS.XamlReader_Load(xmlReader);
        int styleProperty = OS.FrameworkElement_StyleProperty();
        OS.FrameworkElementFactory_SetValue(scrollViewerNode, styleProperty, xamlStyle);
        int columnsProperty = OS.GridViewRowPresenterBase_ColumnsProperty();
        OS.FrameworkElementFactory_SetValue(scrollViewerNode, columnsProperty, this.columns);
        OS.FrameworkTemplate_VisualTree(template, borderNode);
        OS.GCHandle_Free(brushProperty);
        OS.GCHandle_Free(thicknessProperty);
        OS.GCHandle_Free(brushBinding);
        OS.GCHandle_Free(thicknessBinding);
        OS.GCHandle_Free(scrollStyle);
        OS.GCHandle_Free(stringReader);
        OS.GCHandle_Free(xmlReader);
        OS.GCHandle_Free(styleProperty);
        OS.GCHandle_Free(columnsProperty);
        OS.GCHandle_Free(xamlStyle);
        OS.GCHandle_Free(scrollViewerType);
        OS.GCHandle_Free(scrollViewerName);
        OS.GCHandle_Free(scrollViewerNode);
        OS.GCHandle_Free(borderType);
        OS.GCHandle_Free(borderNode);
        OS.GCHandle_Free(itemsPresenterType);
        OS.GCHandle_Free(itemsPresenterNode);
        return template;
    }

    void createHandle() {
        this.parentingHandle = OS.gcnew_Canvas();
        if (this.parentingHandle == 0) {
            this.error(2);
        }
        this.handle = (this.style & 4) != 0 ? OS.gcnew_TreeView() : OS.gcnew_SWTTreeView(this.jniRef);
        if (this.handle == 0) {
            this.error(2);
        }
        OS.Canvas_SetLeft(this.handle, 0.0);
        OS.Canvas_SetTop(this.handle, 0.0);
        int children = OS.Panel_Children(this.parentingHandle);
        OS.UIElementCollection_Add(children, this.handle);
        OS.GCHandle_Free(children);
    }

    int createHeaderTemplate() {
        int template = OS.gcnew_DataTemplate();
        int stackPanelType = OS.StackPanel_typeid();
        int stackPanelNode = OS.gcnew_FrameworkElementFactory(stackPanelType);
        int textType = OS.TextBlock_typeid();
        int textName = this.createDotNetString(TEXT_PART_NAME, false);
        int textNode = OS.gcnew_FrameworkElementFactory(textType, textName);
        int imageType = OS.Image_typeid();
        int imageName = this.createDotNetString(IMAGE_PART_NAME, false);
        int imageNode = OS.gcnew_FrameworkElementFactory(imageType, imageName);
        int marginProperty = OS.FrameworkElement_MarginProperty();
        int thickness = OS.gcnew_Thickness(0.0, 0.0, 4.0, 0.0);
        OS.FrameworkElementFactory_SetValue(imageNode, marginProperty, thickness);
        int orientationProperty = OS.StackPanel_OrientationProperty();
        OS.FrameworkElementFactory_SetValueOrientation(stackPanelNode, orientationProperty, 0);
        int stretchProperty = OS.Image_StretchProperty();
        OS.FrameworkElementFactory_SetValueStretch(imageNode, stretchProperty, 0);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, imageNode);
        OS.FrameworkElementFactory_AppendChild(stackPanelNode, textNode);
        OS.FrameworkTemplate_VisualTree(template, stackPanelNode);
        int textPath = this.createDotNetString("Text", false);
        int textBinding = OS.gcnew_Binding(textPath);
        int textProperty = OS.TextBlock_TextProperty();
        OS.FrameworkElementFactory_SetBinding(textNode, textProperty, textBinding);
        int imagePath = this.createDotNetString("Image", false);
        int imageBinding = OS.gcnew_Binding(imagePath);
        int imageProperty = OS.Image_SourceProperty();
        OS.FrameworkElementFactory_SetBinding(imageNode, imageProperty, imageBinding);
        OS.GCHandle_Free(textPath);
        OS.GCHandle_Free(textBinding);
        OS.GCHandle_Free(textProperty);
        OS.GCHandle_Free(imagePath);
        OS.GCHandle_Free(imageBinding);
        OS.GCHandle_Free(imageProperty);
        OS.GCHandle_Free(imageType);
        OS.GCHandle_Free(textName);
        OS.GCHandle_Free(textType);
        OS.GCHandle_Free(stackPanelType);
        OS.GCHandle_Free(stackPanelNode);
        OS.GCHandle_Free(textNode);
        OS.GCHandle_Free(marginProperty);
        OS.GCHandle_Free(thickness);
        OS.GCHandle_Free(imageName);
        OS.GCHandle_Free(imageNode);
        OS.GCHandle_Free(orientationProperty);
        OS.GCHandle_Free(stretchProperty);
        return template;
    }

    void createItem(TreeColumn column, int index) {
        int template;
        if (index < 0 || index > this.columnCount) {
            this.error(6);
        }
        if (this.columnCount == 0) {
            this.columns = OS.gcnew_GridViewColumnCollection();
            if (this.columns == 0) {
                this.error(2);
            }
            template = this.createControlTemplate();
            OS.Control_Template(this.handle, template);
            OS.GCHandle_Free(template);
            this.updateHeaderVisibility();
        }
        column.createWidget();
        template = this.createHeaderTemplate();
        OS.GridViewColumn_HeaderTemplate(column.handle, template);
        OS.GCHandle_Free(template);
        template = this.createCellTemplate(index);
        OS.GridViewColumn_CellTemplate(column.handle, template);
        OS.GCHandle_Free(template);
        if (this.columnCount == 0) {
            OS.GridViewColumnCollection_Clear(this.columns);
        }
        OS.GridViewColumnCollection_Insert(this.columns, index, column.handle);
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null) {
                item.columnAdded(index);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        ++this.columnCount;
    }

    void createItem(TreeItem item, TreeItem parentItem, int index) {
        int itemCount;
        int n = itemCount = parentItem != null ? parentItem.itemCount : this.itemCount;
        if (index < 0 || index > itemCount) {
            this.error(6);
        }
        item.createWidget();
        int parentHandle = parentItem != null ? parentItem.handle : this.handle;
        int items = OS.ItemsControl_Items(parentHandle);
        OS.ItemCollection_Insert(items, index, item.handle);
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (itemCount == count) {
            this.error(14);
        }
        if (parentItem != null) {
            ++parentItem.itemCount;
        } else {
            ++this.itemCount;
        }
    }

    void createWidget() {
        super.createWidget();
        if ((this.style & 2) != 0) {
            this.selectedItemCount = 0;
            this.selectedItems = new TreeItem[4];
        }
        this.headerTemplate = this.createCellTemplate(0);
        int brush = OS.Brushes_Transparent();
        OS.Control_Background(this.handle, brush);
        OS.GCHandle_Free(brush);
    }

    int defaultBackground() {
        return OS.Colors_White;
    }

    void deregister() {
        super.deregister();
        this.display.removeWidget(this.parentingHandle);
    }

    public void deselectAll() {
        this.checkWidget();
        int itemRef = OS.TreeView_SelectedItem(this.handle);
        if (itemRef != 0) {
            this.ignoreSelection = true;
            OS.TreeViewItem_IsSelected(itemRef, false);
            this.ignoreSelection = false;
            OS.GCHandle_Free(itemRef);
        }
        if ((this.style & 2) != 0) {
            int i = 0;
            while (i < this.selectedItemCount) {
                TreeItem item = this.selectedItems[i];
                OS.TreeViewItem_IsSelected(item.handle, false);
                ++i;
            }
            this.selectedItems = new TreeItem[4];
            this.selectedItemCount = 0;
        }
    }

    void destroyItem(TreeColumn column) {
        int index = OS.GridViewColumnCollection_IndexOf(this.columns, column.handle);
        boolean removed = OS.GridViewColumnCollection_Remove(this.columns, column.handle);
        if (!removed) {
            this.error(15);
        }
        --this.columnCount;
        if (this.columnCount == 0) {
            OS.GCHandle_Free(this.columns);
            this.columns = 0;
            int templateProperty = OS.Control_TemplateProperty();
            OS.DependencyObject_ClearValue(this.handle, templateProperty);
            OS.GCHandle_Free(templateProperty);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null) {
                item.columnRemoved(index);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
    }

    void destroyItem(TreeItem item) {
        TreeItem parentItem = item.getParentItem();
        int itemCount = parentItem != null ? parentItem.itemCount : this.itemCount;
        int parentHandle = parentItem != null ? parentItem.handle : this.handle;
        int items = OS.ItemsControl_Items(parentHandle);
        OS.ItemCollection_Remove(items, item.handle);
        int count = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (count == itemCount) {
            this.error(15);
        }
        if (parentItem != null) {
            --parentItem.itemCount;
        } else {
            --this.itemCount;
        }
    }

    int findScrollViewer(int current, int scrollViewerType) {
        if (this.columnCount != 0) {
            int template = OS.Control_Template(this.handle);
            int scrollViewerName = this.createDotNetString(SCROLLVIEWER_PART_NAME, false);
            int scrollViewer = OS.FrameworkTemplate_FindName(template, scrollViewerName, this.handle);
            OS.GCHandle_Free(scrollViewerName);
            OS.GCHandle_Free(template);
            return scrollViewer;
        }
        return super.findScrollViewer(current, scrollViewerType);
    }

    void fixScrollbarVisibility() {
        int typeid = OS.ScrollViewer_typeid();
        int scrolledHandle = this.findScrollViewer(this.handle, typeid);
        OS.ScrollViewer_SetHorizontalScrollBarVisibility(scrolledHandle, 3);
        OS.ScrollViewer_SetVerticalScrollBarVisibility(scrolledHandle, 3);
        OS.GCHandle_Free(scrolledHandle);
        OS.GCHandle_Free(typeid);
    }

    int GetBackground(int itemHandle) {
        TreeItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.backgroundList;
    }

    int GetCheck(int itemHandle) {
        TreeItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.checkState;
    }

    int GetFont(int itemHandle) {
        TreeItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.fontList;
    }

    int GetForeground(int itemHandle) {
        TreeItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.foregroundList;
    }

    int GetImage(int itemHandle) {
        TreeItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.imageList;
    }

    int GetText(int itemHandle) {
        TreeItem item = this.getItem(itemHandle, true);
        this.checkData(item);
        return item.stringList;
    }

    public int getGridLineWidth() {
        this.checkWidget();
        return 0;
    }

    public int getHeaderHeight() {
        this.checkWidget();
        return 0;
    }

    public boolean getHeaderVisible() {
        this.checkWidget();
        return false;
    }

    public TreeColumn getColumn(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.columnCount) {
            this.error(6);
        }
        return this._getColumn(index);
    }

    TreeColumn _getColumn(int index) {
        if (this.columnCount == 0) {
            return null;
        }
        int gridColumn = OS.GridViewColumnCollection_default(this.columns, index);
        int header = OS.GridViewColumn_Header(gridColumn);
        TreeColumn column = (TreeColumn)this.display.getWidget(header);
        OS.GCHandle_Free(gridColumn);
        OS.GCHandle_Free(header);
        return column;
    }

    public int getColumnCount() {
        this.checkWidget();
        return this.columnCount;
    }

    public int[] getColumnOrder() {
        this.checkWidget();
        int[] order = new int[this.columnCount];
        int i = 0;
        while (i < order.length) {
            order[i] = i;
            ++i;
        }
        return order;
    }

    public TreeColumn[] getColumns() {
        this.checkWidget();
        TreeColumn[] treeColumns = new TreeColumn[this.columnCount];
        int i = 0;
        while (i < treeColumns.length) {
            treeColumns[i] = this._getColumn(i);
            ++i;
        }
        return treeColumns;
    }

    public TreeItem getItem(int index) {
        this.checkWidget();
        if (index < 0 || index >= this.itemCount) {
            this.error(6);
        }
        int items = OS.ItemsControl_Items(this.handle);
        TreeItem treeItem = this.getItem(items, index, true);
        OS.GCHandle_Free(items);
        return treeItem;
    }

    TreeItem getItem(int items, int index, boolean create) {
        int item = OS.ItemCollection_GetItemAt(items, index);
        TreeItem result = this.getItem(item, create);
        OS.GCHandle_Free(item);
        return result;
    }

    TreeItem getItem(int item, boolean create) {
        int tag = OS.FrameworkElement_Tag(item);
        if (tag != 0) {
            int contentValue = OS.IntPtr_ToInt32(tag);
            OS.GCHandle_Free(tag);
            return (TreeItem)OS.JNIGetObject(contentValue);
        }
        if (create) {
            int itemHandle = OS.GCHandle_Alloc(item);
            int parentHandle = OS.FrameworkElement_Parent(item);
            TreeItem parentItem = null;
            if (!OS.Object_Equals(parentHandle, this.handle)) {
                parentItem = (TreeItem)this.display.getWidget(parentHandle);
            }
            OS.GCHandle_Free(parentHandle);
            return new TreeItem(this, parentItem, 0, 0, itemHandle);
        }
        return null;
    }

    public TreeItem getItem(Point point) {
        this.checkWidget();
        if (point == null) {
            this.error(4);
        }
        int pt = OS.gcnew_Point(point.x, point.y);
        int input = OS.UIElement_InputHitTest(this.handle, pt);
        OS.GCHandle_Free(pt);
        if (input == 0) {
            return null;
        }
        Widget widget = this.display.getWidget(input);
        OS.GCHandle_Free(input);
        if (widget instanceof TreeItem) {
            return (TreeItem)widget;
        }
        return null;
    }

    public int getItemCount() {
        this.checkWidget();
        return this.itemCount;
    }

    public int getItemHeight() {
        this.checkWidget();
        if (this.itemCount == 0) {
            return 16;
        }
        int items = OS.ItemsControl_Items(this.handle);
        int item = OS.ItemCollection_GetItemAt(items, 0);
        double height = OS.FrameworkElement_ActualHeight(item);
        OS.GCHandle_Free(item);
        OS.GCHandle_Free(items);
        return height != 0.0 ? (int)height : 16;
    }

    public TreeItem[] getItems() {
        this.checkWidget();
        TreeItem[] result = new TreeItem[this.itemCount];
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            result[i] = this.getItem(items, i, true);
            ++i;
        }
        OS.GCHandle_Free(items);
        return result;
    }

    public boolean getLinesVisible() {
        this.checkWidget();
        return false;
    }

    public TreeItem getParentItem() {
        this.checkWidget();
        return null;
    }

    public TreeItem[] getSelection() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int item = OS.TreeView_SelectedItem(this.handle);
            if (item == 0) {
                return new TreeItem[0];
            }
            TreeItem result = (TreeItem)this.display.getWidget(item);
            OS.GCHandle_Free(item);
            return new TreeItem[]{result};
        }
        TreeItem[] result = new TreeItem[this.selectedItemCount];
        System.arraycopy(this.selectedItems, 0, result, 0, this.selectedItemCount);
        return result;
    }

    public int getSelectionCount() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            int item = OS.TreeView_SelectedItem(this.handle);
            int result = item == 0 ? 0 : 1;
            OS.GCHandle_Free(item);
            return result;
        }
        return this.selectedItemCount;
    }

    public TreeColumn getSortColumn() {
        this.checkWidget();
        return null;
    }

    public int getSortDirection() {
        this.checkWidget();
        return 0;
    }

    public TreeItem getTopItem() {
        this.checkWidget();
        return null;
    }

    boolean hasItems() {
        return true;
    }

    void HandleChecked(int sender, int e) {
        int checkbox;
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        int origsource = OS.RoutedEventArgs_OriginalSource(e);
        int typeid = OS.CheckBox_typeid();
        boolean isCheckBox = OS.Type_IsInstanceOfType(typeid, origsource);
        OS.GCHandle_Free(typeid);
        OS.GCHandle_Free(origsource);
        if (!isCheckBox) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        TreeItem item = (TreeItem)this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (!OS.FrameworkElement_IsLoaded(item.handle)) {
            return;
        }
        if (item.grayed && (checkbox = item.findPart(0, CHECKBOX_PART_NAME)) != 0) {
            OS.ToggleButton_IsCheckedNullSetter(checkbox);
            OS.GCHandle_Free(checkbox);
        }
        item.checked = true;
        item.updateCheckState(false);
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        this.sendEvent(13, event);
    }

    void HandleCollapsed(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        if (OS.ItemsControl_HasItems(source)) {
            Event event = new Event();
            event.item = (TreeItem)this.display.getWidget(source);
            this.sendEvent(18, event);
        }
        OS.GCHandle_Free(source);
    }

    void HandleExpanded(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        if (OS.ItemsControl_HasItems(source)) {
            Event event = new Event();
            event.item = (TreeItem)this.display.getWidget(source);
            this.sendEvent(17, event);
        }
        OS.GCHandle_Free(source);
    }

    void HandleIndeterminate(int sender, int e) {
        int checkbox;
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        TreeItem item = (TreeItem)this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (!OS.FrameworkElement_IsLoaded(item.handle)) {
            return;
        }
        if (!item.grayed && (checkbox = item.findPart(0, CHECKBOX_PART_NAME)) != 0) {
            OS.ToggleButton_IsChecked(checkbox, false);
            OS.GCHandle_Free(checkbox);
        }
    }

    void HandlePreviewKeyDown(int sender, int e) {
        super.HandlePreviewKeyDown(sender, e);
        if (!this.checkEvent(e)) {
            return;
        }
        int key = OS.KeyEventArgs_Key(e);
        if (key == 6) {
            int source = OS.RoutedEventArgs_OriginalSource(e);
            Widget widget = this.display.getWidget(source);
            OS.GCHandle_Free(source);
            if (widget instanceof TreeItem) {
                Event event = new Event();
                event.item = (TreeItem)widget;
                this.postEvent(14, event);
            }
        }
    }

    void HandleLoaded(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        this.updateHeaderVisibility();
    }

    void HandleMouseDoubleClick(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_OriginalSource(e);
        Widget widget = this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (widget instanceof TreeItem) {
            Event event = new Event();
            event.item = (TreeItem)widget;
            this.postEvent(14, event);
        }
    }

    void HandlePreviewMouseDown(int sender, int e) {
        super.HandlePreviewMouseDown(sender, e);
        if ((this.style & 4) != 0) {
            return;
        }
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        Widget widget = this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (widget instanceof TreeItem) {
            boolean selected;
            boolean rightClick;
            TreeItem item = (TreeItem)widget;
            int modifiers = OS.Keyboard_Modifiers();
            boolean ctrl = (modifiers & 2) == 2;
            boolean shift = (modifiers & 4) == 4;
            boolean bl = rightClick = OS.MouseEventArgs_RightButton(e) == 1;
            if (rightClick && (ctrl || shift)) {
                return;
            }
            if (ctrl) {
                int selectedItem;
                selected = OS.TreeViewItem_IsSelected(item.handle);
                if (item == this.anchor) {
                    OS.TreeViewItem_IsSelected(item.handle, !selected);
                }
                if (selected && (selectedItem = OS.TreeView_SelectedItem(this.handle)) != 0) {
                    if (OS.Object_Equals(item.handle, selectedItem)) {
                        OS.TreeViewItem_IsSelected(selectedItem, false);
                    }
                    OS.GCHandle_Free(selectedItem);
                }
            }
            if (!shift || this.anchor == null) {
                this.anchor = item;
            }
            if (!shift && !ctrl) {
                selected = false;
                int i = 0;
                while (i < this.selectedItemCount) {
                    if (this.selectedItems[i] == item) {
                        selected = true;
                        break;
                    }
                    ++i;
                }
                if (selected && rightClick) {
                    return;
                }
                this.deselectAll();
                this.insertSelectedItem(item, 0);
                OS.TreeViewItem_IsSelected(item.handle, true);
            }
        }
    }

    void HandleSelectedItemChanged(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        if (this.ignoreSelection) {
            return;
        }
        int selectedItem = OS.TreeView_SelectedItem(this.handle);
        if (selectedItem == 0) {
            return;
        }
        TreeItem item = (TreeItem)this.display.getWidget(selectedItem);
        OS.GCHandle_Free(selectedItem);
        Event event = new Event();
        event.item = item;
        this.postEvent(13, event);
    }

    void HandleUnchecked(int sender, int e) {
        if (!this.checkEvent(e)) {
            return;
        }
        int source = OS.RoutedEventArgs_Source(e);
        TreeItem item = (TreeItem)this.display.getWidget(source);
        OS.GCHandle_Free(source);
        if (!OS.FrameworkElement_IsLoaded(item.handle)) {
            return;
        }
        item.checked = false;
        item.updateCheckState(false);
        Event event = new Event();
        event.item = item;
        event.detail = 32;
        this.sendEvent(13, event);
    }

    void hookEvents() {
        super.hookEvents();
        int handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleLoaded");
        if (handler == 0) {
            this.error(2);
        }
        OS.FrameworkElement_Loaded(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedPropertyChangedEventHandlerObject(this.jniRef, "HandleSelectedItemChanged");
        if (handler == 0) {
            this.error(2);
        }
        OS.TreeView_SelectedItemChanged(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_MouseButtonEventHandler(this.jniRef, "HandleMouseDoubleClick");
        if (handler == 0) {
            this.error(2);
        }
        OS.Control_MouseDoubleClick(this.handle, handler);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleExpanded");
        if (handler == 0) {
            this.error(2);
        }
        int event = OS.TreeViewItem_ExpandedEvent();
        OS.UIElement_AddHandler(this.handle, event, handler);
        OS.GCHandle_Free(event);
        OS.GCHandle_Free(handler);
        handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleCollapsed");
        if (handler == 0) {
            this.error(2);
        }
        event = OS.TreeViewItem_CollapsedEvent();
        OS.UIElement_AddHandler(this.handle, event, handler);
        OS.GCHandle_Free(event);
        OS.GCHandle_Free(handler);
        if ((this.style & 0x20) != 0) {
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleChecked");
            if (handler == 0) {
                this.error(2);
            }
            event = OS.ToggleButton_CheckedEvent();
            OS.UIElement_AddHandler(this.handle, event, handler);
            OS.GCHandle_Free(event);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleUnchecked");
            if (handler == 0) {
                this.error(2);
            }
            event = OS.ToggleButton_UncheckedEvent();
            OS.UIElement_AddHandler(this.handle, event, handler);
            OS.GCHandle_Free(event);
            OS.GCHandle_Free(handler);
            handler = OS.gcnew_RoutedEventHandler(this.jniRef, "HandleIndeterminate");
            if (handler == 0) {
                this.error(2);
            }
            event = OS.ToggleButton_IndeterminateEvent();
            OS.UIElement_AddHandler(this.handle, event, handler);
            OS.GCHandle_Free(event);
            OS.GCHandle_Free(handler);
        }
    }

    public int indexOf(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (this.columns == 0) {
            return -1;
        }
        int index = OS.GridViewColumnCollection_IndexOf(this.columns, column.handle);
        return index;
    }

    public int indexOf(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        int items = OS.ItemsControl_Items(this.handle);
        int index = OS.ItemCollection_IndexOf(items, item.handle);
        OS.GCHandle_Free(items);
        return index;
    }

    void insertSelectedItem(TreeItem item, int index) {
        if (this.selectedItemCount == this.selectedItems.length) {
            TreeItem[] newItems = new TreeItem[this.selectedItemCount + 4];
            System.arraycopy(this.selectedItems, 0, newItems, 0, this.selectedItemCount);
            this.selectedItems = newItems;
        }
        System.arraycopy(this.selectedItems, index, this.selectedItems, index + 1, this.selectedItemCount - index);
        this.selectedItems[index] = item;
        ++this.selectedItemCount;
    }

    void insertSelectedItems(TreeItem from, TreeItem to) {
        int zero = OS.gcnew_Point(0.0, 0.0);
        int point = OS.UIElement_TranslatePoint(to.handle, zero, from.handle);
        boolean ascending = OS.Point_Y(point) > 0.0;
        OS.GCHandle_Free(zero);
        OS.GCHandle_Free(point);
        if (!ascending) {
            TreeItem temp = from;
            from = to;
            to = temp;
        }
        TreeItem currentItem = from;
        while (currentItem != to) {
            this.insertSelectedItem(currentItem, this.selectedItemCount);
            if (OS.TreeViewItem_IsExpanded(currentItem.handle) && OS.ItemsControl_HasItems(currentItem.handle)) {
                currentItem = currentItem.getItem(0);
                continue;
            }
            int parent = OS.FrameworkElement_Parent(currentItem.handle);
            int items = OS.ItemsControl_Items(parent);
            int index = OS.ItemCollection_IndexOf(items, currentItem.handle) + 1;
            while (index >= OS.ItemCollection_Count(items)) {
                int newParent = OS.FrameworkElement_Parent(parent);
                int newItems = OS.ItemsControl_Items(newParent);
                index = OS.ItemCollection_IndexOf(newItems, parent) + 1;
                OS.GCHandle_Free(parent);
                OS.GCHandle_Free(items);
                parent = newParent;
                items = newItems;
            }
            int itemRef = OS.ItemCollection_GetItemAt(items, index);
            currentItem = this.getItem(itemRef, false);
            OS.GCHandle_Free(itemRef);
            OS.GCHandle_Free(parent);
            OS.GCHandle_Free(items);
        }
        this.insertSelectedItem(currentItem, this.selectedItemCount);
    }

    void removeSelectedItem(TreeItem item) {
        int index = -1;
        int i = 0;
        while (i < this.selectedItemCount) {
            if (this.selectedItems[i] == item) {
                index = i;
                break;
            }
            ++i;
        }
        if (index == -1) {
            return;
        }
        System.arraycopy(this.selectedItems, index + 1, this.selectedItems, index, this.selectedItemCount - index - 1);
        this.selectedItems[this.selectedItemCount - 1] = null;
        --this.selectedItemCount;
    }

    void OnSelectedItemChanged(int args) {
        int newItemRef = OS.RoutedPropertyChangedEventArgs_NewValue(args);
        TreeItem newItem = null;
        if (newItemRef != 0) {
            newItem = this.getItem(newItemRef, false);
            OS.GCHandle_Free(newItemRef);
            newItemRef = 0;
        }
        int treeType = OS.Object_GetType(this.handle);
        int propertyName = this.createDotNetString("IsSelectionChangeActive", false);
        int property = OS.Type_GetProperty(treeType, propertyName, 36);
        OS.GCHandle_Free(treeType);
        OS.GCHandle_Free(propertyName);
        OS.PropertyInfo_SetValueBoolean(property, this.handle, true, 0);
        int mask = 6;
        int modifiers = OS.Keyboard_Modifiers();
        switch (modifiers & mask) {
            case 4: {
                this.deselectAll();
                if (this.anchor == null || this.anchor == newItem) {
                    this.insertSelectedItem(newItem, this.selectedItemCount);
                } else {
                    this.insertSelectedItems(this.anchor, newItem);
                }
                int i = 0;
                while (i < this.selectedItemCount) {
                    OS.TreeViewItem_IsSelected(this.selectedItems[i].handle, true);
                    ++i;
                }
                break;
            }
            case 2: {
                int i;
                if (newItem != null) {
                    boolean selected = false;
                    i = 0;
                    while (i < this.selectedItemCount) {
                        if (this.selectedItems[i] == newItem) {
                            selected = true;
                            break;
                        }
                        ++i;
                    }
                    if (!selected) {
                        this.insertSelectedItem(newItem, this.selectedItemCount);
                        OS.TreeViewItem_IsSelected(newItem.handle, true);
                    } else {
                        this.removeSelectedItem(newItem);
                        OS.TreeViewItem_IsSelected(newItem.handle, false);
                    }
                } else if (this.anchor != null) {
                    this.removeSelectedItem(this.anchor);
                }
                int oldItemRef = OS.RoutedPropertyChangedEventArgs_OldValue(args);
                if (oldItemRef == 0) break;
                i = 0;
                while (i < this.selectedItemCount) {
                    if (OS.Object_Equals(oldItemRef, this.selectedItems[i].handle)) {
                        OS.TreeViewItem_IsSelected(oldItemRef, true);
                        break;
                    }
                    ++i;
                }
                OS.GCHandle_Free(oldItemRef);
                break;
            }
            default: {
                int i = 0;
                while (i < this.selectedItemCount) {
                    if (newItemRef == 0 || !OS.Object_Equals(newItemRef, this.selectedItems[i].handle)) {
                        OS.TreeViewItem_IsSelected(this.selectedItems[i].handle, false);
                    }
                    ++i;
                }
                if (newItem != null) {
                    OS.TreeViewItem_IsSelected(newItem.handle, true);
                    this.selectedItems = new TreeItem[]{newItem};
                    this.selectedItemCount = 1;
                } else {
                    this.selectedItems = new TreeItem[0];
                    this.selectedItemCount = 0;
                }
                this.anchor = newItem;
            }
        }
        OS.PropertyInfo_SetValueBoolean(property, this.handle, false, 0);
        OS.GCHandle_Free(property);
    }

    int parentingHandle() {
        return this.parentingHandle;
    }

    void register() {
        super.register();
        this.display.addWidget(this.parentingHandle, this);
    }

    void releaseChildren(boolean destroy) {
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        OS.GCHandle_Free(items);
        i = 0;
        while (i < this.columnCount) {
            TreeColumn column = this._getColumn(i);
            if (column != null && !column.isDisposed()) {
                column.release(false);
            }
            ++i;
        }
        super.releaseChildren(destroy);
    }

    void releaseHandle() {
        super.releaseHandle();
        if (this.columns != 0) {
            OS.GCHandle_Free(this.columns);
        }
        this.columns = 0;
        if (this.headerTemplate != 0) {
            OS.GCHandle_Free(this.headerTemplate);
        }
        this.headerTemplate = 0;
        OS.GCHandle_Free(this.parentingHandle);
        this.parentingHandle = 0;
    }

    void releaseWidget() {
        super.releaseWidget();
        this.selectedItems = null;
    }

    public void removeAll() {
        this.checkWidget();
        int items = OS.ItemsControl_Items(this.handle);
        int i = 0;
        while (i < this.itemCount) {
            TreeItem item = this.getItem(items, i, false);
            if (item != null && !item.isDisposed()) {
                item.release(false);
            }
            ++i;
        }
        this.ignoreSelection = true;
        OS.ItemCollection_Clear(items);
        this.ignoreSelection = false;
        this.itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
    }

    public void removeSelectionListener(SelectionListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        this.eventTable.unhook(13, listener);
        this.eventTable.unhook(14, listener);
    }

    public void removeTreeListener(TreeListener listener) {
        this.checkWidget();
        if (listener == null) {
            this.error(4);
        }
        if (this.eventTable == null) {
            return;
        }
        this.eventTable.unhook(17, listener);
        this.eventTable.unhook(18, listener);
    }

    int setBounds(int x, int y, int width, int height, int flags) {
        int result = super.setBounds(x, y, width, height, flags);
        if ((result & 0x4000) != 0) {
            OS.FrameworkElement_Width(this.handle, width);
            OS.FrameworkElement_Height(this.handle, height);
        }
        return result;
    }

    public void setInsertMark(TreeItem item, boolean before) {
        this.checkWidget();
        if (item != null && item.isDisposed()) {
            this.error(5);
        }
    }

    public void setItemCount(int count) {
        this.checkWidget();
        this.setItemCount(null, count);
    }

    void setItemCount(TreeItem parentItem, int count) {
        int itemCount = parentItem != null ? parentItem.itemCount : this.itemCount;
        if ((count = Math.max(0, count)) == itemCount) {
            return;
        }
        int parentHandle = parentItem != null ? parentItem.handle : this.handle;
        int index = itemCount - 1;
        int items = OS.ItemsControl_Items(parentHandle);
        while (index >= count) {
            TreeItem item = this.getItem(items, index, false);
            if (item != null) {
                if (!item.isDisposed()) {
                    item.release(true);
                }
            } else {
                OS.ItemCollection_RemoveAt(items, index);
            }
            --index;
        }
        if (OS.ItemCollection_Count(items) > count) {
            this.error(15);
        }
        if ((this.style & 0x10000000) != 0) {
            int i = itemCount;
            while (i < count) {
                int item = OS.gcnew_TreeViewItem();
                if (item == 0) {
                    this.error(2);
                }
                if (this.columnCount != 0) {
                    int headerHandle = OS.gcnew_SWTTreeViewRowPresenter(this.handle);
                    if (headerHandle == 0) {
                        this.error(2);
                    }
                    OS.GridViewRowPresenterBase_Columns(headerHandle, this.columns);
                    OS.HeaderedItemsControl_Header(item, headerHandle);
                    int row = OS.gcnew_SWTRow(this.jniRef, item);
                    OS.GridViewRowPresenter_Content(headerHandle, row);
                    OS.GCHandle_Free(row);
                    OS.GCHandle_Free(headerHandle);
                } else {
                    int row = OS.gcnew_SWTRow(this.jniRef, item);
                    OS.HeaderedItemsControl_Header(item, row);
                    OS.TreeViewItem_HeaderTemplate(item, this.headerTemplate);
                    OS.GCHandle_Free(row);
                }
                OS.ItemCollection_Add(items, item);
                OS.GCHandle_Free(item);
                ++i;
            }
        } else {
            int i = itemCount;
            while (i < count) {
                new TreeItem(this, parentItem, 0, i, 0);
                ++i;
            }
        }
        itemCount = OS.ItemCollection_Count(items);
        OS.GCHandle_Free(items);
        if (itemCount != count) {
            this.error(14);
        }
        if (parentItem != null) {
            parentItem.itemCount = itemCount;
        } else {
            this.itemCount = itemCount;
        }
    }

    void setItemHeight(int itemHeight) {
        this.checkWidget();
        if (itemHeight < -1) {
            this.error(5);
        }
    }

    public void setLinesVisible(boolean show) {
        this.checkWidget();
    }

    public void selectAll() {
        this.checkWidget();
        if ((this.style & 4) != 0) {
            return;
        }
    }

    public void setColumnOrder(int[] order) {
        this.checkWidget();
        if (order == null) {
            this.error(4);
        }
    }

    void setForegroundBrush(int brush) {
        if (brush != 0) {
            OS.Control_Foreground(this.handle, brush);
        } else {
            int property = OS.Control_ForegroundProperty();
            OS.DependencyObject_ClearValue(this.handle, property);
            OS.GCHandle_Free(property);
        }
    }

    public void setHeaderVisible(boolean show) {
        this.checkWidget();
        this.headerVisibility = (byte)(show ? 0 : 2);
        this.updateHeaderVisibility();
    }

    public void setSelection(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        this.setSelection(new TreeItem[]{item});
    }

    public void setSelection(TreeItem[] items) {
        int length;
        this.checkWidget();
        if (items == null) {
            this.error(4);
        }
        if ((length = items.length) == 0 || (this.style & 4) != 0 && length > 1) {
            this.deselectAll();
            return;
        }
        int i = 0;
        while (i < items.length) {
            TreeItem item = items[i];
            if (item == null) {
                this.error(5);
            }
            if (item.isDisposed()) {
                this.error(24);
            }
            ++i;
        }
        if ((this.style & 4) != 0) {
            this.ignoreSelection = true;
            OS.TreeViewItem_IsSelected(items[0].handle, true);
            this.ignoreSelection = false;
            return;
        }
        int treeType = OS.Object_GetType(this.handle);
        int propertyName = this.createDotNetString("IsSelectionChangeActive", false);
        int property = OS.Type_GetProperty(treeType, propertyName, 36);
        OS.GCHandle_Free(treeType);
        OS.GCHandle_Free(propertyName);
        this.deselectAll();
        this.ignoreSelection = true;
        OS.PropertyInfo_SetValueBoolean(property, this.handle, true, 0);
        int i2 = 0;
        while (i2 < length) {
            TreeItem item = items[i2];
            this.insertSelectedItem(item, i2);
            OS.TreeViewItem_IsSelected(item.handle, true);
            ++i2;
        }
        OS.PropertyInfo_SetValueBoolean(property, this.handle, false, 0);
        this.ignoreSelection = false;
        OS.GCHandle_Free(property);
    }

    public void setSortColumn(TreeColumn column) {
        this.checkWidget();
    }

    public void setSortDirection(int direction) {
        this.checkWidget();
    }

    public void setTopItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            SWT.error(4);
        }
        if (item.isDisposed()) {
            SWT.error(5);
        }
    }

    public void showColumn(TreeColumn column) {
        this.checkWidget();
        if (column == null) {
            this.error(4);
        }
        if (column.isDisposed()) {
            this.error(5);
        }
        if (column.parent != this) {
            return;
        }
        int index = this.indexOf(column);
        if (index == -1) {
            return;
        }
    }

    public void showItem(TreeItem item) {
        this.checkWidget();
        if (item == null) {
            this.error(4);
        }
        if (item.isDisposed()) {
            this.error(5);
        }
        if (item.parent != this) {
            return;
        }
        int parent = OS.FrameworkElement_Parent(item.handle);
        while (!OS.Object_Equals(parent, this.handle)) {
            OS.TreeViewItem_IsExpanded(parent, true);
            int newParent = OS.FrameworkElement_Parent(parent);
            OS.GCHandle_Free(parent);
            parent = newParent;
        }
        OS.GCHandle_Free(parent);
        OS.FrameworkElement_BringIntoView(item.handle);
    }

    public void showSelection() {
        this.checkWidget();
        int item = OS.TreeView_SelectedItem(this.handle);
        if (item != 0) {
            OS.FrameworkElement_BringIntoView(item);
            OS.GCHandle_Free(item);
        }
    }

    int topHandle() {
        return this.parentingHandle;
    }

    void updateHeaderVisibility() {
        int scrollViewerName;
        int template = OS.Control_Template(this.handle);
        int scrollViewer = OS.FrameworkTemplate_FindName(template, scrollViewerName = this.createDotNetString(SCROLLVIEWER_PART_NAME, false), this.handle);
        if (scrollViewer != 0) {
            int headerName;
            int scrollViewerTemplate = OS.Control_Template(scrollViewer);
            int header = OS.FrameworkTemplate_FindName(scrollViewerTemplate, headerName = this.createDotNetString(HEADER_PART_NAME, false), scrollViewer);
            if (header != 0) {
                OS.UIElement_Visibility(header, this.headerVisibility);
                OS.GCHandle_Free(header);
            }
            OS.GCHandle_Free(scrollViewerTemplate);
            OS.GCHandle_Free(headerName);
            OS.GCHandle_Free(scrollViewer);
        }
        OS.GCHandle_Free(scrollViewerName);
        OS.GCHandle_Free(template);
    }
}

