/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.internal.theme;

import org.eclipse.swt.graphics.GC;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.internal.theme.RangeDrawData;
import org.eclipse.swt.internal.theme.Theme;

public class ProgressBarDrawData
extends RangeDrawData {
    public ProgressBarDrawData() {
        this.state = new int[1];
    }

    void draw(Theme theme, GC gc, Rectangle bounds) {
        int progressHandle = theme.progressHandle;
        int gtkStyle = OS.gtk_widget_get_style(progressHandle);
        int drawable = gc.getGCData().drawable;
        theme.transferClipping(gc, gtkStyle);
        byte[] detail = Converter.wcsToMbcs(null, "trough", true);
        int x = bounds.x;
        int y = bounds.y;
        int width = bounds.width;
        int height = bounds.height;
        OS.gtk_paint_box(gtkStyle, drawable, this.getStateType(0), 1, null, progressHandle, detail, x, y, width, height);
        int xthichness = OS.gtk_style_get_xthickness(gtkStyle);
        int ythichness = OS.gtk_style_get_ythickness(gtkStyle);
        if ((this.style & 0x200) != 0) {
            OS.gtk_progress_bar_set_orientation(progressHandle, 2);
            x += xthichness;
            width -= xthichness * 2;
            height -= ythichness * 2;
            height = (int)((float)height * ((float)this.selection / (float)Math.max(1, this.maximum - this.minimum)));
            y += bounds.height - ythichness - height;
        } else {
            OS.gtk_progress_bar_set_orientation(progressHandle, 0);
            x += xthichness;
            y += ythichness;
            width -= xthichness * 2;
            height -= ythichness * 2;
            width = (int)((float)width * ((float)this.selection / (float)Math.max(1, this.maximum - this.minimum)));
        }
        detail = Converter.wcsToMbcs(null, "bar", true);
        OS.gtk_paint_box(gtkStyle, drawable, 2, 2, null, progressHandle, detail, x, y, width, height);
    }

    int getStateType(int part) {
        return 0;
    }

    int hit(Theme theme, Point position, Rectangle bounds) {
        return bounds.contains(position) ? 0 : -1;
    }
}

