/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.ui.internal.part;

import java.io.PrintWriter;
import java.io.StringWriter;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.jface.dialogs.IDialogConstants;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FillLayout;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Text;

public class StatusPart {
    boolean showingDetails = false;
    private Button detailsButton;
    private Composite detailsArea;
    private Control details = null;
    private IStatus reason;

    public StatusPart(Composite parent, IStatus reason_) {
        int margins;
        this.reason = reason_;
        GridLayout layout = new GridLayout();
        layout.numColumns = 3;
        int spacing = 8;
        layout.marginBottom = margins = 8;
        layout.marginTop = margins;
        layout.marginLeft = margins;
        layout.marginRight = margins;
        layout.horizontalSpacing = spacing;
        layout.verticalSpacing = spacing;
        parent.setLayout((Layout)layout);
        Label imageLabel = new Label(parent, 0);
        Image image = this.getImage();
        if (image != null) {
            image.setBackground(imageLabel.getBackground());
            imageLabel.setImage(image);
            imageLabel.setLayoutData((Object)new GridData(66));
        }
        Text text = new Text(parent, 74);
        text.setBackground(text.getDisplay().getSystemColor(22));
        text.setLayoutData((Object)new GridData(770));
        text.setText(this.reason.getMessage());
        this.detailsButton = new Button(parent, 8);
        this.detailsButton.addSelectionListener((SelectionListener)new SelectionAdapter(){

            public void widgetSelected(SelectionEvent e) {
                StatusPart.this.showDetails(!StatusPart.this.showingDetails);
            }
        });
        this.detailsButton.setLayoutData((Object)new GridData(34));
        this.detailsButton.setVisible(this.reason.getException() != null);
        this.updateDetailsText();
        this.detailsArea = new Composite(parent, 0);
        GridData data = new GridData(1808);
        data.horizontalSpan = 3;
        data.verticalSpan = 1;
        this.detailsArea.setLayoutData((Object)data);
        this.detailsArea.setLayout((Layout)new FillLayout());
        parent.layout(true);
    }

    private Image getImage() {
        Display d = Display.getCurrent();
        switch (this.reason.getSeverity()) {
            case 4: {
                return d.getSystemImage(1);
            }
            case 2: {
                return d.getSystemImage(8);
            }
        }
        return d.getSystemImage(2);
    }

    private void showDetails(boolean shouldShow) {
        if (shouldShow == this.showingDetails) {
            return;
        }
        this.showingDetails = shouldShow;
        this.updateDetailsText();
    }

    private void updateDetailsText() {
        if (this.details != null) {
            this.details.dispose();
            this.details = null;
        }
        if (this.showingDetails) {
            this.detailsButton.setText(IDialogConstants.HIDE_DETAILS_LABEL);
            Text detailsText = new Text(this.detailsArea, 33557258);
            detailsText.setText(this.getDetails(this.reason));
            detailsText.setBackground(detailsText.getDisplay().getSystemColor(25));
            this.details = detailsText;
            this.detailsArea.layout(true);
        } else {
            this.detailsButton.setText(IDialogConstants.SHOW_DETAILS_LABEL);
        }
    }

    private String getDetails(IStatus status) {
        if (status.getException() != null) {
            return this.getStackTrace(status.getException());
        }
        return "";
    }

    private String getStackTrace(Throwable throwable) {
        StringWriter swriter = new StringWriter();
        PrintWriter pwriter = new PrintWriter(swriter);
        throwable.printStackTrace(pwriter);
        pwriter.flush();
        pwriter.close();
        return swriter.toString();
    }
}

