/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.PrintWriter;
import java.io.Reader;
import java.io.Serializable;
import java.io.Writer;
import java.math.BigInteger;
import java.net.URL;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RInterleave;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.RStack;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.UJAXP;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.URelaxer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class Child
implements Serializable,
Cloneable {
    private String name_;
    private String description_;
    private BigInteger maximum_;
    private BigInteger minimum_;
    private String optionref_;

    public Child() {
        this.name_ = "";
    }

    public Child(Child source) {
        this.setup(source);
    }

    public Child(RStack stack) {
        this.setup(stack);
    }

    public Child(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public Child(Element element) {
        this.setup(element);
    }

    public Child(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file);
    }

    public Child(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(uri);
    }

    public Child(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(url);
    }

    public Child(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(in);
    }

    public Child(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(is);
    }

    public Child(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(reader);
    }

    public void setup(Child source) {
        this.name_ = source.name_;
        this.description_ = source.description_;
        this.maximum_ = source.maximum_;
        this.minimum_ = source.minimum_;
        this.optionref_ = source.optionref_;
    }

    public void setup(Document doc) {
        this.setup(doc.getDocumentElement());
    }

    public void setup(Element element) {
        this.init(element);
    }

    public void setup(RStack stack) {
        this.init(stack.popElement());
    }

    private void init(Element element) {
        RStack stack = new RStack(element);
        this.name_ = URelaxer.getAttributePropertyAsString(element, "name");
        RInterleave interleave = new RInterleave(stack);
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("maximum", "?");
        interleave.addElementSlot("minimum", "?");
        interleave.addElementSlot("optionref", "?");
        if (interleave.isMatch()) {
            this.description_ = interleave.getElementPropertyAsString("description");
            this.maximum_ = interleave.getElementPropertyAsBigInteger("maximum");
            this.minimum_ = interleave.getElementPropertyAsBigInteger("minimum");
            this.optionref_ = interleave.getElementPropertyAsString("optionref");
        }
    }

    public Object clone() {
        return new Child(this);
    }

    public void makeElement(Node parent) {
        Document doc = parent instanceof Document ? (Document)parent : parent.getOwnerDocument();
        Element element = doc.createElement("child");
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.description_ != null) {
            URelaxer.setElementPropertyByString(element, "description", this.description_);
        }
        if (this.maximum_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "maximum", this.maximum_);
        }
        if (this.minimum_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "minimum", this.minimum_);
        }
        if (this.optionref_ != null) {
            URelaxer.setElementPropertyByString(element, "optionref", this.optionref_);
        }
        parent.appendChild(element);
    }

    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        this.setup(file.toURL());
    }

    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(uri, 0));
    }

    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(url, 0));
    }

    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(in, 0));
    }

    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(is, 0));
    }

    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        this.setup(UJAXP.getDocument(reader, 0));
    }

    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        this.makeElement(doc);
        return doc;
    }

    public String getName() {
        return this.name_;
    }

    public void setName(String name) {
        this.name_ = name;
    }

    public String getDescription() {
        return this.description_;
    }

    public void setDescription(String description) {
        this.description_ = description;
    }

    public BigInteger getMaximum() {
        return this.maximum_;
    }

    public void setMaximum(BigInteger maximum) {
        this.maximum_ = maximum;
    }

    public BigInteger getMinimum() {
        return this.minimum_;
    }

    public void setMinimum(BigInteger minimum) {
        this.minimum_ = minimum;
    }

    public String getOptionref() {
        return this.optionref_;
    }

    public void setOptionref(String optionref) {
        this.optionref_ = optionref;
    }

    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        this.makeTextElement(buffer);
        return new String(buffer);
    }

    public void makeTextElement(StringBuffer buffer) {
        buffer.append("<child");
        if (this.name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (this.description_ != null) {
            buffer.append("<description>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.append("</description>");
        }
        if (this.maximum_ != null) {
            buffer.append("<maximum>");
            buffer.append(URelaxer.getString(this.getMaximum()));
            buffer.append("</maximum>");
        }
        if (this.minimum_ != null) {
            buffer.append("<minimum>");
            buffer.append(URelaxer.getString(this.getMinimum()));
            buffer.append("</minimum>");
        }
        if (this.optionref_ != null) {
            buffer.append("<optionref>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(this.getOptionref())));
            buffer.append("</optionref>");
        }
        buffer.append("</child>");
    }

    public void makeTextElement(Writer buffer) throws IOException {
        buffer.write("<child");
        if (this.name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (this.description_ != null) {
            buffer.write("<description>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.write("</description>");
        }
        if (this.maximum_ != null) {
            buffer.write("<maximum>");
            buffer.write(URelaxer.getString(this.getMaximum()));
            buffer.write("</maximum>");
        }
        if (this.minimum_ != null) {
            buffer.write("<minimum>");
            buffer.write(URelaxer.getString(this.getMinimum()));
            buffer.write("</minimum>");
        }
        if (this.optionref_ != null) {
            buffer.write("<optionref>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(this.getOptionref())));
            buffer.write("</optionref>");
        }
        buffer.write("</child>");
    }

    public void makeTextElement(PrintWriter buffer) {
        buffer.print("<child");
        if (this.name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(this.getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (this.description_ != null) {
            buffer.print("<description>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getDescription())));
            buffer.print("</description>");
        }
        if (this.maximum_ != null) {
            buffer.print("<maximum>");
            buffer.print(URelaxer.getString(this.getMaximum()));
            buffer.print("</maximum>");
        }
        if (this.minimum_ != null) {
            buffer.print("<minimum>");
            buffer.print(URelaxer.getString(this.getMinimum()));
            buffer.print("</minimum>");
        }
        if (this.optionref_ != null) {
            buffer.print("<optionref>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(this.getOptionref())));
            buffer.print("</optionref>");
        }
        buffer.print("</child>");
    }

    public void makeTextAttribute(StringBuffer buffer) {
    }

    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    public void makeTextAttribute(PrintWriter buffer) {
    }

    public String getNameAsString() {
        return URelaxer.getString(this.getName());
    }

    public String getDescriptionAsString() {
        return URelaxer.getString(this.getDescription());
    }

    public String getMaximumAsString() {
        return URelaxer.getString(this.getMaximum());
    }

    public String getMinimumAsString() {
        return URelaxer.getString(this.getMinimum());
    }

    public String getOptionrefAsString() {
        return URelaxer.getString(this.getOptionref());
    }

    public void setNameByString(String string) {
        this.setName(string);
    }

    public void setDescriptionByString(String string) {
        this.setDescription(string);
    }

    public void setMaximumByString(String string) {
        this.setMaximum(new BigInteger(string));
    }

    public void setMinimumByString(String string) {
        this.setMinimum(new BigInteger(string));
    }

    public void setOptionrefByString(String string) {
        this.setOptionref(string);
    }

    public String toString() {
        try {
            return this.makeTextDocument();
        }
        catch (Exception e) {
            return super.toString();
        }
    }

    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "child")) {
            return false;
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return false;
        }
        $match$ = true;
        RInterleave interleave = new RInterleave(target);
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("maximum", "?");
        interleave.addElementSlot("minimum", "?");
        interleave.addElementSlot("optionref", "?");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        return target.isEmptyElement();
    }

    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        return Child.isMatch(element);
    }

    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return false;
        }
        if (Child.isMatch(element)) {
            stack.popElement();
            return true;
        }
        return false;
    }
}

