/*
 * Decompiled with CFR 0.152.
 */
package jp.sourceforge.talisman.xmlcli.builder;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import jp.sourceforge.talisman.xmlcli.builder.AbstractOptionsBuilder;
import jp.sourceforge.talisman.xmlcli.builder.CliArgument;
import jp.sourceforge.talisman.xmlcli.builder.DelayedEnumValidator;
import jp.sourceforge.talisman.xmlcli.builder.DelayedNumberValidator;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Argument;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ArgumentDefaultValues;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Argumentref;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Arguments;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Child;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Children;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLine;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineAvailableOptions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineDefinitions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineProgramArguments;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.DefaultValue;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IArgumentChoiceChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IOptionChoiceChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IOptionsChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IValidatorChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Option;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Optionref;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Options;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Properties;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.PropertiesProperty;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Validator;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ValidatorClassName;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ValidatorType;
import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.validation.ClassValidator;
import org.apache.commons.cli2.validation.DateValidator;
import org.apache.commons.cli2.validation.FileValidator;
import org.apache.commons.cli2.validation.UrlValidator;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RelaxerOptionsBuilder
extends AbstractOptionsBuilder {
    private CommandLine commandline;

    public RelaxerOptionsBuilder(InputStream in) {
        super(in);
    }

    @Override
    public Group buildOptions() throws IOException, SAXException, DOMException {
        try {
            this.commandline = new CommandLine(this.getStream());
            CommandLineDefinitions defs = this.commandline.getCommandLineDefinitions();
            Map<String, org.apache.commons.cli2.Argument> argumentMap = this.buildArgumentsMap(defs.getArguments(), null);
            Map<String, org.apache.commons.cli2.Option> optionMap = this.buildOptionMap(defs.getOptions(), argumentMap);
            CommandLineProgramArguments clpa = this.commandline.getCommandLineProgramArguments();
            Map<Object, Object> programArgsMap = clpa != null ? this.buildArgumentsMap(clpa.getArguments(), null) : new LinkedHashMap();
            return this.buildAvailableOptions(this.commandline.getName(), this.commandline.getCommandLineAvailableOptions(), optionMap, programArgsMap);
        }
        catch (ParserConfigurationException e) {
            e.printStackTrace();
            return null;
        }
    }

    private Group buildAvailableOptions(String name, CommandLineAvailableOptions options, Map<String, org.apache.commons.cli2.Option> optionMap, Map<String, org.apache.commons.cli2.Argument> programArgsMap) {
        GroupBuilder builder = new GroupBuilder();
        builder = builder.withName(name);
        String[] stringArray = options.getAvailableOption();
        int n = stringArray.length;
        int n2 = 0;
        while (n2 < n) {
            String optionName = stringArray[n2];
            org.apache.commons.cli2.Option option = optionMap.get(optionName);
            if (option == null) {
                System.out.printf("%s is not found%n", optionName);
            } else {
                builder = builder.withOption(option);
            }
            ++n2;
        }
        for (Map.Entry<String, org.apache.commons.cli2.Argument> entry : programArgsMap.entrySet()) {
            builder.withOption((org.apache.commons.cli2.Option)entry.getValue());
        }
        return builder.create();
    }

    private Map<String, org.apache.commons.cli2.Option> buildOptionMap(Options options, Map<String, org.apache.commons.cli2.Argument> arguments) {
        LinkedHashMap<String, org.apache.commons.cli2.Option> optionMap = new LinkedHashMap<String, org.apache.commons.cli2.Option>();
        IOptionsChoice[] iOptionsChoiceArray = options.getContent();
        int n = iOptionsChoiceArray.length;
        int n2 = 0;
        while (n2 < n) {
            String name;
            IOptionsChoice choice = iOptionsChoiceArray[n2];
            if (choice instanceof Optionref) {
                Optionref optionref = (Optionref)choice;
                name = optionref.getName();
                String classname = optionref.getClassName();
                try {
                    Class<org.apache.commons.cli2.Option> clazz = Class.forName(classname).asSubclass(org.apache.commons.cli2.Option.class);
                    optionMap.put(name, clazz.newInstance());
                }
                catch (Exception clazz) {}
            } else {
                Option option = (Option)choice;
                name = option.getName();
                DefaultOptionBuilder builder = new DefaultOptionBuilder();
                if (option.getDescription() != null) {
                    builder = builder.withDescription(this.deleteWhiteSpace(option.getDescription()));
                }
                if (option.getId() != null) {
                    builder = builder.withId(option.getId().intValue());
                }
                if (option.getLongName() != null) {
                    builder = builder.withLongName(option.getLongName());
                }
                if (option.getShortName() != null) {
                    String[] shortNames = option.getShortName();
                    int i = 0;
                    while (i < shortNames.length) {
                        builder = builder.withShortName(shortNames[i]);
                        ++i;
                    }
                }
                if (option.getOptionChoice() != null) {
                    org.apache.commons.cli2.Argument argument;
                    IOptionChoiceChoice argumentChoice = option.getOptionChoice().getOption();
                    if (argumentChoice instanceof Argumentref) {
                        argument = arguments.get(((Argumentref)argumentChoice).getName());
                    } else {
                        CliArgument cliarg = this.buildArgument((Argument)argumentChoice, arguments);
                        argument = cliarg.getArgument();
                    }
                    builder = builder.withArgument(argument);
                }
                if (option.getChildren() != null) {
                    Map<String, Group> groupmap = this.buildChildrenMap(option.getChildren(), optionMap);
                    for (Map.Entry<String, Group> entry : groupmap.entrySet()) {
                        builder = builder.withChildren(entry.getValue());
                    }
                }
                builder = builder.withRequired(option.getRequired());
                optionMap.put(name, (org.apache.commons.cli2.Option)builder.create());
            }
            ++n2;
        }
        return optionMap;
    }

    private Map<String, Group> buildChildrenMap(Children children, Map<String, org.apache.commons.cli2.Option> optionMap) {
        LinkedHashMap<String, Group> groupMap = new LinkedHashMap<String, Group>();
        Child[] childArray = children.getChild();
        int n = childArray.length;
        int n2 = 0;
        while (n2 < n) {
            Child child = childArray[n2];
            GroupBuilder gb = new GroupBuilder();
            String name = child.getName();
            name = child.getName();
            gb = gb.withName(name);
            if (child.getDescription() != null) {
                gb.withDescription(this.deleteWhiteSpace(child.getDescription()));
            }
            if (child.getMaximum() != null) {
                gb.withMaximum(child.getMaximum().intValue());
            }
            if (child.getMinimum() != null) {
                gb.withMinimum(child.getMinimum().intValue());
            }
            if (child.getOptionref() != null) {
                org.apache.commons.cli2.Option option = optionMap.get(child.getOptionref());
                gb.withOption(option);
            }
            groupMap.put(name, gb.create());
            ++n2;
        }
        return groupMap;
    }

    private Map<String, org.apache.commons.cli2.Argument> buildArgumentsMap(Arguments args, Map<String, org.apache.commons.cli2.Argument> orig) {
        LinkedHashMap<String, org.apache.commons.cli2.Argument> argumentMap = new LinkedHashMap<String, org.apache.commons.cli2.Argument>();
        Argument[] argumentArray = args.getArgument();
        int n = argumentArray.length;
        int n2 = 0;
        while (n2 < n) {
            Argument arg = argumentArray[n2];
            CliArgument argument = this.buildArgument(arg, argumentMap);
            argumentMap.put(argument.getName(), argument.getArgument());
            ++n2;
        }
        return argumentMap;
    }

    private CliArgument buildArgument(Argument seq, Map<String, org.apache.commons.cli2.Argument> argumentMap) {
        ArgumentBuilder builder = new ArgumentBuilder();
        String name = null;
        IArgumentChoiceChoice defaultsChoice = null;
        if (seq.getArgumentChoice() != null) {
            defaultsChoice = seq.getArgumentChoice().getArgument();
        }
        if (seq.getName() != null) {
            name = seq.getName();
            builder = builder.withName(name);
        }
        if (seq.getConsumeRemaining() != null) {
            builder = builder.withConsumeRemaining(seq.getConsumeRemaining());
        }
        if (seq.getId() != null) {
            builder = builder.withId(seq.getId().intValue());
        }
        if (seq.getDescription() != null) {
            builder = builder.withDescription(this.deleteWhiteSpace(seq.getDescription()));
        }
        if (seq.getMaximum() != null) {
            builder = builder.withMaximum(seq.getMaximum().intValue());
        }
        if (seq.getMinimum() != null) {
            builder = builder.withMinimum(seq.getMinimum().intValue());
        }
        if (seq.getInitialSeparator() != null) {
            builder = builder.withInitialSeparator(seq.getInitialSeparator().charAt(0));
        }
        if (seq.getSubsequentSeparator() != null) {
            builder = builder.withSubsequentSeparator(seq.getSubsequentSeparator().charAt(0));
        }
        if (seq.getValidator() != null) {
            builder = builder.withValidator(this.buildValidator(seq.getValidator()));
        }
        if (defaultsChoice != null && defaultsChoice instanceof DefaultValue) {
            builder = builder.withDefault((Object)((DefaultValue)defaultsChoice).getContent());
        } else if (defaultsChoice != null && defaultsChoice instanceof ArgumentDefaultValues) {
            ArrayList<String> values = new ArrayList<String>();
            String[] stringArray = ((ArgumentDefaultValues)defaultsChoice).getDefaultValue();
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String value = stringArray[n2];
                values.add(value);
                ++n2;
            }
            builder = builder.withDefaults(values);
        }
        return new CliArgument(name, builder.create());
    }

    private org.apache.commons.cli2.validation.Validator buildValidator(Validator validator) {
        IValidatorChoice choice = validator.getContent();
        org.apache.commons.cli2.validation.Validator validatorObject = null;
        if (choice instanceof ValidatorClassName) {
            validatorObject = this.findAndConstructValidator(((ValidatorClassName)choice).getContent());
        } else if (choice instanceof ValidatorType) {
            ValidatorType vtype = (ValidatorType)choice;
            String type = vtype.getContent();
            if (type.equals("class")) {
                validatorObject = new ClassValidator();
            } else if (type.equals("date")) {
                validatorObject = new DateValidator();
            } else if (type.equals("enum")) {
                validatorObject = new DelayedEnumValidator();
            } else if (type.equals("file")) {
                validatorObject = new FileValidator();
            } else if (type.equals("number")) {
                validatorObject = new DelayedNumberValidator();
            } else if (type.equals("url")) {
                validatorObject = new UrlValidator();
            }
        }
        if (validatorObject != null) {
            this.setProperties(validatorObject, validator.getProperties());
        }
        return validatorObject;
    }

    private void setProperties(org.apache.commons.cli2.validation.Validator validator, Properties props) {
        PropertiesProperty[] propertiesPropertyArray = props.getPropertiesProperty();
        int n = propertiesPropertyArray.length;
        int n2 = 0;
        while (n2 < n) {
            PropertiesProperty property = propertiesPropertyArray[n2];
            try {
                BeanUtils.setProperty((Object)validator, (String)property.getName(), (Object)property.getValue());
            }
            catch (Exception exception) {
                // empty catch block
            }
            ++n2;
        }
    }

    private org.apache.commons.cli2.validation.Validator findAndConstructValidator(String className) {
        try {
            Class<org.apache.commons.cli2.validation.Validator> c = Class.forName(className).asSubclass(org.apache.commons.cli2.validation.Validator.class);
            return c.newInstance();
        }
        catch (Exception exception) {
            return null;
        }
    }

    @Override
    public String getDefinitionName() {
        if (this.commandline != null) {
            return this.commandline.getName();
        }
        return null;
    }

    private String deleteWhiteSpace(String string) {
        BufferedReader in = new BufferedReader(new StringReader(string));
        StringBuilder result = new StringBuilder();
        boolean first = true;
        try {
            String line;
            while ((line = in.readLine()) != null) {
                if ((line = line.trim()).equals("")) continue;
                if (!first) {
                    result.append(' ');
                }
                result.append(line);
                first = false;
            }
        }
        catch (IOException e) {
            throw new InternalError(e.getMessage());
        }
        return new String(result);
    }
}

