package jp.sourceforge.talisman.xmlcli.builder;

/*
 * $Id$
 */

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

import javax.xml.parsers.ParserConfigurationException;

import jp.sourceforge.talisman.xmlcli.builder.relaxer.ArgumentDefaultValues;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Argumentref;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Arguments;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Child;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Children;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLine;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineAvailableOptions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineDefinitions;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.CommandLineProgramArguments;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.DefaultValue;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IArgumentChoiceChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IOptionChoiceChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IOptionsChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.IValidatorChoice;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Optionref;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Options;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.Properties;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.PropertiesProperty;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ValidatorClassName;
import jp.sourceforge.talisman.xmlcli.builder.relaxer.ValidatorType;

import org.apache.commons.beanutils.BeanUtils;
import org.apache.commons.cli2.Argument;
import org.apache.commons.cli2.Group;
import org.apache.commons.cli2.Option;
import org.apache.commons.cli2.builder.ArgumentBuilder;
import org.apache.commons.cli2.builder.DefaultOptionBuilder;
import org.apache.commons.cli2.builder.GroupBuilder;
import org.apache.commons.cli2.validation.ClassValidator;
import org.apache.commons.cli2.validation.DateValidator;
import org.apache.commons.cli2.validation.FileValidator;
import org.apache.commons.cli2.validation.UrlValidator;
import org.apache.commons.cli2.validation.Validator;
import org.w3c.dom.DOMException;
import org.xml.sax.SAXException;

/**
 * 
 * @author Haruaki Tamada
 * @version $Revision$ $Date$
 */
public class RelaxerOptionsBuilder extends AbstractOptionsBuilder{
	private CommandLine commandline;

	public RelaxerOptionsBuilder(InputStream in){
		super(in);
	}

	@Override
	public Group buildOptions() throws IOException, SAXException, DOMException {
		try {
			commandline = new CommandLine(getStream());
			CommandLineDefinitions defs = commandline.getCommandLineDefinitions();
			Map<String, Argument> argumentMap = buildArgumentsMap(defs.getArguments(), null);
			Map<String, Option> optionMap = buildOptionMap(defs.getOptions(), argumentMap);
			CommandLineProgramArguments clpa = commandline.getCommandLineProgramArguments();
			Map<String, Argument> programArgsMap;
			if(clpa != null){
				programArgsMap = buildArgumentsMap(clpa.getArguments(), null);
			}
			else{
				programArgsMap = new LinkedHashMap<String, Argument>();
			}

			return buildAvailableOptions(commandline.getName(), commandline.getCommandLineAvailableOptions(), optionMap, programArgsMap);
		} catch (ParserConfigurationException e) {
			e.printStackTrace();
		}

		return null;
	}

	private Group buildAvailableOptions(String name, CommandLineAvailableOptions options, Map<String, Option> optionMap, Map<String, Argument> programArgsMap){
		GroupBuilder builder = new GroupBuilder();
		builder = builder.withName(name);
		for(String optionName: options.getAvailableOption()){
			Option option = optionMap.get(optionName);
			if(option == null){
				System.out.printf("%s is not found%n", optionName);
			}
			else{
				builder = builder.withOption(option);
			}
		}
		for(Map.Entry<String, Argument> entry: programArgsMap.entrySet()){
			builder.withOption(entry.getValue());
		}
		return builder.create();
	}

	private Map<String, Option> buildOptionMap(Options options, Map<String, Argument> arguments){
		Map<String, Option> optionMap = new LinkedHashMap<String, Option>();
		for(IOptionsChoice choice: options.getContent()){
			if(choice instanceof Optionref){
				Optionref optionref = (Optionref)choice;
				String name = optionref.getName();
				String classname = optionref.getClassName();
				try{
					Class<? extends Option> clazz = Class.forName(classname).asSubclass(Option.class);
					optionMap.put(name, clazz.newInstance());
				} catch(Exception e){
				}
			}
			else{
				jp.sourceforge.talisman.xmlcli.builder.relaxer.Option option = (jp.sourceforge.talisman.xmlcli.builder.relaxer.Option)choice;
				String name = option.getName();
			DefaultOptionBuilder builder = new DefaultOptionBuilder();
			if(option.getDescription() != null){
				builder = builder.withDescription(deleteWhiteSpace(option.getDescription()));
			}
			if(option.getId() != null){
				builder = builder.withId(option.getId().intValue());
			}
			if(option.getLongName() != null){
				builder = builder.withLongName(option.getLongName());
			}
			if(option.getShortName() != null){
				String[] shortNames = option.getShortName();
				for(int i = 0; i < shortNames.length; i++){
					builder = builder.withShortName(shortNames[i]);
				}
			}
			if(option.getOptionChoice() != null){
				IOptionChoiceChoice argumentChoice = option.getOptionChoice().getOption();
				Argument argument;
				if(argumentChoice instanceof Argumentref){
					argument = arguments.get((((Argumentref)argumentChoice).getName()));
				}
				else{
					CliArgument cliarg = buildArgument((jp.sourceforge.talisman.xmlcli.builder.relaxer.Argument)argumentChoice, arguments);
					argument = cliarg.getArgument();
				}
				builder = builder.withArgument(argument);
			}
			if(option.getChildren() != null){
				Map<String, Group> groupmap = buildChildrenMap(option.getChildren(), optionMap);
				for(Map.Entry<String, Group> entry: groupmap.entrySet()){
					builder = builder.withChildren(entry.getValue());
				}
			}
			builder = builder.withRequired(option.getRequired());
			optionMap.put(name, builder.create());
			}
		}

		return optionMap;
	}

	private Map<String, Group> buildChildrenMap(Children children, Map<String, Option> optionMap){
		Map<String, Group> groupMap = new LinkedHashMap<String, Group>();
		for(Child child: children.getChild()){
			GroupBuilder gb = new GroupBuilder();
			String name = child.getName();
			name = child.getName();
			gb = gb.withName(name);

			if(child.getDescription() != null){
				gb.withDescription(deleteWhiteSpace(child.getDescription())); 
			}
			if(child.getMaximum() != null){
				gb.withMaximum(child.getMaximum().intValue());
			}
			if(child.getMinimum() != null){
				gb.withMinimum(child.getMinimum().intValue());
			}
			if(child.getOptionref() != null){
				Option option = optionMap.get(child.getOptionref());
				gb.withOption(option);
			}
			groupMap.put(name, gb.create());
		}

		return groupMap;
	}

	private Map<String, Argument> buildArgumentsMap(Arguments args, Map<String, Argument> orig){
		Map<String, Argument> argumentMap = new LinkedHashMap<String, Argument>();

		if(args != null){
			for(jp.sourceforge.talisman.xmlcli.builder.relaxer.Argument arg: args.getArgument()){
				CliArgument argument = buildArgument(arg, argumentMap);
				argumentMap.put(argument.getName(), argument.getArgument());
			}
		}

		return argumentMap;
	}

	private CliArgument buildArgument(jp.sourceforge.talisman.xmlcli.builder.relaxer.Argument seq, Map<String, Argument> argumentMap){
		ArgumentBuilder builder = new ArgumentBuilder();
		String name = null;
		IArgumentChoiceChoice defaultsChoice = null;
		if(seq.getArgumentChoice() != null){
			defaultsChoice = seq.getArgumentChoice().getArgument();
		}
		if(seq.getName() != null){
			name = seq.getName();
			builder = builder.withName(name);
		}
		if(seq.getConsumeRemaining() != null){
			builder = builder.withConsumeRemaining(seq.getConsumeRemaining());
		}
		if(seq.getId() != null){
			builder = builder.withId(seq.getId().intValue());
		}
		if(seq.getDescription() != null){
			builder = builder.withDescription(deleteWhiteSpace(seq.getDescription()));
		}
		if(seq.getMaximum() != null){
			builder = builder.withMaximum(seq.getMaximum().intValue());
		}
		if(seq.getMinimum() != null){
			builder = builder.withMinimum(seq.getMinimum().intValue());
		}
		if(seq.getInitialSeparator() != null){
			builder = builder.withInitialSeparator(seq.getInitialSeparator().charAt(0));
		}
		if(seq.getSubsequentSeparator() != null){
			builder = builder.withSubsequentSeparator(seq.getSubsequentSeparator().charAt(0));
		}
		if(seq.getValidator() != null){
			builder = builder.withValidator(buildValidator(seq.getValidator()));
		}
		if(defaultsChoice != null && defaultsChoice instanceof DefaultValue){
			builder = builder.withDefault(((DefaultValue)defaultsChoice).getContent());
		}
		else if(defaultsChoice != null && defaultsChoice instanceof ArgumentDefaultValues){
			List<String> values = new ArrayList<String>();
			for(String value: ((ArgumentDefaultValues)defaultsChoice).getDefaultValue()){
				values.add(value);
			}
			builder = builder.withDefaults(values);
		}
		return new CliArgument(name, builder.create());
	}

	private Validator buildValidator(jp.sourceforge.talisman.xmlcli.builder.relaxer.Validator validator){
		IValidatorChoice choice = validator.getContent();
		Validator validatorObject = null;
		if(choice instanceof ValidatorClassName){
			validatorObject = findAndConstructValidator(((ValidatorClassName)choice).getContent());
		}
		else if(choice instanceof ValidatorType){
			ValidatorType vtype = (ValidatorType)choice;
			String type = vtype.getContent();
			if(type.equals(ValidatorType.CONTENT_CLASS)){
				validatorObject = new ClassValidator();
			}
			else if(type.equals(ValidatorType.CONTENT_DATE)){
				validatorObject = new DateValidator();
			}
			else if(type.equals(ValidatorType.CONTENT_ENUM)){
				validatorObject = new DelayedEnumValidator();
			}
			else if(type.equals(ValidatorType.CONTENT_FILE)){
				validatorObject = new FileValidator();
			}
			else if(type.equals(ValidatorType.CONTENT_NUMBER)){
				validatorObject = new DelayedNumberValidator();
			}
			else if(type.equals(ValidatorType.CONTENT_URL)){
				validatorObject = new UrlValidator();
			}
		}
		if(validatorObject != null){
			setProperties(validatorObject, validator.getProperties());
		}
		return validatorObject;
	}

	private void setProperties(Validator validator, Properties props){
		for(PropertiesProperty property: props.getPropertiesProperty()){
			try{
				BeanUtils.setProperty(validator, property.getName(), property.getValue());
			} catch(Exception e){
			}
		}
	}

	private Validator findAndConstructValidator(String className){
		try{
			Class<? extends Validator> c = Class.forName(className).asSubclass(Validator.class);
			return c.newInstance();
		} catch(Exception e){
		}
		return null;
	}

	@Override
	public String getDefinitionName() {
		if(commandline != null){
			return commandline.getName();
		}
		return null;
	}

	private String deleteWhiteSpace(String string){
		BufferedReader in = new BufferedReader(new StringReader(string));
		String line;
		StringBuilder result = new StringBuilder();
		boolean first = true;

		try {
			while((line = in.readLine()) != null){
				line = line.trim();
				if(!line.equals("")){
					if(!first){
						result.append(' ');
					}
					result.append(line);
					first = false;
				}
			}
		} catch (IOException e) {
			throw new InternalError(e.getMessage());
		}
		return new String(result);
	}
}
