/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import org.w3c.dom.*;

/**
 * <b>ArgumentChoice</b> is generated from xmlcli-2_0.rng by Relaxer.
 *
 * @version xmlcli-2_0.rng (Thu Aug 16 18:37:44 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "serial", "unused" })
public class ArgumentChoice implements java.io.Serializable, Cloneable {
    private IArgumentChoiceChoice argument_;

    /**
     * Creates a <code>ArgumentChoice</code>.
     *
     */
    public ArgumentChoice() {
    }

    /**
     * Creates a <code>ArgumentChoice</code>.
     *
     * @param source
     */
    public ArgumentChoice(ArgumentChoice source) {
        setup(source);
    }

    /**
     * Creates a <code>ArgumentChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public ArgumentChoice(RStack stack) {
        setup(stack);
    }

    /**
     * Initializes the <code>ArgumentChoice</code> by the ArgumentChoice <code>source</code>.
     *
     * @param source
     */
    public void setup(ArgumentChoice source) {
        int size;
        if (source.argument_ != null) {
            setArgument((IArgumentChoiceChoice)source.getArgument().clone());
        }
    }

    /**
     * Initializes the <code>ArgumentChoice</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        Element element = stack.getContextElement();
        if (ArgumentDefaultValues.isMatch(stack)) {
            setArgument(new ArgumentDefaultValues(stack));
        } else if (DefaultValue.isMatch(stack)) {
            setArgument(new DefaultValue(stack));
        } else {
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new ArgumentChoice((ArgumentChoice)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc = parent.getOwnerDocument();
        Element element = (Element)parent;
        int size;
        if (this.argument_ != null) {
            this.argument_.makeElement(element);
        }
    }

    /**
     * Gets the IArgumentChoiceChoice property <b>argument</b>.
     *
     * @return IArgumentChoiceChoice
     */
    public IArgumentChoiceChoice getArgument() {
        return (argument_);
    }

    /**
     * Sets the IArgumentChoiceChoice property <b>argument</b>.
     *
     * @param argument
     */
    public void setArgument(IArgumentChoiceChoice argument) {
        this.argument_ = argument;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        if (argument_ != null) {
            argument_.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        if (argument_ != null) {
            argument_.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        if (argument_ != null) {
            argument_.makeTextElement(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
        int size;
        if (argument_ != null) {
            argument_.makeTextAttribute(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
        int size;
        if (argument_ != null) {
            argument_.makeTextAttribute(buffer);
        }
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
        int size;
        if (argument_ != null) {
            argument_.makeTextAttribute(buffer);
        }
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ArgumentChoice</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        return (isMatchHungry(stack.makeClone()));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ArgumentChoice</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        RStack target = stack.makeClone();
        boolean $match$ = false;
        Element element = target.peekElement();
        Element child;
        if (ArgumentDefaultValues.isMatchHungry(target)) {
            $match$ = true;
        } else if (DefaultValue.isMatchHungry(target)) {
            $match$ = true;
        } else {
        }
        if ($match$) {
            stack.eat(target);
        }
        return ($match$);
    }
}
