/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>ArgumentDefaultValues</b> is generated from xmlcli-2_0.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="default-values">
 *               <oneOrMore>
 *                 <ref name="default-value"/>
 *               </oneOrMore>
 *             </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="default-values"&gt;
 *               &lt;oneOrMore&gt;
 *                 &lt;ref name="default-value"/&gt;
 *               &lt;/oneOrMore&gt;
 *             &lt;/element&gt;</pre>
 *
 * @version xmlcli-2_0.rng (Thu Aug 16 18:37:44 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "serial", "unused" })
public class ArgumentDefaultValues implements java.io.Serializable, Cloneable, IArgumentChoiceChoice {
    // List<String>
    private java.util.List defaultValue_ = new java.util.ArrayList();

    /**
     * Creates a <code>ArgumentDefaultValues</code>.
     *
     */
    public ArgumentDefaultValues() {
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code>.
     *
     * @param source
     */
    public ArgumentDefaultValues(ArgumentDefaultValues source) {
        setup(source);
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public ArgumentDefaultValues(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public ArgumentDefaultValues(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public ArgumentDefaultValues(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ArgumentDefaultValues(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ArgumentDefaultValues(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ArgumentDefaultValues(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ArgumentDefaultValues(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ArgumentDefaultValues(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>ArgumentDefaultValues</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public ArgumentDefaultValues(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the ArgumentDefaultValues <code>source</code>.
     *
     * @param source
     */
    public void setup(ArgumentDefaultValues source) {
        int size;
        setDefaultValue(source.getDefaultValue());
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        defaultValue_ = URelaxer.getElementPropertyAsStringListByStack(stack, "default-value");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new ArgumentDefaultValues((ArgumentDefaultValues)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("default-values");
        int size;
        URelaxer.setElementPropertyByStringList(element, "default-value", this.defaultValue_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>ArgumentDefaultValues</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>defaultValue</b>.
     *
     * @return String[]
     */
    public String[] getDefaultValue() {
        String[] array = new String[defaultValue_.size()];
        return ((String[])defaultValue_.toArray(array));
    }

    /**
     * Sets the String property <b>defaultValue</b>.
     *
     * @param defaultValue
     */
    public void setDefaultValue(String[] defaultValue) {
        this.defaultValue_.clear();
        for (int i = 0;i < defaultValue.length;i++) {
            addDefaultValue(defaultValue[i]);
        }
    }

    /**
     * Sets the String property <b>defaultValue</b>.
     *
     * @param defaultValue
     */
    public void setDefaultValue(String defaultValue) {
        this.defaultValue_.clear();
        addDefaultValue(defaultValue);
    }

    /**
     * Adds the String property <b>defaultValue</b>.
     *
     * @param defaultValue
     */
    public void addDefaultValue(String defaultValue) {
        this.defaultValue_.add(defaultValue);
    }

    /**
     * Adds the String property <b>defaultValue</b>.
     *
     * @param defaultValue
     */
    public void addDefaultValue(String[] defaultValue) {
        for (int i = 0;i < defaultValue.length;i++) {
            addDefaultValue(defaultValue[i]);
        }
    }

    /**
     * Gets number of the String property <b>defaultValue</b>.
     *
     * @return int
     */
    public int sizeDefaultValue() {
        return (defaultValue_.size());
    }

    /**
     * Gets the String property <b>defaultValue</b> by index.
     *
     * @param index
     * @return String
     */
    public String getDefaultValue(int index) {
        return ((String)defaultValue_.get(index));
    }

    /**
     * Sets the String property <b>defaultValue</b> by index.
     *
     * @param index
     * @param defaultValue
     */
    public void setDefaultValue(int index, String defaultValue) {
        this.defaultValue_.set(index, defaultValue);
    }

    /**
     * Adds the String property <b>defaultValue</b> by index.
     *
     * @param index
     * @param defaultValue
     */
    public void addDefaultValue(int index, String defaultValue) {
        this.defaultValue_.add(index, defaultValue);
    }

    /**
     * Remove the String property <b>defaultValue</b> by index.
     *
     * @param index
     */
    public void removeDefaultValue(int index) {
        this.defaultValue_.remove(index);
    }

    /**
     * Remove the String property <b>defaultValue</b> by object.
     *
     * @param defaultValue
     */
    public void removeDefaultValue(String defaultValue) {
        this.defaultValue_.remove(defaultValue);
    }

    /**
     * Clear the String property <b>defaultValue</b>.
     *
     */
    public void clearDefaultValue() {
        this.defaultValue_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<default-values");
        buffer.append(">");
        size = sizeDefaultValue();
        for (int i = 0;i < size;i++) {
            buffer.append("<default-value>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getDefaultValue(i))));
            buffer.append("</default-value>");
        }
        buffer.append("</default-values>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<default-values");
        buffer.write(">");
        size = sizeDefaultValue();
        for (int i = 0;i < size;i++) {
            buffer.write("<default-value>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getDefaultValue(i))));
            buffer.write("</default-value>");
        }
        buffer.write("</default-values>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<default-values");
        buffer.print(">");
        size = sizeDefaultValue();
        for (int i = 0;i < size;i++) {
            buffer.print("<default-value>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getDefaultValue(i))));
            buffer.print("</default-value>");
        }
        buffer.print("</default-values>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String array.
     *
     * @return String[]
     */
    public String[] getDefaultValueAsString() {
        int size = sizeDefaultValue();
        String[] array = new String[size];
        for (int i = 0;i < size;i++) {
            array[i] = URelaxer.getString(getDefaultValue(i));
        }
        return (array);
    }

    /**
     * Gets the property value by index as String.
     *
     * @param index
     * @return String
     */
    public String getDefaultValueAsString(int index) {
        return (URelaxer.getString(getDefaultValue(index)));
    }

    /**
     * Sets the property value by String array.
     *
     * @param strings
     */
    public void setDefaultValueByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            setDefaultValue(string);
            for (int i = 1;i < strings.length;i++) {
                string = strings[i];
                addDefaultValue(string);
            }
        }
    }

    /**
     * Sets the property value by String via index.
     *
     * @param index
     * @param value
     */
    public void setDefaultValueByString(int index, String value) {
        setDefaultValue(index, value);
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     */
    public void addDefaultValueByString(String string) {
        addDefaultValue(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>ArgumentDefaultValues</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "default-values")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        child = target.popElement();
        if (child == null) {
            return (false);
        }
        if (!URelaxer.isTargetElement(child, "default-value")) {
            return (false);
        }
        $match$ = true;
        while ((child = target.peekElement()) != null) {
            if (!URelaxer.isTargetElement(child, "default-value")) {
                break;
            }
            target.popElement();
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ArgumentDefaultValues</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>ArgumentDefaultValues</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
