/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Child</b> is generated from xmlcli-2_0.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="child">
 *       <attribute name="name">
 *         <data type="string"/>
 *       </attribute>
 *       <interleave>
 *         <optional>
 *           <element name="description">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="maximum">
 *             <data type="integer"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="minimum">
 *             <data type="integer"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="optionref">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *       </interleave>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="child"&gt;
 *       &lt;attribute name="name"&gt;
 *         &lt;data type="string"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;interleave&gt;
 *         &lt;optional&gt;
 *           &lt;element name="description"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="maximum"&gt;
 *             &lt;data type="integer"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="minimum"&gt;
 *             &lt;data type="integer"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="optionref"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *       &lt;/interleave&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version xmlcli-2_0.rng (Thu Aug 16 18:37:44 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "serial", "unused" })
public class Child implements java.io.Serializable, Cloneable {
    private String name_;
    private String description_;
    private java.math.BigInteger maximum_;
    private java.math.BigInteger minimum_;
    private String optionref_;

    /**
     * Creates a <code>Child</code>.
     *
     */
    public Child() {
        name_ = "";
    }

    /**
     * Creates a <code>Child</code>.
     *
     * @param source
     */
    public Child(Child source) {
        setup(source);
    }

    /**
     * Creates a <code>Child</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Child(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Child</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Child(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Child</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Child(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Child</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Child(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Child</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Child(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Child</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Child(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Child</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Child(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Child</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Child(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Child</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Child(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Child</code> by the Child <code>source</code>.
     *
     * @param source
     */
    public void setup(Child source) {
        int size;
        name_ = source.name_;
        description_ = source.description_;
        maximum_ = source.maximum_;
        minimum_ = source.minimum_;
        optionref_ = source.optionref_;
    }

    /**
     * Initializes the <code>Child</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Child</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Child</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        RInterleave interleave;
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        interleave = new RInterleave(stack);
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("maximum", "?");
        interleave.addElementSlot("minimum", "?");
        interleave.addElementSlot("optionref", "?");
        if (interleave.isMatch()) {
            description_ = interleave.getElementPropertyAsString("description");
            maximum_ = interleave.getElementPropertyAsBigInteger("maximum");
            minimum_ = interleave.getElementPropertyAsBigInteger("minimum");
            optionref_ = interleave.getElementPropertyAsString("optionref");
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new Child((Child)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("child");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        if (this.description_ != null) {
            URelaxer.setElementPropertyByString(element, "description", this.description_);
        }
        if (this.maximum_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "maximum", this.maximum_);
        }
        if (this.minimum_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "minimum", this.minimum_);
        }
        if (this.optionref_ != null) {
            URelaxer.setElementPropertyByString(element, "optionref", this.optionref_);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Child</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Child</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Child</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Child</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Child</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Child</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>description</b>.
     *
     * @return String
     */
    public String getDescription() {
        return (description_);
    }

    /**
     * Sets the String property <b>description</b>.
     *
     * @param description
     */
    public void setDescription(String description) {
        this.description_ = description;
    }

    /**
     * Gets the java.math.BigInteger property <b>maximum</b>.
     *
     * @return java.math.BigInteger
     */
    public java.math.BigInteger getMaximum() {
        return (maximum_);
    }

    /**
     * Sets the java.math.BigInteger property <b>maximum</b>.
     *
     * @param maximum
     */
    public void setMaximum(java.math.BigInteger maximum) {
        this.maximum_ = maximum;
    }

    /**
     * Gets the java.math.BigInteger property <b>minimum</b>.
     *
     * @return java.math.BigInteger
     */
    public java.math.BigInteger getMinimum() {
        return (minimum_);
    }

    /**
     * Sets the java.math.BigInteger property <b>minimum</b>.
     *
     * @param minimum
     */
    public void setMinimum(java.math.BigInteger minimum) {
        this.minimum_ = minimum;
    }

    /**
     * Gets the String property <b>optionref</b>.
     *
     * @return String
     */
    public String getOptionref() {
        return (optionref_);
    }

    /**
     * Sets the String property <b>optionref</b>.
     *
     * @param optionref
     */
    public void setOptionref(String optionref) {
        this.optionref_ = optionref;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<child");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        if (description_ != null) {
            buffer.append("<description>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.append("</description>");
        }
        if (maximum_ != null) {
            buffer.append("<maximum>");
            buffer.append(URelaxer.getString(getMaximum()));
            buffer.append("</maximum>");
        }
        if (minimum_ != null) {
            buffer.append("<minimum>");
            buffer.append(URelaxer.getString(getMinimum()));
            buffer.append("</minimum>");
        }
        if (optionref_ != null) {
            buffer.append("<optionref>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getOptionref())));
            buffer.append("</optionref>");
        }
        buffer.append("</child>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<child");
        if (name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        if (description_ != null) {
            buffer.write("<description>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.write("</description>");
        }
        if (maximum_ != null) {
            buffer.write("<maximum>");
            buffer.write(URelaxer.getString(getMaximum()));
            buffer.write("</maximum>");
        }
        if (minimum_ != null) {
            buffer.write("<minimum>");
            buffer.write(URelaxer.getString(getMinimum()));
            buffer.write("</minimum>");
        }
        if (optionref_ != null) {
            buffer.write("<optionref>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getOptionref())));
            buffer.write("</optionref>");
        }
        buffer.write("</child>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<child");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        if (description_ != null) {
            buffer.print("<description>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.print("</description>");
        }
        if (maximum_ != null) {
            buffer.print("<maximum>");
            buffer.print(URelaxer.getString(getMaximum()));
            buffer.print("</maximum>");
        }
        if (minimum_ != null) {
            buffer.print("<minimum>");
            buffer.print(URelaxer.getString(getMinimum()));
            buffer.print("</minimum>");
        }
        if (optionref_ != null) {
            buffer.print("<optionref>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getOptionref())));
            buffer.print("</optionref>");
        }
        buffer.print("</child>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDescriptionAsString() {
        return (URelaxer.getString(getDescription()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMaximumAsString() {
        return (URelaxer.getString(getMaximum()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getMinimumAsString() {
        return (URelaxer.getString(getMinimum()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getOptionrefAsString() {
        return (URelaxer.getString(getOptionref()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDescriptionByString(String string) {
        setDescription(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMaximumByString(String string) {
        setMaximum(new java.math.BigInteger(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setMinimumByString(String string) {
        setMinimum(new java.math.BigInteger(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setOptionrefByString(String string) {
        setOptionref(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Child</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "child")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        RInterleave interleave;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return (false);
        }
        $match$ = true;
        interleave = new RInterleave(target);
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("maximum", "?");
        interleave.addElementSlot("minimum", "?");
        interleave.addElementSlot("optionref", "?");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Child</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Child</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
