/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>CommandLineAvailableOptions</b> is generated from xmlcli-2_0.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="available-options">
 *         <zeroOrMore>
 *           <ref name="available-option"/>
 *         </zeroOrMore>
 *       </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="available-options"&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;ref name="available-option"/&gt;
 *         &lt;/zeroOrMore&gt;
 *       &lt;/element&gt;</pre>
 *
 * @version xmlcli-2_0.rng (Thu Aug 16 18:37:44 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "serial", "unused" })
public class CommandLineAvailableOptions implements java.io.Serializable, Cloneable {
    // List<String>
    private java.util.List availableOption_ = new java.util.ArrayList();

    /**
     * Creates a <code>CommandLineAvailableOptions</code>.
     *
     */
    public CommandLineAvailableOptions() {
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code>.
     *
     * @param source
     */
    public CommandLineAvailableOptions(CommandLineAvailableOptions source) {
        setup(source);
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public CommandLineAvailableOptions(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public CommandLineAvailableOptions(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public CommandLineAvailableOptions(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineAvailableOptions(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineAvailableOptions(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineAvailableOptions(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineAvailableOptions(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineAvailableOptions(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>CommandLineAvailableOptions</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public CommandLineAvailableOptions(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the CommandLineAvailableOptions <code>source</code>.
     *
     * @param source
     */
    public void setup(CommandLineAvailableOptions source) {
        int size;
        setAvailableOption(source.getAvailableOption());
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        availableOption_ = URelaxer.getElementPropertyAsStringListByStack(stack, "available-option");
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new CommandLineAvailableOptions((CommandLineAvailableOptions)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("available-options");
        int size;
        URelaxer.setElementPropertyByStringList(element, "available-option", this.availableOption_);
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>CommandLineAvailableOptions</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>availableOption</b>.
     *
     * @return String[]
     */
    public String[] getAvailableOption() {
        String[] array = new String[availableOption_.size()];
        return ((String[])availableOption_.toArray(array));
    }

    /**
     * Sets the String property <b>availableOption</b>.
     *
     * @param availableOption
     */
    public void setAvailableOption(String[] availableOption) {
        this.availableOption_.clear();
        for (int i = 0;i < availableOption.length;i++) {
            addAvailableOption(availableOption[i]);
        }
    }

    /**
     * Sets the String property <b>availableOption</b>.
     *
     * @param availableOption
     */
    public void setAvailableOption(String availableOption) {
        this.availableOption_.clear();
        addAvailableOption(availableOption);
    }

    /**
     * Adds the String property <b>availableOption</b>.
     *
     * @param availableOption
     */
    public void addAvailableOption(String availableOption) {
        this.availableOption_.add(availableOption);
    }

    /**
     * Adds the String property <b>availableOption</b>.
     *
     * @param availableOption
     */
    public void addAvailableOption(String[] availableOption) {
        for (int i = 0;i < availableOption.length;i++) {
            addAvailableOption(availableOption[i]);
        }
    }

    /**
     * Gets number of the String property <b>availableOption</b>.
     *
     * @return int
     */
    public int sizeAvailableOption() {
        return (availableOption_.size());
    }

    /**
     * Gets the String property <b>availableOption</b> by index.
     *
     * @param index
     * @return String
     */
    public String getAvailableOption(int index) {
        return ((String)availableOption_.get(index));
    }

    /**
     * Sets the String property <b>availableOption</b> by index.
     *
     * @param index
     * @param availableOption
     */
    public void setAvailableOption(int index, String availableOption) {
        this.availableOption_.set(index, availableOption);
    }

    /**
     * Adds the String property <b>availableOption</b> by index.
     *
     * @param index
     * @param availableOption
     */
    public void addAvailableOption(int index, String availableOption) {
        this.availableOption_.add(index, availableOption);
    }

    /**
     * Remove the String property <b>availableOption</b> by index.
     *
     * @param index
     */
    public void removeAvailableOption(int index) {
        this.availableOption_.remove(index);
    }

    /**
     * Remove the String property <b>availableOption</b> by object.
     *
     * @param availableOption
     */
    public void removeAvailableOption(String availableOption) {
        this.availableOption_.remove(availableOption);
    }

    /**
     * Clear the String property <b>availableOption</b>.
     *
     */
    public void clearAvailableOption() {
        this.availableOption_.clear();
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<available-options");
        buffer.append(">");
        size = sizeAvailableOption();
        for (int i = 0;i < size;i++) {
            buffer.append("<available-option>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getAvailableOption(i))));
            buffer.append("</available-option>");
        }
        buffer.append("</available-options>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<available-options");
        buffer.write(">");
        size = sizeAvailableOption();
        for (int i = 0;i < size;i++) {
            buffer.write("<available-option>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getAvailableOption(i))));
            buffer.write("</available-option>");
        }
        buffer.write("</available-options>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<available-options");
        buffer.print(">");
        size = sizeAvailableOption();
        for (int i = 0;i < size;i++) {
            buffer.print("<available-option>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getAvailableOption(i))));
            buffer.print("</available-option>");
        }
        buffer.print("</available-options>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String array.
     *
     * @return String[]
     */
    public String[] getAvailableOptionAsString() {
        int size = sizeAvailableOption();
        String[] array = new String[size];
        for (int i = 0;i < size;i++) {
            array[i] = URelaxer.getString(getAvailableOption(i));
        }
        return (array);
    }

    /**
     * Gets the property value by index as String.
     *
     * @param index
     * @return String
     */
    public String getAvailableOptionAsString(int index) {
        return (URelaxer.getString(getAvailableOption(index)));
    }

    /**
     * Sets the property value by String array.
     *
     * @param strings
     */
    public void setAvailableOptionByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            setAvailableOption(string);
            for (int i = 1;i < strings.length;i++) {
                string = strings[i];
                addAvailableOption(string);
            }
        }
    }

    /**
     * Sets the property value by String via index.
     *
     * @param index
     * @param value
     */
    public void setAvailableOptionByString(int index, String value) {
        setAvailableOption(index, value);
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     */
    public void addAvailableOptionByString(String string) {
        addAvailableOption(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>CommandLineAvailableOptions</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "available-options")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        while ((child = target.peekElement()) != null) {
            if (!URelaxer.isTargetElement(child, "available-option")) {
                break;
            }
            target.popElement();
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CommandLineAvailableOptions</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>CommandLineAvailableOptions</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
