/*
 * The Relaxer artifact
 * Copyright (c) 2000-2004, ASAMI Tomoharu, All rights reserved.
 *
 * Permission is hereby granted, free of charge, to any person obtaining
 * a copy of this software and associated documentation files (the
 * "Software"), to deal in the Software without restriction, including
 * without limitation the rights to use, copy, modify, merge, publish,
 * distribute, sublicense, and/or sell copies of the Software, and to
 * permit persons to whom the Software is furnished to do so, subject to
 * the following conditions:
 *
 * - Redistributions of source code must retain the above copyright
 *   notice, this list of conditions and the following disclaimer. 
 *
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND
 * NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE
 * LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION
 * OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION
 * WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */
package jp.sourceforge.talisman.xmlcli.builder.relaxer;

import java.io.*;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.net.URL;
import javax.xml.parsers.*;
import org.w3c.dom.*;
import org.xml.sax.*;

/**
 * <b>Option</b> is generated from xmlcli-2_0.rng by Relaxer.
 * This class is derived from:
 * 
 * <!-- for programmer
 * <element name="option">
 *       <attribute name="name">
 *         <data type="string"/>
 *       </attribute>
 *       <interleave>
 *         <zeroOrMore>
 *           <element name="short-name">
 *             <data type="string"/>
 *           </element>
 *         </zeroOrMore>
 *         <optional>
 *           <element name="long-name">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="id">
 *             <data type="integer"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="description">
 *             <data type="string"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <element name="required">
 *             <data type="boolean"/>
 *           </element>
 *         </optional>
 *         <optional>
 *           <choice>
 *             <ref name="argumentref"/>
 *             <ref name="argument"/>
 *           </choice>
 *         </optional>
 *         <optional>
 *           <ref name="children"/>
 *         </optional>
 *       </interleave>
 *     </element>-->
 * <!-- for javadoc -->
 * <pre> &lt;element name="option"&gt;
 *       &lt;attribute name="name"&gt;
 *         &lt;data type="string"/&gt;
 *       &lt;/attribute&gt;
 *       &lt;interleave&gt;
 *         &lt;zeroOrMore&gt;
 *           &lt;element name="short-name"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/zeroOrMore&gt;
 *         &lt;optional&gt;
 *           &lt;element name="long-name"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="id"&gt;
 *             &lt;data type="integer"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="description"&gt;
 *             &lt;data type="string"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;element name="required"&gt;
 *             &lt;data type="boolean"/&gt;
 *           &lt;/element&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;choice&gt;
 *             &lt;ref name="argumentref"/&gt;
 *             &lt;ref name="argument"/&gt;
 *           &lt;/choice&gt;
 *         &lt;/optional&gt;
 *         &lt;optional&gt;
 *           &lt;ref name="children"/&gt;
 *         &lt;/optional&gt;
 *       &lt;/interleave&gt;
 *     &lt;/element&gt;</pre>
 *
 * @version xmlcli-2_0.rng (Thu Aug 16 18:37:44 JST 2007)
 * @author  Relaxer 1.1b (http://www.relaxer.org)
 */
@SuppressWarnings({ "unchecked", "serial", "unused" })
public class Option implements java.io.Serializable, Cloneable, IOptionsChoice {
    private String name_;
    // List<String>
    private java.util.List shortName_ = new java.util.ArrayList();
    private String longName_;
    private java.math.BigInteger id_;
    private String description_;
    private Boolean required_;
    private OptionChoice optionChoice_;
    private Children children_;

    /**
     * Creates a <code>Option</code>.
     *
     */
    public Option() {
        name_ = "";
    }

    /**
     * Creates a <code>Option</code>.
     *
     * @param source
     */
    public Option(Option source) {
        setup(source);
    }

    /**
     * Creates a <code>Option</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public Option(RStack stack) {
        setup(stack);
    }

    /**
     * Creates a <code>Option</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public Option(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Creates a <code>Option</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public Option(Element element) {
        setup(element);
    }

    /**
     * Creates a <code>Option</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file);
    }

    /**
     * Creates a <code>Option</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(uri);
    }

    /**
     * Creates a <code>Option</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(url);
    }

    /**
     * Creates a <code>Option</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(in);
    }

    /**
     * Creates a <code>Option</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(is);
    }

    /**
     * Creates a <code>Option</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public Option(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(reader);
    }

    /**
     * Initializes the <code>Option</code> by the Option <code>source</code>.
     *
     * @param source
     */
    public void setup(Option source) {
        int size;
        name_ = source.name_;
        setShortName(source.getShortName());
        longName_ = source.longName_;
        id_ = source.id_;
        description_ = source.description_;
        required_ = source.required_;
        if (source.optionChoice_ != null) {
            setOptionChoice((OptionChoice)source.getOptionChoice().clone());
        }
        if (source.children_ != null) {
            setChildren((Children)source.getChildren().clone());
        }
    }

    /**
     * Initializes the <code>Option</code> by the Document <code>doc</code>.
     *
     * @param doc
     */
    public void setup(Document doc) {
        setup(doc.getDocumentElement());
    }

    /**
     * Initializes the <code>Option</code> by the Element <code>element</code>.
     *
     * @param element
     */
    public void setup(Element element) {
        init(element);
    }

    /**
     * Initializes the <code>Option</code> by the Stack <code>stack</code>
     * that contains Elements.
     * This constructor is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     */
    public void setup(RStack stack) {
        init(stack.popElement());
    }

    /**
     * @param element
     */
    private void init(Element element) {
        RStack stack = new RStack(element);
        RInterleave interleave;
        name_ = URelaxer.getAttributePropertyAsString(element, "name");
        interleave = new RInterleave(stack);
        interleave.addElementSlot("short-name", "*");
        interleave.addElementSlot("long-name", "?");
        interleave.addElementSlot("id", "?");
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("required", "?");
        interleave.addHedgeSlot(OptionChoice.class, "?");
        interleave.addElementSlot(Children.class, "?");
        if (interleave.isMatch()) {
            shortName_ = interleave.getElementPropertyAsStringList("short-name");
            longName_ = interleave.getElementPropertyAsString("long-name");
            id_ = interleave.getElementPropertyAsBigInteger("id");
            description_ = interleave.getElementPropertyAsString("description");
            required_ = interleave.getElementPropertyAsBooleanObject("required");
            setOptionChoice((OptionChoice)interleave.getProperty(OptionChoice.class));
            setChildren((Children)interleave.getProperty(Children.class));
        }
    }

    /**
     * @return Object
     */
    public Object clone() {
        return (new Option((Option)this));
    }

    /**
     * Creates a DOM representation of the object.
     * Result is appended to the Node <code>parent</code>.
     *
     * @param parent
     */
    public void makeElement(Node parent) {
        Document doc;
        if (parent instanceof Document) {
            doc = (Document)parent;
        } else {
            doc = parent.getOwnerDocument();
        }
        Element element = doc.createElement("option");
        int size;
        if (this.name_ != null) {
            URelaxer.setAttributePropertyByString(element, "name", this.name_);
        }
        URelaxer.setElementPropertyByStringList(element, "short-name", this.shortName_);
        if (this.longName_ != null) {
            URelaxer.setElementPropertyByString(element, "long-name", this.longName_);
        }
        if (this.id_ != null) {
            URelaxer.setElementPropertyByBigInteger(element, "id", this.id_);
        }
        if (this.description_ != null) {
            URelaxer.setElementPropertyByString(element, "description", this.description_);
        }
        if (this.required_ != null) {
            URelaxer.setElementPropertyByBoolean(element, "required", this.required_);
        }
        if (this.optionChoice_ != null) {
            this.optionChoice_.makeElement(element);
        }
        if (this.children_ != null) {
            this.children_.makeElement(element);
        }
        parent.appendChild(element);
    }

    /**
     * Initializes the <code>Option</code> by the File <code>file</code>.
     *
     * @param file
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(File file) throws IOException, SAXException, ParserConfigurationException {
        setup(file.toURL());
    }

    /**
     * Initializes the <code>Option</code>
     * by the String representation of URI <code>uri</code>.
     *
     * @param uri
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(String uri) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(uri, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Option</code> by the URL <code>url</code>.
     *
     * @param url
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(URL url) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(url, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Option</code> by the InputStream <code>in</code>.
     *
     * @param in
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputStream in) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(in, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Option</code> by the InputSource <code>is</code>.
     *
     * @param is
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(InputSource is) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(is, UJAXP.FLAG_NONE));
    }

    /**
     * Initializes the <code>Option</code> by the Reader <code>reader</code>.
     *
     * @param reader
     * @exception IOException
     * @exception SAXException
     * @exception ParserConfigurationException
     */
    public void setup(Reader reader) throws IOException, SAXException, ParserConfigurationException {
        setup(UJAXP.getDocument(reader, UJAXP.FLAG_NONE));
    }

    /**
     * Creates a DOM document representation of the object.
     *
     * @exception ParserConfigurationException
     * @return Document
     */
    public Document makeDocument() throws ParserConfigurationException {
        Document doc = UJAXP.makeDocument();
        makeElement(doc);
        return (doc);
    }

    /**
     * Gets the String property <b>name</b>.
     *
     * @return String
     */
    public String getName() {
        return (name_);
    }

    /**
     * Sets the String property <b>name</b>.
     *
     * @param name
     */
    public void setName(String name) {
        this.name_ = name;
    }

    /**
     * Gets the String property <b>shortName</b>.
     *
     * @return String[]
     */
    public String[] getShortName() {
        String[] array = new String[shortName_.size()];
        return ((String[])shortName_.toArray(array));
    }

    /**
     * Sets the String property <b>shortName</b>.
     *
     * @param shortName
     */
    public void setShortName(String[] shortName) {
        this.shortName_.clear();
        for (int i = 0;i < shortName.length;i++) {
            addShortName(shortName[i]);
        }
    }

    /**
     * Sets the String property <b>shortName</b>.
     *
     * @param shortName
     */
    public void setShortName(String shortName) {
        this.shortName_.clear();
        addShortName(shortName);
    }

    /**
     * Adds the String property <b>shortName</b>.
     *
     * @param shortName
     */
    public void addShortName(String shortName) {
        this.shortName_.add(shortName);
    }

    /**
     * Adds the String property <b>shortName</b>.
     *
     * @param shortName
     */
    public void addShortName(String[] shortName) {
        for (int i = 0;i < shortName.length;i++) {
            addShortName(shortName[i]);
        }
    }

    /**
     * Gets number of the String property <b>shortName</b>.
     *
     * @return int
     */
    public int sizeShortName() {
        return (shortName_.size());
    }

    /**
     * Gets the String property <b>shortName</b> by index.
     *
     * @param index
     * @return String
     */
    public String getShortName(int index) {
        return ((String)shortName_.get(index));
    }

    /**
     * Sets the String property <b>shortName</b> by index.
     *
     * @param index
     * @param shortName
     */
    public void setShortName(int index, String shortName) {
        this.shortName_.set(index, shortName);
    }

    /**
     * Adds the String property <b>shortName</b> by index.
     *
     * @param index
     * @param shortName
     */
    public void addShortName(int index, String shortName) {
        this.shortName_.add(index, shortName);
    }

    /**
     * Remove the String property <b>shortName</b> by index.
     *
     * @param index
     */
    public void removeShortName(int index) {
        this.shortName_.remove(index);
    }

    /**
     * Remove the String property <b>shortName</b> by object.
     *
     * @param shortName
     */
    public void removeShortName(String shortName) {
        this.shortName_.remove(shortName);
    }

    /**
     * Clear the String property <b>shortName</b>.
     *
     */
    public void clearShortName() {
        this.shortName_.clear();
    }

    /**
     * Gets the String property <b>longName</b>.
     *
     * @return String
     */
    public String getLongName() {
        return (longName_);
    }

    /**
     * Sets the String property <b>longName</b>.
     *
     * @param longName
     */
    public void setLongName(String longName) {
        this.longName_ = longName;
    }

    /**
     * Gets the java.math.BigInteger property <b>id</b>.
     *
     * @return java.math.BigInteger
     */
    public java.math.BigInteger getId() {
        return (id_);
    }

    /**
     * Sets the java.math.BigInteger property <b>id</b>.
     *
     * @param id
     */
    public void setId(java.math.BigInteger id) {
        this.id_ = id;
    }

    /**
     * Gets the String property <b>description</b>.
     *
     * @return String
     */
    public String getDescription() {
        return (description_);
    }

    /**
     * Sets the String property <b>description</b>.
     *
     * @param description
     */
    public void setDescription(String description) {
        this.description_ = description;
    }

    /**
     * Gets the boolean property <b>required</b>.
     *
     * @return boolean
     */
    public boolean getRequired() {
        if (required_ == null) {
            return(false);
        }
        return (required_.booleanValue());
    }

    /**
     * Gets the boolean property <b>required</b>.
     *
     * @param required
     * @return boolean
     */
    public boolean getRequired(boolean required) {
        if (required_ == null) {
            return(required);
        }
        return (this.required_.booleanValue());
    }

    /**
     * Gets the boolean property <b>required</b>.
     *
     * @return Boolean
     */
    public Boolean getRequiredAsBoolean() {
        return (required_);
    }

    /**
     * Check the boolean property <b>required</b>.
     *
     * @return boolean
     */
    public boolean checkRequired() {
        return (required_ != null);
    }

    /**
     * Sets the boolean property <b>required</b>.
     *
     * @param required
     */
    public void setRequired(boolean required) {
        this.required_ = new Boolean(required);
    }

    /**
     * Sets the boolean property <b>required</b>.
     *
     * @param required
     */
    public void setRequired(Boolean required) {
        this.required_ = required;
    }

    /**
     * Gets the OptionChoice property <b>optionChoice</b>.
     *
     * @return OptionChoice
     */
    public OptionChoice getOptionChoice() {
        return (optionChoice_);
    }

    /**
     * Sets the OptionChoice property <b>optionChoice</b>.
     *
     * @param optionChoice
     */
    public void setOptionChoice(OptionChoice optionChoice) {
        this.optionChoice_ = optionChoice;
    }

    /**
     * Gets the Children property <b>children</b>.
     *
     * @return Children
     */
    public Children getChildren() {
        return (children_);
    }

    /**
     * Sets the Children property <b>children</b>.
     *
     * @param children
     */
    public void setChildren(Children children) {
        this.children_ = children;
    }

    /**
     * Makes an XML text representation.
     *
     * @return String
     */
    public String makeTextDocument() {
        StringBuffer buffer = new StringBuffer();
        makeTextElement(buffer);
        return (new String(buffer));
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(StringBuffer buffer) {
        int size;
        buffer.append("<option");
        if (name_ != null) {
            buffer.append(" name=\"");
            buffer.append(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.append("\"");
        }
        buffer.append(">");
        size = sizeShortName();
        for (int i = 0;i < size;i++) {
            buffer.append("<short-name>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getShortName(i))));
            buffer.append("</short-name>");
        }
        if (longName_ != null) {
            buffer.append("<long-name>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getLongName())));
            buffer.append("</long-name>");
        }
        if (id_ != null) {
            buffer.append("<id>");
            buffer.append(URelaxer.getString(getId()));
            buffer.append("</id>");
        }
        if (description_ != null) {
            buffer.append("<description>");
            buffer.append(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.append("</description>");
        }
        if (required_ != null) {
            buffer.append("<required>");
            buffer.append(URelaxer.getString(getRequired()));
            buffer.append("</required>");
        }
        if (optionChoice_ != null) {
            optionChoice_.makeTextElement(buffer);
        }
        if (children_ != null) {
            children_.makeTextElement(buffer);
        }
        buffer.append("</option>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextElement(Writer buffer) throws IOException {
        int size;
        buffer.write("<option");
        if (name_ != null) {
            buffer.write(" name=\"");
            buffer.write(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.write("\"");
        }
        buffer.write(">");
        size = sizeShortName();
        for (int i = 0;i < size;i++) {
            buffer.write("<short-name>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getShortName(i))));
            buffer.write("</short-name>");
        }
        if (longName_ != null) {
            buffer.write("<long-name>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getLongName())));
            buffer.write("</long-name>");
        }
        if (id_ != null) {
            buffer.write("<id>");
            buffer.write(URelaxer.getString(getId()));
            buffer.write("</id>");
        }
        if (description_ != null) {
            buffer.write("<description>");
            buffer.write(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.write("</description>");
        }
        if (required_ != null) {
            buffer.write("<required>");
            buffer.write(URelaxer.getString(getRequired()));
            buffer.write("</required>");
        }
        if (optionChoice_ != null) {
            optionChoice_.makeTextElement(buffer);
        }
        if (children_ != null) {
            children_.makeTextElement(buffer);
        }
        buffer.write("</option>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextElement(PrintWriter buffer) {
        int size;
        buffer.print("<option");
        if (name_ != null) {
            buffer.print(" name=\"");
            buffer.print(URelaxer.escapeAttrQuot(URelaxer.getString(getName())));
            buffer.print("\"");
        }
        buffer.print(">");
        size = sizeShortName();
        for (int i = 0;i < size;i++) {
            buffer.print("<short-name>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getShortName(i))));
            buffer.print("</short-name>");
        }
        if (longName_ != null) {
            buffer.print("<long-name>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getLongName())));
            buffer.print("</long-name>");
        }
        if (id_ != null) {
            buffer.print("<id>");
            buffer.print(URelaxer.getString(getId()));
            buffer.print("</id>");
        }
        if (description_ != null) {
            buffer.print("<description>");
            buffer.print(URelaxer.escapeCharData(URelaxer.getString(getDescription())));
            buffer.print("</description>");
        }
        if (required_ != null) {
            buffer.print("<required>");
            buffer.print(URelaxer.getString(getRequired()));
            buffer.print("</required>");
        }
        if (optionChoice_ != null) {
            optionChoice_.makeTextElement(buffer);
        }
        if (children_ != null) {
            children_.makeTextElement(buffer);
        }
        buffer.print("</option>");
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(StringBuffer buffer) {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     * @exception IOException
     */
    public void makeTextAttribute(Writer buffer) throws IOException {
    }

    /**
     * Makes an XML text representation.
     *
     * @param buffer
     */
    public void makeTextAttribute(PrintWriter buffer) {
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getNameAsString() {
        return (URelaxer.getString(getName()));
    }

    /**
     * Gets the property value as String array.
     *
     * @return String[]
     */
    public String[] getShortNameAsString() {
        int size = sizeShortName();
        String[] array = new String[size];
        for (int i = 0;i < size;i++) {
            array[i] = URelaxer.getString(getShortName(i));
        }
        return (array);
    }

    /**
     * Gets the property value by index as String.
     *
     * @param index
     * @return String
     */
    public String getShortNameAsString(int index) {
        return (URelaxer.getString(getShortName(index)));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getLongNameAsString() {
        return (URelaxer.getString(getLongName()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getIdAsString() {
        return (URelaxer.getString(getId()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getDescriptionAsString() {
        return (URelaxer.getString(getDescription()));
    }

    /**
     * Gets the property value as String.
     *
     * @return String
     */
    public String getRequiredAsString() {
        return (URelaxer.getString(getRequired()));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setNameByString(String string) {
        setName(string);
    }

    /**
     * Sets the property value by String array.
     *
     * @param strings
     */
    public void setShortNameByString(String[] strings) {
        if (strings.length > 0) {
            String string = strings[0];
            setShortName(string);
            for (int i = 1;i < strings.length;i++) {
                string = strings[i];
                addShortName(string);
            }
        }
    }

    /**
     * Sets the property value by String via index.
     *
     * @param index
     * @param value
     */
    public void setShortNameByString(int index, String value) {
        setShortName(index, value);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setLongNameByString(String string) {
        setLongName(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setIdByString(String string) {
        setId(new java.math.BigInteger(string));
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setDescriptionByString(String string) {
        setDescription(string);
    }

    /**
     * Sets the property value by String.
     *
     * @param string
     */
    public void setRequiredByString(String string) {
        setRequired(new Boolean(string).booleanValue());
    }

    /**
     * Adds the property value by String.
     *
     * @param string
     */
    public void addShortNameByString(String string) {
        addShortName(string);
    }

    /**
     * Returns a String representation of this object.
     * While this method informs as XML format representaion, 
     *  it's purpose is just information, not making 
     * a rigid XML documentation.
     *
     * @return String
     */
    public String toString() {
        try {
            return (makeTextDocument());
        } catch (Exception e) {
            return (super.toString());
        }
    }

    /**
     * Tests if a Element <code>element</code> is valid
     * for the <code>Option</code>.
     *
     * @param element
     * @return boolean
     */
    public static boolean isMatch(Element element) {
        if (!URelaxer.isTargetElement(element, "option")) {
            return (false);
        }
        RStack target = new RStack(element);
        boolean $match$ = false;
        Element child;
        RInterleave interleave;
        if (!URelaxer.hasAttributeHungry(target, "name")) {
            return (false);
        }
        $match$ = true;
        interleave = new RInterleave(target);
        interleave.addElementSlot("short-name", "*");
        interleave.addElementSlot("long-name", "?");
        interleave.addElementSlot("id", "?");
        interleave.addElementSlot("description", "?");
        interleave.addElementSlot("required", "?");
        interleave.addHedgeSlot(OptionChoice.class, "?");
        interleave.addElementSlot(Children.class, "?");
        if (interleave.isMatch()) {
            $match$ = true;
        }
        if (!target.isEmptyElement()) {
            return (false);
        }
        return (true);
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Option</code>.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatch(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        return (isMatch(element));
    }

    /**
     * Tests if elements contained in a Stack <code>stack</code>
     * is valid for the <code>Option</code>.
     * This method consumes the stack contents during matching operation.
     * This mehtod is supposed to be used internally
     * by the Relaxer system.
     *
     * @param stack
     * @return boolean
     */
    public static boolean isMatchHungry(RStack stack) {
        Element element = stack.peekElement();
        if (element == null) {
            return (false);
        }
        if (isMatch(element)) {
            stack.popElement();
            return (true);
        } else {
            return (false);
        }
    }
}
